/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.indices.recovery;

import java.io.Closeable;
import java.io.IOException;
import java.util.function.Consumer;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexCommit;
import org.graylog.shaded.opensearch2.org.opensearch.action.StepListener;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ThreadedActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.replication.ReplicationResponse;
import org.graylog.shaded.opensearch2.org.opensearch.common.SetOnce;
import org.graylog.shaded.opensearch2.org.opensearch.common.concurrent.GatedCloseable;
import org.graylog.shaded.opensearch2.org.opensearch.common.lease.Releasable;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.RecoveryEngineException;
import org.graylog.shaded.opensearch2.org.opensearch.index.seqno.RetentionLease;
import org.graylog.shaded.opensearch2.org.opensearch.index.seqno.RetentionLeaseNotFoundException;
import org.graylog.shaded.opensearch2.org.opensearch.index.seqno.RetentionLeases;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.IndexShard;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.Translog;
import org.graylog.shaded.opensearch2.org.opensearch.indices.RunUnderPrimaryPermit;
import org.graylog.shaded.opensearch2.org.opensearch.indices.recovery.RecoveryResponse;
import org.graylog.shaded.opensearch2.org.opensearch.indices.recovery.RecoverySourceHandler;
import org.graylog.shaded.opensearch2.org.opensearch.indices.recovery.RecoveryTargetHandler;
import org.graylog.shaded.opensearch2.org.opensearch.indices.recovery.StartRecoveryRequest;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;
import org.graylog.shaded.opensearch2.org.opensearch.transport.Transports;

public class LocalStorePeerRecoverySourceHandler
extends RecoverySourceHandler {
    public LocalStorePeerRecoverySourceHandler(IndexShard shard, RecoveryTargetHandler recoveryTarget, ThreadPool threadPool, StartRecoveryRequest request, int fileChunkSizeInBytes, int maxConcurrentFileChunks, int maxConcurrentOperations) {
        super(shard, recoveryTarget, threadPool, request, fileChunkSizeInBytes, maxConcurrentFileChunks, maxConcurrentOperations);
    }

    @Override
    protected void innerRecoveryToTarget(ActionListener<RecoveryResponse> listener, Consumer<Exception> onFailure) throws IOException {
        long startingSeqNo;
        boolean isSequenceNumberBasedRecovery;
        SetOnce<RetentionLease> retentionLeaseRef = new SetOnce<RetentionLease>();
        this.waitForAssignmentPropagate(retentionLeaseRef);
        Closeable retentionLock = this.shard.acquireHistoryRetentionLock();
        this.resources.add(retentionLock);
        boolean bl = isSequenceNumberBasedRecovery = this.request.startingSeqNo() != -2L && this.isTargetSameHistory() && this.shard.hasCompleteHistoryOperations("peer-recovery", this.request.startingSeqNo()) && (retentionLeaseRef.get() == null && !this.shard.useRetentionLeasesInPeerRecovery() || retentionLeaseRef.get() != null && retentionLeaseRef.get().retainingSequenceNumber() <= this.request.startingSeqNo());
        if (isSequenceNumberBasedRecovery && retentionLeaseRef.get() != null) {
            retentionLock.close();
            this.logger.trace("history is retained by {}", (Object)retentionLeaseRef.get());
        } else {
            this.logger.trace("history is retained by retention lock");
        }
        StepListener<RecoverySourceHandler.SendFileResult> sendFileStep = new StepListener<RecoverySourceHandler.SendFileResult>();
        StepListener<TimeValue> prepareEngineStep = new StepListener<TimeValue>();
        StepListener<RecoverySourceHandler.SendSnapshotResult> sendSnapshotStep = new StepListener<RecoverySourceHandler.SendSnapshotResult>();
        if (isSequenceNumberBasedRecovery) {
            this.logger.trace("performing sequence numbers based recovery. starting at [{}]", (Object)this.request.startingSeqNo());
            startingSeqNo = this.request.startingSeqNo();
            if (retentionLeaseRef.get() == null) {
                this.createRetentionLease(startingSeqNo, ActionListener.map(sendFileStep, ignored -> RecoverySourceHandler.SendFileResult.EMPTY));
            } else {
                sendFileStep.onResponse(RecoverySourceHandler.SendFileResult.EMPTY);
            }
        } else {
            GatedCloseable<IndexCommit> wrappedSafeCommit;
            try {
                wrappedSafeCommit = this.acquireSafeCommit(this.shard);
                this.resources.add(wrappedSafeCommit);
            }
            catch (Exception e) {
                throw new RecoveryEngineException(this.shard.shardId(), 1, "snapshot failed", e);
            }
            startingSeqNo = Long.parseLong(wrappedSafeCommit.get().getUserData().get("local_checkpoint")) + 1L;
            this.logger.trace("performing file-based recovery followed by history replay starting at [{}]", (Object)startingSeqNo);
            try {
                int estimateNumOps = this.countNumberOfHistoryOperations(startingSeqNo);
                Releasable releaseStore = this.acquireStore(this.shard.store());
                this.resources.add(releaseStore);
                this.onSendFileStepComplete(sendFileStep, wrappedSafeCommit, releaseStore);
                StepListener<ReplicationResponse> deleteRetentionLeaseStep = new StepListener<ReplicationResponse>();
                RunUnderPrimaryPermit.run(() -> {
                    try {
                        this.shard.removePeerRecoveryRetentionLease(this.request.targetNode().getId(), new ThreadedActionListener<ReplicationResponse>(this.logger, this.shard.getThreadPool(), "generic", deleteRetentionLeaseStep, false));
                    }
                    catch (RetentionLeaseNotFoundException e) {
                        this.logger.debug("no peer-recovery retention lease for " + this.request.targetAllocationId());
                        deleteRetentionLeaseStep.onResponse(null);
                    }
                }, this.shardId + " removing retention lease for [" + this.request.targetAllocationId() + "]", this.shard, this.cancellableThreads, this.logger);
                deleteRetentionLeaseStep.whenComplete(ignored -> {
                    this.logger.debug("deleteRetentionLeaseStep completed");
                    assert (Transports.assertNotTransportThread(String.valueOf(this) + "[phase1]"));
                    this.phase1((IndexCommit)wrappedSafeCommit.get(), startingSeqNo, () -> estimateNumOps, sendFileStep, false);
                }, onFailure);
            }
            catch (Exception e) {
                throw new RecoveryEngineException(this.shard.shardId(), 1, "sendFileStep failed", e);
            }
        }
        assert (startingSeqNo >= 0L) : "startingSeqNo must be non negative. got: " + startingSeqNo;
        sendFileStep.whenComplete(r -> {
            this.logger.debug("sendFileStep completed");
            assert (Transports.assertNotTransportThread(String.valueOf(this) + "[prepareTargetForTranslog]"));
            this.prepareTargetForTranslog(this.countNumberOfHistoryOperations(startingSeqNo), prepareEngineStep);
        }, onFailure);
        prepareEngineStep.whenComplete(prepareEngineTime -> {
            this.logger.debug("prepareEngineStep completed");
            assert (Transports.assertNotTransportThread(String.valueOf(this) + "[phase2]"));
            RunUnderPrimaryPermit.run(() -> this.shard.initiateTracking(this.request.targetAllocationId()), this.shardId + " initiating tracking of " + this.request.targetAllocationId(), this.shard, this.cancellableThreads, this.logger);
            long endingSeqNo = this.shard.seqNoStats().getMaxSeqNo();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("snapshot translog for recovery; current size is [{}]", (Object)this.countNumberOfHistoryOperations(startingSeqNo));
            }
            Translog.Snapshot phase2Snapshot = this.shard.newChangesSnapshot("peer-recovery", startingSeqNo, Long.MAX_VALUE, false, true);
            this.resources.add(phase2Snapshot);
            retentionLock.close();
            long maxSeenAutoIdTimestamp = this.shard.getMaxSeenAutoIdTimestamp();
            long maxSeqNoOfUpdatesOrDeletes = this.shard.getMaxSeqNoOfUpdatesOrDeletes();
            RetentionLeases retentionLeases = this.shard.getRetentionLeases();
            long mappingVersionOnPrimary = this.shard.indexSettings().getIndexMetadata().getMappingVersion();
            this.phase2(startingSeqNo, endingSeqNo, phase2Snapshot, maxSeenAutoIdTimestamp, maxSeqNoOfUpdatesOrDeletes, retentionLeases, mappingVersionOnPrimary, sendSnapshotStep);
        }, onFailure);
        this.finalizeStepAndCompleteFuture(startingSeqNo, sendSnapshotStep, sendFileStep, prepareEngineStep, onFailure);
    }
}

