/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.indices.recovery;

import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.ShardRouting;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.indices.cluster.IndicesClusterStateService;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.common.ReplicationFailedException;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.common.ReplicationListener;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.common.ReplicationState;

@PublicApi(since="2.2.0")
public class RecoveryListener
implements ReplicationListener {
    private final ShardRouting shardRouting;
    private final long primaryTerm;
    private final IndicesClusterStateService indicesClusterStateService;

    public RecoveryListener(ShardRouting shardRouting, long primaryTerm, IndicesClusterStateService indicesClusterStateService) {
        this.shardRouting = shardRouting;
        this.primaryTerm = primaryTerm;
        this.indicesClusterStateService = indicesClusterStateService;
    }

    @Override
    public void onDone(ReplicationState state) {
        this.indicesClusterStateService.handleRecoveryDone(state, this.shardRouting, this.primaryTerm);
    }

    @Override
    public void onFailure(ReplicationState state, ReplicationFailedException e, boolean sendShardFailure) {
        this.indicesClusterStateService.handleRecoveryFailure(this.shardRouting, sendShardFailure, e);
    }
}

