/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.indices.recovery;

import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.opensearch.ExceptionsHelper;
import org.graylog.shaded.opensearch2.org.opensearch.LegacyESVersion;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionListenerResponseHandler;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.RetryableAction;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.CancellableThreads;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.ConcurrentCollections;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.breaker.CircuitBreakingException;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.core.concurrency.OpenSearchRejectedExecutionException;
import org.graylog.shaded.opensearch2.org.opensearch.core.transport.TransportResponse;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;
import org.graylog.shaded.opensearch2.org.opensearch.transport.ConnectTransportException;
import org.graylog.shaded.opensearch2.org.opensearch.transport.RemoteTransportException;
import org.graylog.shaded.opensearch2.org.opensearch.transport.SendRequestTransportException;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportRequest;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportRequestOptions;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

public final class RetryableTransportClient {
    private final ThreadPool threadPool;
    private final Map<Object, RetryableAction<?>> onGoingRetryableActions = ConcurrentCollections.newConcurrentMap();
    private volatile boolean isCancelled = false;
    private final TransportService transportService;
    private final TimeValue retryTimeout;
    private final DiscoveryNode targetNode;
    private final Logger logger;

    public RetryableTransportClient(TransportService transportService, DiscoveryNode targetNode, TimeValue retryTimeout, Logger logger) {
        this.threadPool = transportService.getThreadPool();
        this.transportService = transportService;
        this.retryTimeout = retryTimeout;
        this.targetNode = targetNode;
        this.logger = logger;
    }

    public <T extends TransportResponse> void executeRetryableAction(String action, TransportRequest request, ActionListener<T> actionListener, Writeable.Reader<T> reader) {
        TransportRequestOptions options = TransportRequestOptions.builder().withTimeout(this.retryTimeout).build();
        this.executeRetryableAction(action, request, options, actionListener, reader);
    }

    public <T extends TransportResponse> void executeRetryableAction(final String action, final TransportRequest request, final TransportRequestOptions options, ActionListener<T> actionListener, final Writeable.Reader<T> reader) {
        Object key = new Object();
        ActionListener<T> removeListener = ActionListener.runBefore(actionListener, () -> this.onGoingRetryableActions.remove(key));
        TimeValue initialDelay = TimeValue.timeValueMillis(200L);
        RetryableAction retryableAction = new RetryableAction<T>(this.logger, this.threadPool, initialDelay, this.retryTimeout, removeListener){

            @Override
            public void tryAction(ActionListener<T> listener) {
                RetryableTransportClient.this.transportService.sendRequest(RetryableTransportClient.this.targetNode, action, request, options, new ActionListenerResponseHandler(listener, reader, "generic"));
            }

            @Override
            public boolean shouldRetry(Exception e) {
                return RetryableTransportClient.this.targetNode.getVersion().onOrAfter(LegacyESVersion.V_7_9_0) && RetryableTransportClient.retryableException(e);
            }
        };
        this.onGoingRetryableActions.put(key, retryableAction);
        retryableAction.run();
        if (this.isCancelled) {
            retryableAction.cancel(new CancellableThreads.ExecutionCancelledException("retryable action was cancelled"));
        }
    }

    public void cancel() {
        this.isCancelled = true;
        if (this.onGoingRetryableActions.isEmpty()) {
            return;
        }
        CancellableThreads.ExecutionCancelledException exception = new CancellableThreads.ExecutionCancelledException("retryable action was cancelled");
        this.threadPool.generic().execute(() -> {
            for (RetryableAction<?> action : this.onGoingRetryableActions.values()) {
                action.cancel(exception);
            }
            this.onGoingRetryableActions.clear();
        });
    }

    private static boolean retryableException(Exception e) {
        if (e instanceof ConnectTransportException) {
            return true;
        }
        if (e instanceof SendRequestTransportException) {
            Throwable cause = ExceptionsHelper.unwrapCause(e);
            return cause instanceof ConnectTransportException;
        }
        if (e instanceof RemoteTransportException) {
            Throwable cause = ExceptionsHelper.unwrapCause(e);
            return cause instanceof CircuitBreakingException || cause instanceof OpenSearchRejectedExecutionException;
        }
        return false;
    }
}

