/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.indices.replication;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.RateLimiter;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.bytes.BytesReference;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.core.transport.TransportResponse;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.StoreFileMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.indices.recovery.FileChunkRequest;
import org.graylog.shaded.opensearch2.org.opensearch.indices.recovery.FileChunkWriter;
import org.graylog.shaded.opensearch2.org.opensearch.indices.recovery.RecoverySettings;
import org.graylog.shaded.opensearch2.org.opensearch.indices.recovery.RetryableTransportClient;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportRequestOptions;

public final class RemoteSegmentFileChunkWriter
implements FileChunkWriter {
    private final AtomicLong requestSeqNoGenerator;
    private final RetryableTransportClient retryableTransportClient;
    private final ShardId shardId;
    private final long replicationId;
    private final AtomicLong bytesSinceLastPause = new AtomicLong();
    private final TransportRequestOptions fileChunkRequestOptions;
    private final Consumer<Long> onSourceThrottle;
    private final Supplier<RateLimiter> rateLimiterSupplier;
    private final String action;

    public RemoteSegmentFileChunkWriter(long replicationId, RecoverySettings recoverySettings, RetryableTransportClient retryableTransportClient, ShardId shardId, String action, AtomicLong requestSeqNoGenerator, Consumer<Long> onSourceThrottle, Supplier<RateLimiter> rateLimiterSupplier) {
        this.replicationId = replicationId;
        this.retryableTransportClient = retryableTransportClient;
        this.shardId = shardId;
        this.requestSeqNoGenerator = requestSeqNoGenerator;
        this.onSourceThrottle = onSourceThrottle;
        this.rateLimiterSupplier = rateLimiterSupplier;
        this.fileChunkRequestOptions = TransportRequestOptions.builder().withType(TransportRequestOptions.Type.RECOVERY).withTimeout(recoverySettings.internalActionTimeout()).build();
        this.action = action;
    }

    @Override
    public void writeFileChunk(StoreFileMetadata fileMetadata, long position, BytesReference content, boolean lastChunk, int totalTranslogOps, ActionListener<Void> listener) {
        long throttleTimeInNanos;
        RateLimiter rl = this.rateLimiterSupplier.get();
        if (rl != null) {
            long bytes = this.bytesSinceLastPause.addAndGet(content.length());
            if (bytes > rl.getMinPauseCheckBytes()) {
                this.bytesSinceLastPause.addAndGet(-bytes);
                try {
                    throttleTimeInNanos = rl.pause(bytes);
                    this.onSourceThrottle.accept(throttleTimeInNanos);
                }
                catch (IOException e) {
                    throw new OpenSearchException("failed to pause recovery", (Throwable)e, new Object[0]);
                }
            } else {
                throttleTimeInNanos = 0L;
            }
        } else {
            throttleTimeInNanos = 0L;
        }
        long requestSeqNo = this.requestSeqNoGenerator.getAndIncrement();
        FileChunkRequest request = new FileChunkRequest(this.replicationId, requestSeqNo, this.shardId, fileMetadata, position, content, lastChunk, totalTranslogOps, throttleTimeInNanos);
        Writeable.Reader<TransportResponse.Empty> reader = in -> TransportResponse.Empty.INSTANCE;
        this.retryableTransportClient.executeRetryableAction(this.action, request, this.fileChunkRequestOptions, ActionListener.map(listener, r -> null), reader);
    }

    @Override
    public void cancel() {
        this.retryableTransportClient.cancel();
    }
}

