/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.indices.replication.checkpoint;

import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.AlreadyClosedException;
import org.graylog.shaded.opensearch2.org.opensearch.ExceptionsHelper;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ActionFilters;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.replication.ReplicationMode;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.replication.ReplicationResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.replication.ReplicationTask;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.replication.TransportReplicationAction;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.action.shard.ShardStateAction;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.Inject;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.ThreadContext;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.ThreadContextAccess;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.index.IndexNotFoundException;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.IndexShard;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.IndexShardClosedException;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.ShardNotInPrimaryModeException;
import org.graylog.shaded.opensearch2.org.opensearch.indices.IndicesService;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.SegmentReplicationTargetService;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.checkpoint.PublishCheckpointRequest;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.checkpoint.ReplicationCheckpoint;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.common.ReplicationTimer;
import org.graylog.shaded.opensearch2.org.opensearch.node.NodeClosedException;
import org.graylog.shaded.opensearch2.org.opensearch.tasks.Task;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportException;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportResponseHandler;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

@PublicApi(since="2.2.0")
public class PublishCheckpointAction
extends TransportReplicationAction<PublishCheckpointRequest, PublishCheckpointRequest, ReplicationResponse> {
    public static final String ACTION_NAME = "indices:admin/publishCheckpoint";
    protected static Logger logger = LogManager.getLogger(PublishCheckpointAction.class);
    private final SegmentReplicationTargetService replicationService;

    @Inject
    public PublishCheckpointAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, ActionFilters actionFilters, SegmentReplicationTargetService targetService) {
        super(settings, ACTION_NAME, transportService, clusterService, indicesService, threadPool, shardStateAction, actionFilters, PublishCheckpointRequest::new, PublishCheckpointRequest::new, "refresh");
        this.replicationService = targetService;
    }

    @Override
    protected ReplicationResponse newResponseInstance(StreamInput in) throws IOException {
        return new ReplicationResponse(in);
    }

    @Override
    protected void doExecute(Task task, PublishCheckpointRequest request, ActionListener<ReplicationResponse> listener) {
        assert (false) : "use PublishCheckpointAction#publish";
    }

    @Override
    public ReplicationMode getReplicationMode(IndexShard indexShard) {
        if (indexShard.indexSettings().isAssignedOnRemoteNode()) {
            return ReplicationMode.FULL_REPLICATION;
        }
        return super.getReplicationMode(indexShard);
    }

    final void publish(final IndexShard indexShard, final ReplicationCheckpoint checkpoint) {
        String primaryAllocationId = indexShard.routingEntry().allocationId().getId();
        long primaryTerm = indexShard.getPendingPrimaryTerm();
        ThreadContext threadContext = this.threadPool.getThreadContext();
        try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
            ThreadContextAccess.doPrivilegedVoid(threadContext::markAsSystemContext);
            PublishCheckpointRequest request = new PublishCheckpointRequest(checkpoint);
            final ReplicationTask task = (ReplicationTask)this.taskManager.register("transport", "segrep_publish_checkpoint", request);
            final ReplicationTimer timer = new ReplicationTimer();
            timer.start();
            this.transportService.sendChildRequest(indexShard.recoveryState().getTargetNode(), this.transportPrimaryAction, new TransportReplicationAction.ConcreteShardRequest<PublishCheckpointRequest>(request, primaryAllocationId, primaryTerm), (Task)task, this.transportOptions, new TransportResponseHandler<ReplicationResponse>(){

                @Override
                public ReplicationResponse read(StreamInput in) throws IOException {
                    return PublishCheckpointAction.this.newResponseInstance(in);
                }

                @Override
                public String executor() {
                    return "same";
                }

                @Override
                public void handleResponse(ReplicationResponse response) {
                    timer.stop();
                    logger.debug(() -> new ParameterizedMessage("[shardId {}] Completed publishing checkpoint [{}], timing: {}", new Object[]{indexShard.shardId().getId(), checkpoint, timer.time()}));
                    task.setPhase("finished");
                    PublishCheckpointAction.this.taskManager.unregister(task);
                }

                @Override
                public void handleException(TransportException e) {
                    timer.stop();
                    logger.debug("[shardId {}] Failed to publish checkpoint, timing: {}", (Object)indexShard.shardId().getId(), (Object)timer.time());
                    task.setPhase("finished");
                    PublishCheckpointAction.this.taskManager.unregister(task);
                    if (ExceptionsHelper.unwrap(e, NodeClosedException.class, IndexNotFoundException.class, AlreadyClosedException.class, IndexShardClosedException.class, ShardNotInPrimaryModeException.class) != null) {
                        return;
                    }
                    logger.warn((Message)new ParameterizedMessage("{} segment replication checkpoint publishing failed", (Object)indexShard.shardId()), (Throwable)e);
                }
            });
            logger.trace(() -> new ParameterizedMessage("[shardId {}] Publishing replication checkpoint [{}]", (Object)checkpoint.getShardId().getId(), (Object)checkpoint));
        }
    }

    @Override
    protected void shardOperationOnPrimary(PublishCheckpointRequest request, IndexShard primary, ActionListener<TransportReplicationAction.PrimaryResult<PublishCheckpointRequest, ReplicationResponse>> listener) {
        ActionListener.completeWith(listener, () -> new TransportReplicationAction.PrimaryResult<PublishCheckpointRequest, ReplicationResponse>(request, new ReplicationResponse()));
    }

    @Override
    protected void shardOperationOnReplica(PublishCheckpointRequest request, IndexShard replica, ActionListener<TransportReplicationAction.ReplicaResult> listener) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(replica);
        ActionListener.completeWith(listener, () -> {
            logger.trace(() -> new ParameterizedMessage("Checkpoint {} received on replica {}", (Object)request, (Object)replica.shardId()));
            if (!replica.indexSettings().isAssignedOnRemoteNode() && !replica.indexSettings().isSegRepLocalEnabled()) {
                logger.trace("Received segrep checkpoint on a docrep shard copy during an ongoing remote migration. NoOp.");
                return new TransportReplicationAction.ReplicaResult();
            }
            if (request.getCheckpoint().getShardId().equals(replica.shardId())) {
                this.replicationService.onNewCheckpoint(request.getCheckpoint(), replica);
            }
            return new TransportReplicationAction.ReplicaResult();
        });
    }
}

