/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.indices.replication.common;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.common.ReplicationTimer;

public class SegmentReplicationLagTimer
extends ReplicationTimer {
    private long creationTime;

    public SegmentReplicationLagTimer() {
        this.creationTime = System.nanoTime();
    }

    public SegmentReplicationLagTimer(StreamInput in) throws IOException {
        super(in);
        this.creationTime = in.readVLong();
    }

    @Override
    public synchronized void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVLong(this.creationTime);
    }

    public long totalElapsedTime() {
        return TimeValue.nsecToMSec(Math.max(System.nanoTime() - this.creationTime, 0L));
    }
}

