/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.ingest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.graylog.shaded.opensearch2.org.opensearch.ingest.AbstractProcessor;
import org.graylog.shaded.opensearch2.org.opensearch.ingest.ConfigurationUtils;
import org.graylog.shaded.opensearch2.org.opensearch.ingest.IngestDocumentWrapper;
import org.graylog.shaded.opensearch2.org.opensearch.ingest.Processor;

public abstract class AbstractBatchingProcessor
extends AbstractProcessor {
    public static final String BATCH_SIZE_FIELD = "batch_size";
    private static final int DEFAULT_BATCH_SIZE = 1;
    protected final int batchSize;

    protected AbstractBatchingProcessor(String tag, String description, int batchSize) {
        super(tag, description);
        this.batchSize = batchSize;
    }

    protected abstract void subBatchExecute(List<IngestDocumentWrapper> var1, Consumer<List<IngestDocumentWrapper>> var2);

    @Override
    public void batchExecute(List<IngestDocumentWrapper> ingestDocumentWrappers, Consumer<List<IngestDocumentWrapper>> handler) {
        if (ingestDocumentWrappers.isEmpty()) {
            handler.accept(Collections.emptyList());
            return;
        }
        if (this.batchSize >= ingestDocumentWrappers.size()) {
            this.subBatchExecute(ingestDocumentWrappers, handler);
            return;
        }
        List<List<IngestDocumentWrapper>> batches = this.cutBatches(ingestDocumentWrappers);
        int size = ingestDocumentWrappers.size();
        AtomicInteger counter = new AtomicInteger(size);
        List allResults = Collections.synchronizedList(new ArrayList());
        for (List<IngestDocumentWrapper> batch : batches) {
            this.subBatchExecute(batch, batchResults -> {
                allResults.addAll(batchResults);
                if (counter.addAndGet(-batchResults.size()) == 0) {
                    handler.accept(allResults);
                }
                assert (counter.get() >= 0) : "counter is negative";
            });
        }
    }

    private List<List<IngestDocumentWrapper>> cutBatches(List<IngestDocumentWrapper> ingestDocumentWrappers) {
        ArrayList<List<IngestDocumentWrapper>> batches = new ArrayList<List<IngestDocumentWrapper>>();
        for (int i = 0; i < ingestDocumentWrappers.size(); i += this.batchSize) {
            batches.add(ingestDocumentWrappers.subList(i, Math.min(i + this.batchSize, ingestDocumentWrappers.size())));
        }
        return batches;
    }

    public static abstract class Factory
    implements Processor.Factory {
        final String processorType;

        protected Factory(String processorType) {
            this.processorType = processorType;
        }

        @Override
        public AbstractBatchingProcessor create(Map<String, Processor.Factory> processorFactories, String tag, String description, Map<String, Object> config) throws Exception {
            int batchSize = ConfigurationUtils.readIntProperty(this.processorType, tag, config, AbstractBatchingProcessor.BATCH_SIZE_FIELD, 1);
            if (batchSize < 1) {
                throw ConfigurationUtils.newConfigurationException(this.processorType, tag, AbstractBatchingProcessor.BATCH_SIZE_FIELD, "batch size must be a positive integer");
            }
            return this.newProcessor(tag, description, batchSize, config);
        }

        protected abstract AbstractBatchingProcessor newProcessor(String var1, String var2, int var3, Map<String, Object> var4);
    }
}

