/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.ingest;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import org.graylog.shaded.opensearch2.org.opensearch.client.Client;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.AtomicArray;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.ThreadContext;
import org.graylog.shaded.opensearch2.org.opensearch.env.Environment;
import org.graylog.shaded.opensearch2.org.opensearch.index.analysis.AnalysisRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.indices.IndicesService;
import org.graylog.shaded.opensearch2.org.opensearch.ingest.IngestDocument;
import org.graylog.shaded.opensearch2.org.opensearch.ingest.IngestDocumentWrapper;
import org.graylog.shaded.opensearch2.org.opensearch.ingest.IngestService;
import org.graylog.shaded.opensearch2.org.opensearch.script.ScriptService;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.Scheduler;

public interface Processor {
    default public void execute(IngestDocument ingestDocument, BiConsumer<IngestDocument, Exception> handler) {
        IngestDocument result;
        try {
            result = this.execute(ingestDocument);
        }
        catch (Exception e) {
            handler.accept(null, e);
            return;
        }
        handler.accept(result, null);
    }

    public IngestDocument execute(IngestDocument var1) throws Exception;

    default public void batchExecute(List<IngestDocumentWrapper> ingestDocumentWrappers, Consumer<List<IngestDocumentWrapper>> handler) {
        if (ingestDocumentWrappers.isEmpty()) {
            handler.accept(Collections.emptyList());
            return;
        }
        int size = ingestDocumentWrappers.size();
        AtomicInteger counter = new AtomicInteger(size);
        AtomicArray<IngestDocumentWrapper> results = new AtomicArray<IngestDocumentWrapper>(size);
        for (int i = 0; i < size; ++i) {
            this.innerExecute(i, ingestDocumentWrappers.get(i), results, counter, handler);
        }
    }

    private void innerExecute(int slot, IngestDocumentWrapper ingestDocumentWrapper, AtomicArray<IngestDocumentWrapper> results, AtomicInteger counter, Consumer<List<IngestDocumentWrapper>> handler) {
        this.execute(ingestDocumentWrapper.getIngestDocument(), (doc, ex) -> {
            results.set(slot, new IngestDocumentWrapper(ingestDocumentWrapper.getSlot(), (IngestDocument)doc, (Exception)ex));
            if (counter.decrementAndGet() == 0) {
                handler.accept(results.asList());
            }
        });
    }

    public String getType();

    public String getTag();

    public String getDescription();

    public static class Parameters {
        public final Environment env;
        public final ScriptService scriptService;
        public final AnalysisRegistry analysisRegistry;
        public final ThreadContext threadContext;
        public final LongSupplier relativeTimeSupplier;
        public final IngestService ingestService;
        public final Consumer<Runnable> genericExecutor;
        public final BiFunction<Long, Runnable, Scheduler.ScheduledCancellable> scheduler;
        public final Client client;
        public final IndicesService indicesService;

        public Parameters(Environment env, ScriptService scriptService, AnalysisRegistry analysisRegistry, ThreadContext threadContext, LongSupplier relativeTimeSupplier, BiFunction<Long, Runnable, Scheduler.ScheduledCancellable> scheduler, IngestService ingestService, Client client, Consumer<Runnable> genericExecutor, IndicesService indicesService) {
            this.env = env;
            this.scriptService = scriptService;
            this.threadContext = threadContext;
            this.analysisRegistry = analysisRegistry;
            this.relativeTimeSupplier = relativeTimeSupplier;
            this.scheduler = scheduler;
            this.ingestService = ingestService;
            this.client = client;
            this.genericExecutor = genericExecutor;
            this.indicesService = indicesService;
        }
    }

    public static interface Factory {
        public Processor create(Map<String, Factory> var1, String var2, String var3, Map<String, Object> var4) throws Exception;
    }
}

