/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.node.remotestore;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.ExperimentalApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.blobstore.BlobContainer;
import org.graylog.shaded.opensearch2.org.opensearch.common.blobstore.BlobMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.common.collect.Tuple;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.AbstractAsyncTask;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.indices.RemoteStoreSettings;
import org.graylog.shaded.opensearch2.org.opensearch.node.remotestore.RemoteStoreNodeAttribute;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.RepositoriesService;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.Repository;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.blobstore.BlobStoreRepository;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;

@ExperimentalApi
public class RemoteStorePinnedTimestampService
implements Closeable {
    private static final Logger logger = LogManager.getLogger(RemoteStorePinnedTimestampService.class);
    private static Tuple<Long, Set<Long>> pinnedTimestampsSet = new Tuple(-1L, Set.of());
    private static Map<String, List<Long>> pinnedEntityToTimestampsMap = new HashMap<String, List<Long>>();
    public static final String PINNED_TIMESTAMPS_PATH_TOKEN = "pinned_timestamps";
    public static final String PINNED_TIMESTAMPS_FILENAME_SEPARATOR = "__";
    private final Supplier<RepositoriesService> repositoriesService;
    private final Settings settings;
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private BlobContainer blobContainer;
    private AsyncUpdatePinnedTimestampTask asyncUpdatePinnedTimestampTask;

    public RemoteStorePinnedTimestampService(Supplier<RepositoriesService> repositoriesService, Settings settings, ThreadPool threadPool, ClusterService clusterService) {
        this.repositoriesService = repositoriesService;
        this.settings = settings;
        this.threadPool = threadPool;
        this.clusterService = clusterService;
    }

    public void start() {
        this.blobContainer = RemoteStorePinnedTimestampService.validateAndCreateBlobContainer(this.settings, this.repositoriesService.get());
        this.startAsyncUpdateTask(RemoteStoreSettings.getPinnedTimestampsSchedulerInterval());
    }

    private static BlobContainer validateAndCreateBlobContainer(Settings settings, RepositoriesService repositoriesService) {
        String remoteStoreRepo = RemoteStoreNodeAttribute.getRemoteStoreSegmentRepo(settings);
        assert (remoteStoreRepo != null) : "Remote Segment Store repository is not configured";
        Repository repository = repositoriesService.repository(remoteStoreRepo);
        assert (repository instanceof BlobStoreRepository) : "Repository should be instance of BlobStoreRepository";
        BlobStoreRepository blobStoreRepository = (BlobStoreRepository)repository;
        return blobStoreRepository.blobStore().blobContainer(blobStoreRepository.basePath().add(PINNED_TIMESTAMPS_PATH_TOKEN));
    }

    private void startAsyncUpdateTask(TimeValue pinnedTimestampsSchedulerInterval) {
        this.asyncUpdatePinnedTimestampTask = new AsyncUpdatePinnedTimestampTask(logger, this.threadPool, pinnedTimestampsSchedulerInterval, true);
    }

    public static Map<String, Set<Long>> fetchPinnedTimestamps(Settings settings, RepositoriesService repositoriesService) throws IOException {
        BlobContainer blobContainer = RemoteStorePinnedTimestampService.validateAndCreateBlobContainer(settings, repositoriesService);
        Set<String> pinnedTimestamps = blobContainer.listBlobs().keySet();
        HashMap<String, Set<Long>> pinningEntityTimestampMap = new HashMap<String, Set<Long>>();
        for (String pinnedTimestamp : pinnedTimestamps) {
            try {
                String[] tokens = pinnedTimestamp.split(PINNED_TIMESTAMPS_FILENAME_SEPARATOR);
                Long timestamp = Long.parseLong(tokens[tokens.length - 1]);
                String pinningEntity = pinnedTimestamp.substring(0, pinnedTimestamp.lastIndexOf(PINNED_TIMESTAMPS_FILENAME_SEPARATOR));
                if (!pinningEntityTimestampMap.containsKey(pinningEntity)) {
                    pinningEntityTimestampMap.put(pinningEntity, new HashSet());
                }
                ((Set)pinningEntityTimestampMap.get(pinningEntity)).add(timestamp);
            }
            catch (NumberFormatException e) {
                logger.error("Exception while parsing pinned timestamp from {}, skipping this entry", (Object)pinnedTimestamp);
            }
        }
        return pinningEntityTimestampMap;
    }

    public void pinTimestamp(long timestamp, String pinningEntity, ActionListener<Void> listener) {
        try {
            long lookbackIntervalInMills = RemoteStoreSettings.getPinnedTimestampsLookbackInterval().millis();
            if (timestamp < System.currentTimeMillis() - lookbackIntervalInMills) {
                throw new IllegalArgumentException("Timestamp to be pinned is less than current timestamp - value of cluster.remote_store.pinned_timestamps.lookback_interval");
            }
            long startTime = System.nanoTime();
            logger.debug("Pinning timestamp = {} against entity = {}", (Object)timestamp, (Object)pinningEntity);
            this.blobContainer.writeBlob(this.getBlobName(timestamp, pinningEntity), new ByteArrayInputStream(new byte[0]), 0L, true);
            long elapsedTime = System.nanoTime() - startTime;
            if (elapsedTime > RemoteStoreSettings.getPinnedTimestampsLookbackInterval().nanos()) {
                String errorMessage = String.format(Locale.ROOT, "Timestamp pinning took %s nanoseconds which is more than limit of %s nanoseconds, failing the operation", elapsedTime, RemoteStoreSettings.getPinnedTimestampsLookbackInterval().nanos());
                logger.error(errorMessage);
                this.unpinTimestamp(timestamp, pinningEntity, ActionListener.wrap(() -> listener.onFailure(new RuntimeException(errorMessage))));
            } else {
                listener.onResponse(null);
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void cloneTimestamp(long timestamp, String existingPinningEntity, String newPinningEntity, ActionListener<Void> listener) {
        try {
            logger.debug("cloning timestamp = {} with existing pinningEntity = {} with new pinningEntity = {}", (Object)timestamp, (Object)existingPinningEntity, (Object)newPinningEntity);
            String blobName = this.getBlobName(timestamp, existingPinningEntity);
            if (this.blobContainer.blobExists(blobName)) {
                logger.debug("Pinning timestamp = {} against entity = {}", (Object)timestamp, (Object)newPinningEntity);
                this.blobContainer.writeBlob(this.getBlobName(timestamp, newPinningEntity), new ByteArrayInputStream(new byte[0]), 0L, true);
                listener.onResponse(null);
            } else {
                String errorMessage = String.format(Locale.ROOT, "Timestamp: %s is not pinned by existing entity: %s", timestamp, existingPinningEntity);
                logger.error(errorMessage);
                listener.onFailure(new IllegalArgumentException(errorMessage));
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private String getBlobName(long timestamp, String pinningEntity) {
        return String.join((CharSequence)PINNED_TIMESTAMPS_FILENAME_SEPARATOR, pinningEntity, String.valueOf(timestamp));
    }

    private long getTimestampFromBlobName(String blobName) {
        String[] blobNameTokens = blobName.split(PINNED_TIMESTAMPS_FILENAME_SEPARATOR);
        if (blobNameTokens.length < 2) {
            logger.error("Pinned timestamps blob name contains invalid format: {}", (Object)blobName);
        }
        try {
            return Long.parseLong(blobNameTokens[blobNameTokens.length - 1]);
        }
        catch (NumberFormatException e) {
            logger.error(() -> new ParameterizedMessage("Pinned timestamps blob name contains invalid format: {}", (Object)blobName), (Throwable)e);
            return -1L;
        }
    }

    private String getEntityFromBlobName(String blobName) {
        String[] blobNameTokens = blobName.split(PINNED_TIMESTAMPS_FILENAME_SEPARATOR);
        if (blobNameTokens.length < 2) {
            String errorMessage = "Pinned timestamps blob name contains invalid format: " + blobName;
            logger.error(errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        return String.join((CharSequence)PINNED_TIMESTAMPS_FILENAME_SEPARATOR, Arrays.copyOfRange(blobNameTokens, 0, blobNameTokens.length - 1));
    }

    public void unpinTimestamp(long timestamp, String pinningEntity, ActionListener<Void> listener) {
        try {
            logger.debug("Unpinning timestamp = {} against entity = {}", (Object)timestamp, (Object)pinningEntity);
            String blobName = this.getBlobName(timestamp, pinningEntity);
            if (this.blobContainer.blobExists(blobName)) {
                this.blobContainer.deleteBlobsIgnoringIfNotExists(List.of(blobName));
                listener.onResponse(null);
            } else {
                String errorMessage = String.format(Locale.ROOT, "Timestamp: %s is not pinned by entity: %s", timestamp, pinningEntity);
                logger.error(errorMessage);
                listener.onFailure(new IllegalArgumentException(errorMessage));
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void forceSyncPinnedTimestamps() {
        this.asyncUpdatePinnedTimestampTask.run();
    }

    @Override
    public void close() throws IOException {
        this.asyncUpdatePinnedTimestampTask.close();
    }

    public void rescheduleAsyncUpdatePinnedTimestampTask(TimeValue pinnedTimestampsSchedulerInterval) {
        if (pinnedTimestampsSchedulerInterval != null) {
            pinnedTimestampsSet = new Tuple(-1L, Set.of());
            this.asyncUpdatePinnedTimestampTask.close();
            this.startAsyncUpdateTask(pinnedTimestampsSchedulerInterval);
        }
    }

    public static Tuple<Long, Set<Long>> getPinnedTimestamps() {
        return pinnedTimestampsSet;
    }

    public static Map<String, List<Long>> getPinnedEntities() {
        return pinnedEntityToTimestampsMap;
    }

    private final class AsyncUpdatePinnedTimestampTask
    extends AbstractAsyncTask {
        private AsyncUpdatePinnedTimestampTask(Logger logger, ThreadPool threadPool, TimeValue interval, boolean autoReschedule) {
            super(logger, threadPool, interval, autoReschedule);
            this.rescheduleIfNecessary();
        }

        @Override
        protected boolean mustReschedule() {
            return true;
        }

        @Override
        protected void runInternal() {
            long triggerTimestamp = System.currentTimeMillis();
            try {
                Map<String, BlobMetadata> pinnedTimestampList = RemoteStorePinnedTimestampService.this.blobContainer.listBlobs();
                if (pinnedTimestampList.isEmpty()) {
                    pinnedTimestampsSet = new Tuple(triggerTimestamp, Set.of());
                    pinnedEntityToTimestampsMap = new HashMap<String, List<Long>>();
                    return;
                }
                Set pinnedTimestamps = pinnedTimestampList.keySet().stream().map(x$0 -> RemoteStorePinnedTimestampService.this.getTimestampFromBlobName((String)x$0)).filter(timestamp -> timestamp != -1L).collect(Collectors.toSet());
                logger.debug("Fetched pinned timestamps from remote store: {} - {}", (Object)triggerTimestamp, pinnedTimestamps);
                pinnedTimestampsSet = new Tuple(triggerTimestamp, pinnedTimestamps);
                pinnedEntityToTimestampsMap = pinnedTimestampList.keySet().stream().collect(Collectors.toMap(x$0 -> RemoteStorePinnedTimestampService.this.getEntityFromBlobName((String)x$0), blobName -> {
                    long timestamp = RemoteStorePinnedTimestampService.this.getTimestampFromBlobName((String)blobName);
                    return Collections.singletonList(timestamp);
                }, (existingList, newList) -> {
                    ArrayList mergedList = new ArrayList(existingList);
                    mergedList.addAll(newList);
                    return mergedList;
                }));
            }
            catch (Throwable t) {
                logger.error("Exception while fetching pinned timestamp details", t);
            }
        }
    }
}

