/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.node.resource.tracker;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.opensearch.common.lifecycle.AbstractLifecycleComponent;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.MovingAverage;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.Scheduler;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;

public abstract class AbstractAverageUsageTracker
extends AbstractLifecycleComponent {
    private static final Logger LOGGER = LogManager.getLogger(AbstractAverageUsageTracker.class);
    protected final ThreadPool threadPool;
    protected final TimeValue pollingInterval;
    private TimeValue windowDuration;
    private final AtomicReference<MovingAverage> observations = new AtomicReference();
    protected volatile Scheduler.Cancellable scheduledFuture;

    public AbstractAverageUsageTracker(ThreadPool threadPool, TimeValue pollingInterval, TimeValue windowDuration) {
        this.threadPool = threadPool;
        this.pollingInterval = pollingInterval;
        this.windowDuration = windowDuration;
        this.setWindowSize(windowDuration);
    }

    public abstract long getUsage();

    public double getAverage() {
        return this.observations.get().getAverage();
    }

    public boolean isReady() {
        return this.observations.get().isReady();
    }

    public void setWindowSize(TimeValue windowDuration) {
        this.windowDuration = windowDuration;
        int windowSize = (int)(windowDuration.nanos() / this.pollingInterval.nanos());
        LOGGER.debug("updated window size: {}", (Object)windowSize);
        this.observations.set(new MovingAverage(windowSize));
    }

    public TimeValue getPollingInterval() {
        return this.pollingInterval;
    }

    public TimeValue getWindowDuration() {
        return this.windowDuration;
    }

    public long getWindowSize() {
        return this.observations.get().getCount();
    }

    public void recordUsage(long usage) {
        this.observations.get().record(usage);
    }

    @Override
    protected void doStart() {
        this.scheduledFuture = this.threadPool.scheduleWithFixedDelay(() -> {
            long usage = this.getUsage();
            this.recordUsage(usage);
        }, this.pollingInterval, "generic");
    }

    @Override
    protected void doStop() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel();
        }
    }

    @Override
    protected void doClose() {
    }
}

