/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.node.resource.tracker;

import java.util.HashMap;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.Constants;
import org.graylog.shaded.opensearch2.org.opensearch.common.ValidationException;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.monitor.fs.FsInfo;
import org.graylog.shaded.opensearch2.org.opensearch.monitor.fs.FsService;
import org.graylog.shaded.opensearch2.org.opensearch.node.IoUsageStats;
import org.graylog.shaded.opensearch2.org.opensearch.node.resource.tracker.AbstractAverageUsageTracker;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;

public class AverageIoUsageTracker
extends AbstractAverageUsageTracker {
    private static final Logger LOGGER = LogManager.getLogger(AverageIoUsageTracker.class);
    private final FsService fsService;
    private final HashMap<String, Long> prevIoTimeDeviceMap;
    private long prevTimeInMillis;
    private IoUsageStats ioUsageStats;

    public AverageIoUsageTracker(FsService fsService, ThreadPool threadPool, TimeValue pollingInterval, TimeValue windowDuration) {
        super(threadPool, pollingInterval, windowDuration);
        this.fsService = fsService;
        this.prevIoTimeDeviceMap = new HashMap();
        this.prevTimeInMillis = -1L;
        this.ioUsageStats = null;
    }

    @Override
    public long getUsage() {
        long usage = 0L;
        Optional<ValidationException> validationException = this.preValidateFsStats();
        if (validationException != null && validationException.isPresent()) {
            throw validationException.get();
        }
        FsInfo.DeviceStats[] devicesStats = this.fsService.stats().getIoStats().getDevicesStats();
        long latestTimeInMillis = this.fsService.stats().getTimestamp();
        for (FsInfo.DeviceStats devicesStat : devicesStats) {
            long devicePreviousIoTime = this.prevIoTimeDeviceMap.getOrDefault(devicesStat.getDeviceName(), -1L);
            long deviceCurrentIoTime = devicesStat.ioTimeInMillis();
            if (this.prevTimeInMillis > 0L && latestTimeInMillis - this.prevTimeInMillis > 0L && devicePreviousIoTime > 0L) {
                long absIoTime = deviceCurrentIoTime - devicePreviousIoTime;
                long deviceCurrentIoUsage = absIoTime * 100L / (latestTimeInMillis - this.prevTimeInMillis);
                usage = Math.max(usage, deviceCurrentIoUsage);
            }
            this.prevIoTimeDeviceMap.put(devicesStat.getDeviceName(), devicesStat.ioTimeInMillis());
        }
        this.prevTimeInMillis = latestTimeInMillis;
        return usage;
    }

    @Override
    protected void doStart() {
        if (Constants.LINUX) {
            this.ioUsageStats = new IoUsageStats(-1.0);
            this.scheduledFuture = this.threadPool.scheduleWithFixedDelay(() -> {
                long usage = this.getUsage();
                this.recordUsage(usage);
                this.updateIoUsageStats();
            }, this.pollingInterval, "generic");
        }
    }

    public Optional<ValidationException> preValidateFsStats() {
        ValidationException validationException = new ValidationException();
        if (this.fsService == null || this.fsService.stats() == null || this.fsService.stats().getIoStats() == null || this.fsService.stats().getIoStats().getDevicesStats() == null) {
            validationException.addValidationError("FSService IoStats Or DeviceStats are Missing");
        }
        return validationException.validationErrors().isEmpty() ? Optional.empty() : Optional.of(validationException);
    }

    private void updateIoUsageStats() {
        this.ioUsageStats.setIoUtilisationPercent(this.isReady() ? this.getAverage() : -1.0);
    }

    public IoUsageStats getIoUsageStats() {
        return this.ioUsageStats;
    }
}

