/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.ratelimitting.admissioncontrol.controllers;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.ConcurrentCollections;
import org.graylog.shaded.opensearch2.org.opensearch.node.ResourceUsageCollectorService;
import org.graylog.shaded.opensearch2.org.opensearch.ratelimitting.admissioncontrol.enums.AdmissionControlActionType;
import org.graylog.shaded.opensearch2.org.opensearch.ratelimitting.admissioncontrol.enums.AdmissionControlMode;

public abstract class AdmissionController {
    private final String admissionControllerName;
    final ResourceUsageCollectorService resourceUsageCollectorService;
    public final Map<String, AtomicLong> rejectionCountMap;
    public final ClusterService clusterService;

    public AdmissionController(String admissionControllerName, ResourceUsageCollectorService resourceUsageCollectorService, ClusterService clusterService) {
        this.admissionControllerName = admissionControllerName;
        this.resourceUsageCollectorService = resourceUsageCollectorService;
        this.clusterService = clusterService;
        this.rejectionCountMap = ConcurrentCollections.newConcurrentMap();
    }

    public boolean isEnabledForTransportLayer(AdmissionControlMode admissionControlMode) {
        return admissionControlMode != AdmissionControlMode.DISABLED;
    }

    public Boolean isAdmissionControllerEnforced(AdmissionControlMode admissionControlMode) {
        return admissionControlMode == AdmissionControlMode.ENFORCED;
    }

    public abstract void apply(String var1, AdmissionControlActionType var2);

    public String getName() {
        return this.admissionControllerName;
    }

    public void addRejectionCount(String admissionControlActionType, long count) {
        if (!this.rejectionCountMap.containsKey(admissionControlActionType)) {
            this.rejectionCountMap.put(admissionControlActionType, new AtomicLong(0L));
        }
        this.rejectionCountMap.get(admissionControlActionType).getAndAdd(count);
    }

    public long getRejectionCount(String admissionControlActionType) {
        if (this.rejectionCountMap.containsKey(admissionControlActionType)) {
            return this.rejectionCountMap.get(admissionControlActionType).get();
        }
        return 0L;
    }

    public Map<String, Long> getRejectionStats() {
        HashMap<String, Long> rejectionStats = new HashMap<String, Long>();
        this.rejectionCountMap.forEach((actionType, count) -> rejectionStats.put((String)actionType, count.get()));
        return rejectionStats;
    }
}

