/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.repositories;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentObject;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.remote.RemoteStoreEnums;

@PublicApi(since="1.0.0")
public final class IndexId
implements Writeable,
ToXContentObject {
    static final String NAME = "name";
    static final String ID = "id";
    static final String SHARD_PATH_TYPE = "shard_path_type";
    public static final int DEFAULT_SHARD_PATH_TYPE = RemoteStoreEnums.PathType.FIXED.getCode();
    private final String name;
    private final String id;
    private final int shardPathType;
    private final int hashCode;

    public IndexId(String name, String id) {
        this(name, id, DEFAULT_SHARD_PATH_TYPE);
    }

    public IndexId(String name, String id, int shardPathType) {
        this.name = name;
        this.id = id;
        this.shardPathType = shardPathType;
        this.hashCode = this.computeHashCode();
    }

    public IndexId(StreamInput in) throws IOException {
        this.name = in.readString();
        this.id = in.readString();
        this.shardPathType = in.getVersion().onOrAfter(Version.V_2_17_0) ? in.readVInt() : DEFAULT_SHARD_PATH_TYPE;
        this.hashCode = this.computeHashCode();
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public int getShardPathType() {
        return this.shardPathType;
    }

    public String toString() {
        return "[" + this.name + "/" + this.id + "/" + this.shardPathType + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexId that = (IndexId)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.id, that.id) && Objects.equals(this.shardPathType, that.shardPathType);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        return Objects.hash(this.name, this.id, this.shardPathType);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.id);
        if (out.getVersion().onOrAfter(Version.V_2_17_0)) {
            out.writeVInt(this.shardPathType);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NAME, this.name);
        builder.field(ID, this.id);
        builder.field(SHARD_PATH_TYPE, this.shardPathType);
        builder.endObject();
        return builder;
    }
}

