/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.repositories;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionRunnable;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.crypto.CryptoSettings;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.repositories.delete.DeleteRepositoryRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.repositories.put.PutRepositoryRequest;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.AckedClusterStateUpdateTask;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterChangedEvent;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterStateApplier;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.RepositoryCleanupInProgress;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.RestoreInProgress;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.SnapshotDeletionsInProgress;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.SnapshotsInProgress;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ack.AckedRequest;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ack.ClusterStateUpdateResponse;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.CryptoMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.Metadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.RepositoriesMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.RepositoryMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNodeRole;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterManagerTaskThrottler;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.lifecycle.AbstractLifecycleComponent;
import org.graylog.shaded.opensearch2.org.opensearch.common.regex.Regex;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Setting;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.ConcurrentCollections;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.io.IOUtils;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.node.remotestore.RemoteStorePinnedTimestampService;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.RepositoriesStats;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.RepositoriesStatsArchive;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.Repository;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.RepositoryData;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.RepositoryException;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.RepositoryMissingException;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.RepositoryStatsSnapshot;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.VerifyNodeRepositoryAction;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.blobstore.BlobStoreRepository;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.blobstore.MeteredBlobStoreRepository;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

@PublicApi(since="1.0.0")
public class RepositoriesService
extends AbstractLifecycleComponent
implements ClusterStateApplier {
    private static final Logger logger = LogManager.getLogger(RepositoriesService.class);
    public static final Setting<TimeValue> REPOSITORIES_STATS_ARCHIVE_RETENTION_PERIOD = Setting.positiveTimeSetting("repositories.stats.archive.retention_period", TimeValue.timeValueHours(2L), Setting.Property.NodeScope);
    public static final Setting<Integer> REPOSITORIES_STATS_ARCHIVE_MAX_ARCHIVED_STATS = Setting.intSetting("repositories.stats.archive.max_archived_stats", 100, 0, Setting.Property.NodeScope);
    private final Map<String, Repository.Factory> typesRegistry;
    private final Map<String, Repository.Factory> internalTypesRegistry;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private final VerifyNodeRepositoryAction verifyAction;
    private final Map<String, Repository> internalRepositories = ConcurrentCollections.newConcurrentMap();
    private volatile Map<String, Repository> repositories = Collections.emptyMap();
    private final RepositoriesStatsArchive repositoriesStatsArchive;
    private final ClusterManagerTaskThrottler.ThrottlingKey putRepositoryTaskKey;
    private final ClusterManagerTaskThrottler.ThrottlingKey deleteRepositoryTaskKey;
    private final Settings settings;

    public RepositoriesService(Settings settings, ClusterService clusterService, TransportService transportService, Map<String, Repository.Factory> typesRegistry, Map<String, Repository.Factory> internalTypesRegistry, ThreadPool threadPool) {
        this.settings = settings;
        this.typesRegistry = typesRegistry;
        this.internalTypesRegistry = internalTypesRegistry;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        if ((DiscoveryNode.isDataNode(settings) || DiscoveryNode.isClusterManagerNode(settings)) && !RepositoriesService.isDedicatedVotingOnlyNode(DiscoveryNode.getRolesFromSettings(settings))) {
            clusterService.addHighPriorityApplier(this);
        }
        this.verifyAction = new VerifyNodeRepositoryAction(transportService, clusterService, this);
        this.repositoriesStatsArchive = new RepositoriesStatsArchive(REPOSITORIES_STATS_ARCHIVE_RETENTION_PERIOD.get(settings), REPOSITORIES_STATS_ARCHIVE_MAX_ARCHIVED_STATS.get(settings), threadPool::relativeTimeInMillis);
        this.putRepositoryTaskKey = clusterService.registerClusterManagerTask("put-repository", true);
        this.deleteRepositoryTaskKey = clusterService.registerClusterManagerTask("delete-repository", true);
    }

    public void registerOrUpdateRepository(final PutRepositoryRequest request, ActionListener<ClusterStateUpdateResponse> listener) {
        assert (this.lifecycle.started()) : "Trying to register new repository but service is in state [" + String.valueOf((Object)this.lifecycle.state()) + "]";
        final RepositoryMetadata newRepositoryMetadata = new RepositoryMetadata(request.name(), request.type(), request.settings(), CryptoMetadata.fromRequest(request.cryptoSettings()));
        RepositoriesService.validate(request.name());
        RepositoriesService.validateRepositoryMetadataSettings(this.clusterService, request.name(), request.settings(), this.repositories, this.settings, this);
        if (newRepositoryMetadata.cryptoMetadata() != null) {
            RepositoriesService.validate(newRepositoryMetadata.cryptoMetadata().keyProviderName());
        }
        ActionListener<ClusterStateUpdateResponse> registrationListener = request.verify() ? ActionListener.delegateFailure(listener, (delegatedListener, clusterStateUpdateResponse) -> {
            if (clusterStateUpdateResponse.isAcknowledged()) {
                this.verifyRepository(request.name(), ActionListener.delegateFailure(delegatedListener, (innerDelegatedListener, discoveryNodes) -> innerDelegatedListener.onResponse(clusterStateUpdateResponse)));
            } else {
                delegatedListener.onResponse(clusterStateUpdateResponse);
            }
        }) : listener;
        try {
            this.closeRepository(this.createRepository(newRepositoryMetadata, this.typesRegistry));
        }
        catch (Exception e) {
            registrationListener.onFailure(e);
            return;
        }
        this.clusterService.submitStateUpdateTask("put_repository [" + request.name() + "]", new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>((AckedRequest)request, registrationListener){

            @Override
            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                RepositoriesService.ensureRepositoryNotInUse(currentState, request.name());
                Metadata metadata = currentState.metadata();
                Metadata.Builder mdBuilder = Metadata.builder(currentState.metadata());
                RepositoriesMetadata repositories = (RepositoriesMetadata)metadata.custom("repositories");
                if (repositories == null) {
                    logger.info("put repository [{}]", (Object)request.name());
                    repositories = new RepositoriesMetadata(Collections.singletonList(new RepositoryMetadata(request.name(), request.type(), request.settings(), CryptoMetadata.fromRequest(request.cryptoSettings()))));
                } else {
                    boolean found = false;
                    ArrayList<RepositoryMetadata> repositoriesMetadata = new ArrayList<RepositoryMetadata>(repositories.repositories().size() + 1);
                    for (RepositoryMetadata repositoryMetadata : repositories.repositories()) {
                        RepositoryMetadata updatedRepositoryMetadata = newRepositoryMetadata;
                        if (RepositoriesService.isSystemRepositorySettingPresent(repositoryMetadata.settings())) {
                            Settings updatedSettings = Settings.builder().put(newRepositoryMetadata.settings()).put(BlobStoreRepository.SYSTEM_REPOSITORY_SETTING.getKey(), true).build();
                            updatedRepositoryMetadata = new RepositoryMetadata(newRepositoryMetadata.name(), newRepositoryMetadata.type(), updatedSettings, newRepositoryMetadata.cryptoMetadata());
                        }
                        if (repositoryMetadata.name().equals(updatedRepositoryMetadata.name())) {
                            if (updatedRepositoryMetadata.equalsIgnoreGenerations(repositoryMetadata)) {
                                return currentState;
                            }
                            RepositoriesService.ensureCryptoSettingsAreSame(repositoryMetadata, request);
                            found = true;
                            if (RepositoriesService.isSystemRepositorySettingPresent(repositoryMetadata.settings())) {
                                RepositoriesService.this.ensureValidSystemRepositoryUpdate(updatedRepositoryMetadata, repositoryMetadata);
                            }
                            repositoriesMetadata.add(updatedRepositoryMetadata);
                            continue;
                        }
                        repositoriesMetadata.add(repositoryMetadata);
                    }
                    if (!found) {
                        logger.info("put repository [{}]", (Object)request.name());
                        repositoriesMetadata.add(new RepositoryMetadata(request.name(), request.type(), request.settings(), CryptoMetadata.fromRequest(request.cryptoSettings())));
                    } else {
                        logger.info("update repository [{}]", (Object)request.name());
                    }
                    repositories = new RepositoriesMetadata(repositoriesMetadata);
                }
                mdBuilder.putCustom("repositories", repositories);
                return ClusterState.builder(currentState).metadata(mdBuilder).build();
            }

            @Override
            public ClusterManagerTaskThrottler.ThrottlingKey getClusterManagerThrottlingKey() {
                return RepositoriesService.this.putRepositoryTaskKey;
            }

            @Override
            public void onFailure(String source, Exception e) {
                logger.warn(() -> new ParameterizedMessage("failed to create repository [{}]", (Object)request.name()), (Throwable)e);
                super.onFailure(source, e);
            }

            @Override
            public boolean mustAck(DiscoveryNode discoveryNode) {
                return discoveryNode.isClusterManagerNode() || discoveryNode.isDataNode();
            }
        });
    }

    public void unregisterRepository(final DeleteRepositoryRequest request, ActionListener<ClusterStateUpdateResponse> listener) {
        this.clusterService.submitStateUpdateTask("delete_repository [" + request.name() + "]", new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>((AckedRequest)request, listener){

            @Override
            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                Metadata metadata = currentState.metadata();
                Metadata.Builder mdBuilder = Metadata.builder(currentState.metadata());
                RepositoriesMetadata repositories = (RepositoriesMetadata)metadata.custom("repositories");
                if (repositories != null && repositories.repositories().size() > 0) {
                    ArrayList<RepositoryMetadata> repositoriesMetadata = new ArrayList<RepositoryMetadata>(repositories.repositories().size());
                    boolean changed = false;
                    for (RepositoryMetadata repositoryMetadata : repositories.repositories()) {
                        if (Regex.simpleMatch(request.name(), repositoryMetadata.name())) {
                            RepositoriesService.ensureRepositoryNotInUse(currentState, repositoryMetadata.name());
                            RepositoriesService.ensureNotSystemRepository(repositoryMetadata);
                            logger.info("delete repository [{}]", (Object)repositoryMetadata.name());
                            changed = true;
                            continue;
                        }
                        repositoriesMetadata.add(repositoryMetadata);
                    }
                    if (changed) {
                        repositories = new RepositoriesMetadata(repositoriesMetadata);
                        mdBuilder.putCustom("repositories", repositories);
                        return ClusterState.builder(currentState).metadata(mdBuilder).build();
                    }
                }
                if (Regex.isMatchAllPattern(request.name())) {
                    return currentState;
                }
                throw new RepositoryMissingException(request.name());
            }

            @Override
            public ClusterManagerTaskThrottler.ThrottlingKey getClusterManagerThrottlingKey() {
                return RepositoriesService.this.deleteRepositoryTaskKey;
            }

            @Override
            public boolean mustAck(DiscoveryNode discoveryNode) {
                return discoveryNode.isClusterManagerNode() || discoveryNode.isDataNode();
            }
        });
    }

    public void verifyRepository(final String repositoryName, ActionListener<List<DiscoveryNode>> listener) {
        final Repository repository = this.repository(repositoryName);
        this.threadPool.executor("snapshot").execute(new ActionRunnable<List<DiscoveryNode>>(listener){

            @Override
            protected void doRun() {
                String verificationToken = repository.startVerification();
                if (verificationToken != null) {
                    try {
                        RepositoriesService.this.verifyAction.verify(repositoryName, verificationToken, ActionListener.delegateFailure(this.listener, (delegatedListener, verifyResponse) -> RepositoriesService.this.threadPool.executor("snapshot").execute(() -> {
                            try {
                                repository.endVerification(verificationToken);
                            }
                            catch (Exception e) {
                                logger.warn(() -> new ParameterizedMessage("[{}] failed to finish repository verification", (Object)repositoryName), (Throwable)e);
                                delegatedListener.onFailure(e);
                                return;
                            }
                            delegatedListener.onResponse(verifyResponse);
                        })));
                    }
                    catch (Exception e) {
                        RepositoriesService.this.threadPool.executor("snapshot").execute(() -> {
                            try {
                                repository.endVerification(verificationToken);
                            }
                            catch (Exception inner) {
                                inner.addSuppressed(e);
                                logger.warn(() -> new ParameterizedMessage("[{}] failed to finish repository verification", (Object)repositoryName), (Throwable)inner);
                            }
                            this.listener.onFailure(e);
                        });
                    }
                } else {
                    this.listener.onResponse(Collections.emptyList());
                }
            }
        });
    }

    static boolean isDedicatedVotingOnlyNode(Set<DiscoveryNodeRole> roles) {
        return roles.contains(DiscoveryNodeRole.CLUSTER_MANAGER_ROLE) && !roles.contains(DiscoveryNodeRole.DATA_ROLE) && roles.stream().anyMatch(role -> role.roleName().equals("voting_only"));
    }

    @Override
    public void applyClusterState(ClusterChangedEvent event) {
        try {
            ClusterState state = event.state();
            RepositoriesMetadata oldMetadata = (RepositoriesMetadata)event.previousState().getMetadata().custom("repositories");
            RepositoriesMetadata newMetadata = (RepositoriesMetadata)state.getMetadata().custom("repositories");
            if (oldMetadata == null && newMetadata == null || oldMetadata != null && oldMetadata.equalsIgnoreGenerations(newMetadata)) {
                for (Repository repo : this.repositories.values()) {
                    RepositoriesMetadata stateRepositoriesMetadata = (RepositoriesMetadata)state.metadata().custom("repositories");
                    if (stateRepositoriesMetadata == null || stateRepositoriesMetadata.repository(repo.getMetadata().name()) == null) continue;
                    repo.updateState(state);
                }
                return;
            }
            logger.trace("processing new index repositories for state version [{}]", (Object)event.state().version());
            HashMap<String, Repository> survivors = new HashMap<String, Repository>();
            for (Map.Entry<String, Repository> entry : this.repositories.entrySet()) {
                if (newMetadata == null || newMetadata.repository(entry.getKey()) == null) {
                    logger.debug("unregistering repository [{}]", (Object)entry.getKey());
                    Repository repository = entry.getValue();
                    this.closeRepository(repository);
                    continue;
                }
                survivors.put(entry.getKey(), entry.getValue());
            }
            HashMap<String, Repository> builder = new HashMap<String, Repository>();
            if (newMetadata != null) {
                for (RepositoryMetadata repositoryMetadata : newMetadata.repositories()) {
                    Repository repository = (Repository)survivors.get(repositoryMetadata.name());
                    if (repository != null) {
                        RepositoryMetadata previousMetadata = repository.getMetadata();
                        if (!previousMetadata.type().equals(repositoryMetadata.type()) || !previousMetadata.settings().equals(repositoryMetadata.settings())) {
                            if (repository.isSystemRepository() && repository.isReloadable()) {
                                logger.debug("updating repository [{}] in-place to use new metadata [{}]", (Object)repositoryMetadata.name(), (Object)repositoryMetadata);
                                repository.validateMetadata(repositoryMetadata);
                                repository.reload(repositoryMetadata);
                            } else {
                                logger.debug("updating repository [{}]", (Object)repositoryMetadata.name());
                                this.closeRepository(repository);
                                repository = null;
                                try {
                                    repository = this.createRepository(repositoryMetadata, this.typesRegistry);
                                }
                                catch (RepositoryException ex) {
                                    logger.warn(() -> new ParameterizedMessage("failed to change repository [{}]", (Object)repositoryMetadata.name()), (Throwable)ex);
                                }
                            }
                        }
                    } else {
                        try {
                            if (!this.repositories.containsKey(repositoryMetadata.name())) {
                                repository = this.createRepository(repositoryMetadata, this.typesRegistry);
                            } else {
                                repository = this.repositories.get(repositoryMetadata.name());
                                if (!repositoryMetadata.equalsIgnoreGenerations(repository.getMetadata())) {
                                    throw new RepositoryException(repositoryMetadata.name(), "repository was already registered with different metadata during bootstrap than cluster state");
                                }
                            }
                        }
                        catch (RepositoryException ex) {
                            logger.warn(() -> new ParameterizedMessage("failed to create repository [{}]", (Object)repositoryMetadata.name()), (Throwable)ex);
                        }
                    }
                    if (repository == null) continue;
                    logger.debug("registering repository [{}]", (Object)repositoryMetadata.name());
                    builder.put(repositoryMetadata.name(), repository);
                }
            }
            for (Repository repo : builder.values()) {
                repo.updateState(state);
            }
            this.repositories = Collections.unmodifiableMap(builder);
        }
        catch (Exception ex) {
            assert (false) : new AssertionError((Object)ex);
            logger.warn("failure updating cluster state ", (Throwable)ex);
        }
    }

    public void getRepositoryData(String repositoryName, ActionListener<RepositoryData> listener) {
        try {
            Repository repository = this.repository(repositoryName);
            assert (repository != null);
            repository.getRepositoryData(listener);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public Repository repository(String repositoryName) {
        Repository repository = this.repositories.get(repositoryName);
        if (repository != null) {
            return repository;
        }
        repository = this.internalRepositories.get(repositoryName);
        if (repository != null) {
            return repository;
        }
        throw new RepositoryMissingException(repositoryName);
    }

    public List<RepositoryStatsSnapshot> repositoriesStats() {
        List<RepositoryStatsSnapshot> activeRepoStats = this.getRepositoryStatsForActiveRepositories();
        return activeRepoStats;
    }

    public RepositoriesStats getRepositoriesStats() {
        return new RepositoriesStats(this.repositoriesStats());
    }

    private List<RepositoryStatsSnapshot> getRepositoryStatsForActiveRepositories() {
        return Stream.concat(this.repositories.values().stream(), this.internalRepositories.values().stream()).filter(r -> r instanceof MeteredBlobStoreRepository).map(r -> (MeteredBlobStoreRepository)r).map(MeteredBlobStoreRepository::statsSnapshot).collect(Collectors.toList());
    }

    public List<RepositoryStatsSnapshot> clearRepositoriesStatsArchive(long maxVersionToClear) {
        return this.repositoriesStatsArchive.clear(maxVersionToClear);
    }

    public void registerInternalRepository(String name, String type) {
        RepositoryMetadata metadata = new RepositoryMetadata(name, type, Settings.EMPTY);
        Repository repository = this.internalRepositories.computeIfAbsent(name, n -> {
            logger.debug("put internal repository [{}][{}]", (Object)name, (Object)type);
            return this.createRepository(metadata, this.internalTypesRegistry);
        });
        if (!type.equals(repository.getMetadata().type())) {
            logger.warn((Message)new ParameterizedMessage("internal repository [{}][{}] already registered. this prevented the registration of internal repository [{}][{}].", new Object[]{name, repository.getMetadata().type(), name, type}));
        } else if (this.repositories.containsKey(name)) {
            logger.warn((Message)new ParameterizedMessage("non-internal repository [{}] already registered. this repository will block the usage of internal repository [{}][{}].", new Object[]{name, metadata.type(), name}));
        }
    }

    public void unregisterInternalRepository(String name) {
        Repository repository = this.internalRepositories.remove(name);
        if (repository != null) {
            RepositoryMetadata metadata = repository.getMetadata();
            logger.debug(() -> new ParameterizedMessage("delete internal repository [{}][{}].", (Object)metadata.type(), (Object)name));
            this.closeRepository(repository);
        }
    }

    public void closeRepository(Repository repository) {
        logger.debug("closing repository [{}][{}]", (Object)repository.getMetadata().type(), (Object)repository.getMetadata().name());
        repository.close();
    }

    public Repository createRepository(RepositoryMetadata repositoryMetadata) {
        return this.createRepository(repositoryMetadata, this.typesRegistry);
    }

    private Repository createRepository(RepositoryMetadata repositoryMetadata, Map<String, Repository.Factory> factories) {
        logger.debug("creating repository [{}][{}]", (Object)repositoryMetadata.type(), (Object)repositoryMetadata.name());
        Repository.Factory factory = factories.get(repositoryMetadata.type());
        if (factory == null) {
            throw new RepositoryException(repositoryMetadata.name(), "repository type [" + repositoryMetadata.type() + "] does not exist");
        }
        Repository repository = null;
        try {
            repository = factory.create(repositoryMetadata, factories::get);
            repository.start();
            return repository;
        }
        catch (Exception e) {
            IOUtils.closeWhileHandlingException(repository);
            logger.warn((Message)new ParameterizedMessage("failed to create repository [{}][{}]", (Object)repositoryMetadata.type(), (Object)repositoryMetadata.name()), (Throwable)e);
            throw new RepositoryException(repositoryMetadata.name(), "failed to create repository", e);
        }
    }

    public static void validate(String identifier) {
        if (!Strings.hasLength(identifier)) {
            throw new RepositoryException(identifier, "cannot be empty");
        }
        if (identifier.contains("#")) {
            throw new RepositoryException(identifier, "must not contain '#'");
        }
        if (!Strings.validFileName(identifier)) {
            throw new RepositoryException(identifier, "must not contain the following characters " + String.valueOf(Strings.INVALID_FILENAME_CHARS));
        }
    }

    public static void validateRepositoryMetadataSettings(ClusterService clusterService, String repositoryName, Settings repositoryMetadataSettings) {
        RepositoriesService.validateRepositoryMetadataSettings(clusterService, repositoryName, repositoryMetadataSettings, null, null, null);
    }

    public static void validateRepositoryMetadataSettings(ClusterService clusterService, String repositoryName, Settings repositoryMetadataSettings, Map<String, Repository> repositories, Settings settings, RepositoriesService repositoriesService) {
        Version minVersionInCluster = clusterService.state().getNodes().getMinNodeVersion();
        if (BlobStoreRepository.REMOTE_STORE_INDEX_SHALLOW_COPY.get(repositoryMetadataSettings).booleanValue() && !minVersionInCluster.onOrAfter(Version.V_2_9_0)) {
            throw new RepositoryException(repositoryName, "setting " + BlobStoreRepository.REMOTE_STORE_INDEX_SHALLOW_COPY.getKey() + " cannot be enabled as some of the nodes in cluster are on version older than " + String.valueOf(Version.V_2_9_0) + ". Minimum node version in cluster is: " + String.valueOf(minVersionInCluster));
        }
        if (BlobStoreRepository.SHALLOW_SNAPSHOT_V2.get(repositoryMetadataSettings).booleanValue()) {
            if (repositories == null || repositoriesService == null || settings == null) {
                throw new RepositoryException(repositoryName, "setting " + BlobStoreRepository.SHALLOW_SNAPSHOT_V2.getKey() + " cannot be enabled if required params are not provided");
            }
            if (!minVersionInCluster.onOrAfter(Version.V_2_17_0)) {
                throw new RepositoryException(repositoryName, "setting " + BlobStoreRepository.SHALLOW_SNAPSHOT_V2.getKey() + " cannot be enabled as some of the nodes in cluster are on version older than " + String.valueOf(Version.V_2_17_0) + ". Minimum node version in cluster is: " + String.valueOf(minVersionInCluster));
            }
            if (repositoryName.contains("__")) {
                throw new RepositoryException(repositoryName, "setting " + BlobStoreRepository.SHALLOW_SNAPSHOT_V2.getKey() + " cannot be enabled for repository with __ in the name as this delimiter is used to create pinning entity");
            }
            if (RepositoriesService.repositoryWithShallowV2Exists(repositories, repositoryName)) {
                throw new RepositoryException(repositoryName, "setting " + BlobStoreRepository.SHALLOW_SNAPSHOT_V2.getKey() + " cannot be enabled as this setting can be enabled only on one repository  and one or more repositories in the cluster have the setting as enabled");
            }
            try {
                if (RepositoriesService.pinnedTimestampExistsWithDifferentRepository(repositoryName, settings, repositoriesService)) {
                    throw new RepositoryException(repositoryName, "setting " + BlobStoreRepository.SHALLOW_SNAPSHOT_V2.getKey() + " cannot be enabled if there are existing snapshots created with shallow V2 setting using different repository.");
                }
            }
            catch (IOException e) {
                throw new RepositoryException(repositoryName, "Exception while fetching pinned timestamp details");
            }
        }
        if (RepositoriesService.isSystemRepositorySettingPresent(repositoryMetadataSettings)) {
            throw new RepositoryException(repositoryName, "setting " + BlobStoreRepository.SYSTEM_REPOSITORY_SETTING.getKey() + " cannot provide system repository setting; this setting is managed by OpenSearch");
        }
    }

    private static boolean repositoryWithShallowV2Exists(Map<String, Repository> repositories, String repositoryName) {
        return repositories.values().stream().anyMatch(repository -> BlobStoreRepository.SHALLOW_SNAPSHOT_V2.get(repository.getMetadata().settings()) != false && !Objects.equals(repository.getMetadata().name(), repositoryName));
    }

    private static boolean pinnedTimestampExistsWithDifferentRepository(String newRepoName, Settings settings, RepositoriesService repositoriesService) throws IOException {
        Map<String, Set<Long>> pinningEntityTimestampMap = RemoteStorePinnedTimestampService.fetchPinnedTimestamps(settings, repositoriesService);
        for (String pinningEntity : pinningEntityTimestampMap.keySet()) {
            String repoNameWithPinnedTimestamps = pinningEntity.split("__")[0];
            if (repoNameWithPinnedTimestamps.equals(newRepoName)) continue;
            return true;
        }
        return false;
    }

    private static void ensureRepositoryNotInUse(ClusterState clusterState, String repository) {
        if (RepositoriesService.isRepositoryInUse(clusterState, repository)) {
            throw new IllegalStateException("trying to modify or unregister repository that is currently used");
        }
    }

    private static void ensureCryptoSettingsAreSame(RepositoryMetadata repositoryMetadata, PutRepositoryRequest request) {
        if (repositoryMetadata.cryptoMetadata() == null && request.cryptoSettings() == null) {
            return;
        }
        if (repositoryMetadata.cryptoMetadata() == null || request.cryptoSettings() == null) {
            throw new IllegalArgumentException("Crypto settings changes found in the repository update request. This is not allowed");
        }
        CryptoMetadata cryptoMetadata = repositoryMetadata.cryptoMetadata();
        CryptoSettings cryptoSettings = request.cryptoSettings();
        if (!(cryptoMetadata.keyProviderName().equals(cryptoSettings.getKeyProviderName()) && cryptoMetadata.keyProviderType().equals(cryptoSettings.getKeyProviderType()) && cryptoMetadata.settings().toString().equals(cryptoSettings.getSettings().toString()))) {
            throw new IllegalArgumentException("Changes in crypto settings found in the repository update request. This is not allowed");
        }
    }

    private static boolean isRepositoryInUse(ClusterState clusterState, String repository) {
        SnapshotsInProgress snapshots = clusterState.custom("snapshots", SnapshotsInProgress.EMPTY);
        for (SnapshotsInProgress.Entry entry : snapshots.entries()) {
            if (!repository.equals(entry.snapshot().getRepository())) continue;
            return true;
        }
        for (SnapshotDeletionsInProgress.Entry entry : clusterState.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY).getEntries()) {
            if (!entry.repository().equals(repository)) continue;
            return true;
        }
        for (RepositoryCleanupInProgress.Entry entry : clusterState.custom("repository_cleanup", RepositoryCleanupInProgress.EMPTY).entries()) {
            if (!entry.repository().equals(repository)) continue;
            return true;
        }
        for (RestoreInProgress.Entry entry : clusterState.custom("restore", RestoreInProgress.EMPTY)) {
            if (!repository.equals(entry.snapshot().getRepository())) continue;
            return true;
        }
        return false;
    }

    public void updateRepositoriesMap(Map<String, Repository> repos) {
        if (!this.repositories.isEmpty()) {
            throw new IllegalArgumentException("can't overwrite as repositories are already present");
        }
        this.repositories = repos;
    }

    private static void ensureNotSystemRepository(RepositoryMetadata repositoryMetadata) {
        if (RepositoriesService.isSystemRepositorySettingPresent(repositoryMetadata.settings())) {
            throw new RepositoryException(repositoryMetadata.name(), "cannot delete a system repository");
        }
    }

    private static boolean isSystemRepositorySettingPresent(Settings repositoryMetadataSettings) {
        return BlobStoreRepository.SYSTEM_REPOSITORY_SETTING.get(repositoryMetadataSettings);
    }

    private static boolean isValueEqual(String key, String newValue, String currentValue) {
        if (newValue == null && currentValue == null) {
            return true;
        }
        if (newValue == null) {
            throw new IllegalArgumentException("[" + key + "] cannot be empty, current value [" + currentValue + "]");
        }
        if (!newValue.equals(currentValue)) {
            throw new IllegalArgumentException("trying to modify an unmodifiable attribute " + key + " of system repository from current value [" + currentValue + "] to new value [" + newValue + "]");
        }
        return true;
    }

    public void ensureValidSystemRepositoryUpdate(RepositoryMetadata newRepositoryMetadata, RepositoryMetadata currentRepositoryMetadata) {
        if (RepositoriesService.isSystemRepositorySettingPresent(currentRepositoryMetadata.settings())) {
            try {
                RepositoriesService.isValueEqual("type", newRepositoryMetadata.type(), currentRepositoryMetadata.type());
                Repository repository = this.repositories.get(currentRepositoryMetadata.name());
                Settings newRepositoryMetadataSettings = newRepositoryMetadata.settings();
                Settings currentRepositoryMetadataSettings = currentRepositoryMetadata.settings();
                assert (Objects.nonNull(repository)) : String.format(Locale.ROOT, "repository [%s] not present in RepositoryService", currentRepositoryMetadata.name());
                List restrictedSettings = repository.getRestrictedSystemRepositorySettings().stream().map(setting -> setting.getKey()).collect(Collectors.toList());
                for (String restrictedSettingKey : restrictedSettings) {
                    RepositoriesService.isValueEqual(restrictedSettingKey, newRepositoryMetadataSettings.get(restrictedSettingKey), currentRepositoryMetadataSettings.get(restrictedSettingKey));
                }
            }
            catch (IllegalArgumentException e) {
                throw new RepositoryException(currentRepositoryMetadata.name(), e.getMessage());
            }
        }
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
    }

    @Override
    protected void doClose() throws IOException {
        this.clusterService.removeApplier(this);
        ArrayList<Repository> repos = new ArrayList<Repository>();
        repos.addAll(this.internalRepositories.values());
        repos.addAll(this.repositories.values());
        IOUtils.close(repos);
    }
}

