/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.repositories.blobstore;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.CodecUtil;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.CorruptIndexException;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexFormatTooNewException;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexFormatTooOldException;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.ByteBuffersDataInput;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.ByteBuffersIndexInput;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.IndexInput;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.Metadata;
import org.graylog.shaded.opensearch2.org.opensearch.common.CheckedFunction;
import org.graylog.shaded.opensearch2.org.opensearch.common.blobstore.AsyncMultiStreamBlobContainer;
import org.graylog.shaded.opensearch2.org.opensearch.common.blobstore.BlobContainer;
import org.graylog.shaded.opensearch2.org.opensearch.common.blobstore.stream.write.WritePriority;
import org.graylog.shaded.opensearch2.org.opensearch.common.blobstore.transfer.RemoteTransferContainer;
import org.graylog.shaded.opensearch2.org.opensearch.common.blobstore.transfer.stream.OffsetRangeIndexInputStream;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.Streams;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.store.ByteArrayIndexInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentHelper;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentType;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.bytes.BytesReference;
import org.graylog.shaded.opensearch2.org.opensearch.core.compress.Compressor;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.NamedXContentRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.CorruptStateException;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.exception.ChecksumCombinationException;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.blobstore.BaseBlobStoreFormat;

public final class ChecksumBlobStoreFormat<T extends ToXContent>
extends BaseBlobStoreFormat<T> {
    public static final ToXContent.Params SNAPSHOT_ONLY_FORMAT_PARAMS;
    public static final int VERSION = 1;
    private final String codec;
    private final CheckedFunction<XContentParser, T, IOException> reader;

    public ChecksumBlobStoreFormat(String codec, String blobNameFormat, CheckedFunction<XContentParser, T, IOException> reader) {
        super(blobNameFormat, false);
        this.reader = reader;
        this.codec = codec;
    }

    public T read(BlobContainer blobContainer, String name, NamedXContentRegistry namedXContentRegistry) throws IOException {
        String blobName = this.blobName(name);
        return this.deserialize(blobName, namedXContentRegistry, Streams.readFully(blobContainer.readBlob(blobName)));
    }

    @Override
    public String blobName(String name) {
        return String.format(Locale.ROOT, this.getBlobNameFormat(), name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T deserialize(String blobName, NamedXContentRegistry namedXContentRegistry, BytesReference bytes) throws IOException {
        String resourceDesc = "ChecksumBlobStoreFormat.readBlob(blob=\"" + blobName + "\")";
        try {
            IndexInput indexInput = bytes.length() > 0 ? new ByteBuffersIndexInput(new ByteBuffersDataInput(Arrays.asList(BytesReference.toByteBuffers(bytes))), resourceDesc) : new ByteArrayIndexInput(resourceDesc, BytesRef.EMPTY_BYTES);
            CodecUtil.checksumEntireFile(indexInput);
            CodecUtil.checkHeader(indexInput, this.codec, 1, 1);
            long filePointer = indexInput.getFilePointer();
            long contentSize = indexInput.length() - (long)CodecUtil.footerLength() - filePointer;
            try (XContentParser parser = XContentHelper.createParser(namedXContentRegistry, LoggingDeprecationHandler.INSTANCE, bytes.slice((int)filePointer, (int)contentSize), XContentType.SMILE);){
                ToXContent toXContent = (ToXContent)this.reader.apply(parser);
                return (T)toXContent;
            }
        }
        catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException ex) {
            throw new CorruptStateException(ex);
        }
    }

    public void write(T obj, BlobContainer blobContainer, String name, Compressor compressor) throws IOException {
        this.write(obj, blobContainer, name, compressor, SNAPSHOT_ONLY_FORMAT_PARAMS, XContentType.SMILE, this.codec, 1);
    }

    public void writeAsync(T obj, BlobContainer blobContainer, String name, Compressor compressor, ActionListener<Void> listener, ToXContent.Params params) throws IOException {
        this.writeAsyncWithPriority(obj, blobContainer, name, compressor, WritePriority.NORMAL, listener, params);
    }

    public void writeAsyncWithUrgentPriority(T obj, BlobContainer blobContainer, String name, Compressor compressor, ActionListener<Void> listener, ToXContent.Params params) throws IOException {
        this.writeAsyncWithPriority(obj, blobContainer, name, compressor, WritePriority.URGENT, listener, params);
    }

    private void writeAsyncWithPriority(T obj, BlobContainer blobContainer, String name, Compressor compressor, WritePriority priority, ActionListener<Void> listener, ToXContent.Params params) throws IOException {
        long expectedChecksum;
        if (!(blobContainer instanceof AsyncMultiStreamBlobContainer)) {
            this.write(obj, blobContainer, name, compressor, params, XContentType.SMILE, this.codec, 1);
            listener.onResponse(null);
            return;
        }
        String blobName = this.blobName(name);
        BytesReference bytesReference = this.serialize(obj, blobName, compressor, params);
        String resourceDescription = "ChecksumBlobStoreFormat.writeAsyncWithPriority(blob=\"" + blobName + "\")";
        byte[] bytes = BytesReference.toBytes(bytesReference);
        try (ByteArrayIndexInput input = new ByteArrayIndexInput(resourceDescription, bytes);){
            try {
                expectedChecksum = RemoteTransferContainer.checksumOfChecksum(input.clone(), 8);
            }
            catch (Exception e) {
                throw new ChecksumCombinationException("Potentially corrupted file: Checksum combination failed while combining stored checksum and calculated checksum of stored checksum", resourceDescription, (Throwable)e);
            }
        }
        try (RemoteTransferContainer remoteTransferContainer = new RemoteTransferContainer(blobName, blobName, bytes.length, true, priority, (size, position) -> new OffsetRangeIndexInputStream(new ByteArrayIndexInput(resourceDescription, bytes), size, position), expectedChecksum, ((AsyncMultiStreamBlobContainer)blobContainer).remoteIntegrityCheckSupported());){
            ((AsyncMultiStreamBlobContainer)blobContainer).asyncBlobUpload(remoteTransferContainer.createWriteContext(), listener);
        }
    }

    public BytesReference serialize(T obj, String blobName, Compressor compressor, ToXContent.Params params) throws IOException {
        return this.serialize(obj, blobName, compressor, params, XContentType.SMILE, this.codec, 1);
    }

    static {
        HashMap<String, String> snapshotOnlyParams = new HashMap<String, String>();
        snapshotOnlyParams.put("context_mode", Metadata.CONTEXT_MODE_SNAPSHOT);
        snapshotOnlyParams.put("context_mode", "SNAPSHOT");
        SNAPSHOT_ONLY_FORMAT_PARAMS = new ToXContent.MapParams(snapshotOnlyParams);
    }
}

