/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.repositories.blobstore;

import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.ConcurrentCollections;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.shard.ShardId;

public class RemoteStoreShardCleanupTask
implements Runnable {
    private final Runnable task;
    private final String shardIdentifier;
    static final Set<String> ongoingRemoteDirectoryCleanups = ConcurrentCollections.newConcurrentSet();
    private static final Logger staticLogger = LogManager.getLogger(RemoteStoreShardCleanupTask.class);

    public RemoteStoreShardCleanupTask(Runnable task, String indexUUID, ShardId shardId) {
        this.task = task;
        this.shardIdentifier = RemoteStoreShardCleanupTask.indexShardIdentifier(indexUUID, shardId);
    }

    private static String indexShardIdentifier(String indexUUID, ShardId shardId) {
        return String.join((CharSequence)"/", indexUUID, String.valueOf(shardId.id()));
    }

    @Override
    public void run() {
        if (ongoingRemoteDirectoryCleanups.add(this.shardIdentifier)) {
            try {
                this.task.run();
            }
            finally {
                ongoingRemoteDirectoryCleanups.remove(this.shardIdentifier);
            }
        } else {
            staticLogger.warn("one cleanup task for shard {} is already ongoing, need to skip this task", (Object)this.shardIdentifier);
        }
    }
}

