/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.wlm.WlmStatsRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.wlm.WlmStatsResponse;
import org.graylog.shaded.opensearch2.org.opensearch.client.node.NodeClient;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.rest.BaseRestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestChannel;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestRequest;
import org.graylog.shaded.opensearch2.org.opensearch.rest.action.RestActions;

public class RestWlmStatsAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "_wlm/stats"), new RestHandler.Route(RestRequest.Method.GET, "_wlm/{nodeId}/stats"), new RestHandler.Route(RestRequest.Method.GET, "_wlm/stats/{queryGroupId}"), new RestHandler.Route(RestRequest.Method.GET, "_wlm/{nodeId}/stats/{queryGroupId}")));
    }

    @Override
    public String getName() {
        return "wlm_stats_action";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] nodesIds = Strings.splitStringByCommaToArray(request.param("nodeId"));
        Set<String> queryGroupIds = Strings.tokenizeByCommaToSet(request.param("queryGroupId", "_all"));
        Boolean breach = request.hasParam("breach") ? Boolean.valueOf(Boolean.parseBoolean(request.param("boolean"))) : null;
        WlmStatsRequest wlmStatsRequest = new WlmStatsRequest(nodesIds, queryGroupIds, breach);
        return channel -> client.admin().cluster().wlmStats(wlmStatsRequest, new RestActions.NodesResponseRestListener<WlmStatsResponse>((RestChannel)channel));
    }
}

