/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.rest.action.cat;

import java.util.Collections;
import java.util.List;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.state.ClusterStateRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.state.ClusterStateResponse;
import org.graylog.shaded.opensearch2.org.opensearch.client.node.NodeClient;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNodes;
import org.graylog.shaded.opensearch2.org.opensearch.common.Table;
import org.graylog.shaded.opensearch2.org.opensearch.common.logging.DeprecationLogger;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.rest.BaseRestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestRequest;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestResponse;
import org.graylog.shaded.opensearch2.org.opensearch.rest.action.RestResponseListener;
import org.graylog.shaded.opensearch2.org.opensearch.rest.action.cat.AbstractCatAction;
import org.graylog.shaded.opensearch2.org.opensearch.rest.action.cat.RestTable;

public class RestClusterManagerAction
extends AbstractCatAction {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestClusterManagerAction.class);

    @Override
    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return Collections.singletonList(new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_cat/cluster_manager", "/_cat/master"));
    }

    @Override
    public String getName() {
        return "cat_cluster_manager_action";
    }

    @Override
    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/cluster_manager\n");
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doCatRequest(final RestRequest request, NodeClient client) {
        ClusterStateRequest clusterStateRequest = new ClusterStateRequest();
        clusterStateRequest.clear().nodes(true);
        clusterStateRequest.local(request.paramAsBoolean("local", clusterStateRequest.local()));
        clusterStateRequest.clusterManagerNodeTimeout(request.paramAsTime("cluster_manager_timeout", clusterStateRequest.clusterManagerNodeTimeout()));
        RestClusterManagerAction.parseDeprecatedMasterTimeoutParameter(clusterStateRequest, request);
        return channel -> client.admin().cluster().state(clusterStateRequest, (ActionListener<ClusterStateResponse>)new RestResponseListener<ClusterStateResponse>(channel){

            @Override
            public RestResponse buildResponse(ClusterStateResponse clusterStateResponse) throws Exception {
                return RestTable.buildResponse(RestClusterManagerAction.this.buildTable(request, clusterStateResponse), this.channel);
            }
        });
    }

    @Override
    public boolean canTripCircuitBreaker() {
        return false;
    }

    @Override
    protected Table getTableWithHeader(RestRequest request) {
        Table table = new Table();
        table.startHeaders().addCell("id", "desc:node id").addCell("host", "alias:h;desc:host name").addCell("ip", "desc:ip address ").addCell("node", "alias:n;desc:node name").endHeaders();
        return table;
    }

    private Table buildTable(RestRequest request, ClusterStateResponse state) {
        Table table = this.getTableWithHeader(request);
        DiscoveryNodes nodes = state.getState().nodes();
        table.startRow();
        DiscoveryNode clusterManager = nodes.get(nodes.getClusterManagerNodeId());
        if (clusterManager == null) {
            table.addCell("-");
            table.addCell("-");
            table.addCell("-");
            table.addCell("-");
        } else {
            table.addCell(clusterManager.getId());
            table.addCell(clusterManager.getHostName());
            table.addCell(clusterManager.getHostAddress());
            table.addCell(clusterManager.getName());
        }
        table.endRow();
        return table;
    }
}

