/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.rest.action.ingest;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.graylog.shaded.opensearch2.org.opensearch.action.ingest.PutPipelineRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.master.AcknowledgedResponse;
import org.graylog.shaded.opensearch2.org.opensearch.client.node.NodeClient;
import org.graylog.shaded.opensearch2.org.opensearch.common.collect.Tuple;
import org.graylog.shaded.opensearch2.org.opensearch.common.logging.DeprecationLogger;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.bytes.BytesReference;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.MediaType;
import org.graylog.shaded.opensearch2.org.opensearch.rest.BaseRestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestChannel;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestRequest;
import org.graylog.shaded.opensearch2.org.opensearch.rest.action.RestToXContentListener;

public class RestPutPipelineAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestPutPipelineAction.class);

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.PUT, "/_ingest/pipeline/{id}"));
    }

    @Override
    public String getName() {
        return "ingest_put_pipeline_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        Tuple<MediaType, BytesReference> sourceTuple = restRequest.contentOrSourceParam();
        PutPipelineRequest request = new PutPipelineRequest(restRequest.param("id"), sourceTuple.v2(), sourceTuple.v1());
        request.clusterManagerNodeTimeout(restRequest.paramAsTime("cluster_manager_timeout", request.clusterManagerNodeTimeout()));
        RestPutPipelineAction.parseDeprecatedMasterTimeoutParameter(request, restRequest);
        request.timeout(restRequest.paramAsTime("timeout", request.timeout()));
        return channel -> client.admin().cluster().putPipeline(request, new RestToXContentListener<AcknowledgedResponse>((RestChannel)channel));
    }
}

