/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.rest.action.list;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.action.pagination.PageParams;
import org.graylog.shaded.opensearch2.org.opensearch.action.pagination.ShardPaginationStrategy;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestRequest;
import org.graylog.shaded.opensearch2.org.opensearch.rest.action.cat.RestShardsAction;

public class RestShardsListAction
extends RestShardsAction {
    protected static final int MAX_SUPPORTED_LIST_SHARDS_PAGE_SIZE = 20000;
    protected static final int MIN_SUPPORTED_LIST_SHARDS_PAGE_SIZE = 2000;

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_list/shards"), new RestHandler.Route(RestRequest.Method.GET, "/_list/shards/{index}")));
    }

    @Override
    public String getName() {
        return "list_shards_action";
    }

    @Override
    protected void documentation(StringBuilder sb) {
        sb.append("/_list/shards\n");
        sb.append("/_list/shards/{index}\n");
    }

    @Override
    public boolean isActionPaginated() {
        return true;
    }

    @Override
    protected PageParams validateAndGetPageParams(RestRequest restRequest) {
        PageParams pageParams = super.validateAndGetPageParams(restRequest);
        if (pageParams.getSize() < 2000) {
            throw new IllegalArgumentException("size should at least be [2000]");
        }
        if (pageParams.getSize() > 20000) {
            throw new IllegalArgumentException("size should be less than [20000]");
        }
        if (Objects.nonNull(pageParams.getRequestedToken())) {
            ShardPaginationStrategy.ShardStrategyToken.validateShardStrategyToken(pageParams.getRequestedToken());
        }
        return pageParams;
    }

    @Override
    protected int defaultPageSize() {
        return 2000;
    }
}

