/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.script;

import java.math.BigDecimal;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.graylog.shaded.opensearch2.org.joda.time.DateTime;
import org.graylog.shaded.opensearch2.org.joda.time.DateTimeUtils;
import org.graylog.shaded.opensearch2.org.joda.time.DateTimeZone;
import org.graylog.shaded.opensearch2.org.joda.time.Instant;
import org.graylog.shaded.opensearch2.org.joda.time.ReadableDateTime;
import org.graylog.shaded.opensearch2.org.joda.time.ReadableInstant;

public final class ClassPermission
extends BasicPermission {
    public static final String STANDARD = "<<STANDARD>>";
    public static final Set<String> STANDARD_CLASSES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(Boolean.class.getName(), Byte.class.getName(), Character.class.getName(), Double.class.getName(), Integer.class.getName(), Long.class.getName(), Math.class.getName(), Object.class.getName(), Short.class.getName(), String.class.getName(), BigDecimal.class.getName(), ArrayList.class.getName(), Arrays.class.getName(), Date.class.getName(), HashMap.class.getName(), HashSet.class.getName(), Iterator.class.getName(), List.class.getName(), Map.class.getName(), Set.class.getName(), UUID.class.getName(), DateTime.class.getName(), DateTimeUtils.class.getName(), DateTimeZone.class.getName(), Instant.class.getName(), ReadableDateTime.class.getName(), ReadableInstant.class.getName())));

    public ClassPermission(String name) {
        super(name);
    }

    public ClassPermission(String name, String actions) {
        this(name);
    }

    @Override
    public boolean implies(Permission p) {
        if (p != null && p.getClass() == this.getClass()) {
            ClassPermission other = (ClassPermission)p;
            if (STANDARD.equals(this.getName()) && STANDARD_CLASSES.contains(other.getName())) {
                return true;
            }
        }
        return super.implies(p);
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        final PermissionCollection impl = super.newPermissionCollection();
        return new PermissionCollection(){

            @Override
            public void add(Permission permission) {
                if (permission instanceof ClassPermission && ClassPermission.STANDARD.equals(permission.getName())) {
                    for (String clazz : STANDARD_CLASSES) {
                        impl.add(new ClassPermission(clazz));
                    }
                } else {
                    impl.add(permission);
                }
            }

            @Override
            public boolean implies(Permission permission) {
                return impl.implies(permission);
            }

            @Override
            public Enumeration<Permission> elements() {
                return impl.elements();
            }
        };
    }
}

