/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.script.mustache;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.graylog.shaded.opensearch2.org.opensearch.ExceptionsHelper;
import org.graylog.shaded.opensearch2.org.opensearch.LegacyESVersion;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.MultiSearchResponse;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionResponse;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.MediaTypeRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentObject;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.script.mustache.SearchTemplateResponse;

public class MultiSearchTemplateResponse
extends ActionResponse
implements Iterable<Item>,
ToXContentObject {
    private final Item[] items;
    private final long tookInMillis;

    MultiSearchTemplateResponse(StreamInput in) throws IOException {
        super(in);
        this.items = in.readArray(x$0 -> new Item(x$0), Item[]::new);
        this.tookInMillis = in.getVersion().onOrAfter(LegacyESVersion.V_7_0_0) ? in.readVLong() : -1L;
    }

    MultiSearchTemplateResponse(Item[] items, long tookInMillis) {
        this.items = items;
        this.tookInMillis = tookInMillis;
    }

    @Override
    public Iterator<Item> iterator() {
        return Arrays.stream(this.items).iterator();
    }

    public Item[] getResponses() {
        return this.items;
    }

    public TimeValue getTook() {
        return new TimeValue(this.tookInMillis);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeArray(this.items);
        if (out.getVersion().onOrAfter(LegacyESVersion.V_7_0_0)) {
            out.writeVLong(this.tookInMillis);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("took", this.tookInMillis);
        builder.startArray("responses");
        for (Item item : this.items) {
            if (item.isFailure()) {
                builder.startObject();
                OpenSearchException.generateFailureXContent(builder, params, item.getFailure(), true);
                builder.field("status", ExceptionsHelper.status(item.getFailure()).getStatus());
                builder.endObject();
                continue;
            }
            item.getResponse().toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static MultiSearchTemplateResponse fromXContext(XContentParser parser) {
        MultiSearchResponse mSearchResponse = MultiSearchResponse.fromXContext(parser);
        MultiSearchResponse.Item[] responses = mSearchResponse.getResponses();
        Item[] templateResponses = new Item[responses.length];
        int i = 0;
        for (MultiSearchResponse.Item item : responses) {
            SearchTemplateResponse stResponse = null;
            if (item.getResponse() != null) {
                stResponse = new SearchTemplateResponse();
                stResponse.setResponse(item.getResponse());
            }
            templateResponses[i++] = new Item(stResponse, item.getFailure());
        }
        return new MultiSearchTemplateResponse(templateResponses, mSearchResponse.getTook().millis());
    }

    public String toString() {
        return Strings.toString(MediaTypeRegistry.JSON, this);
    }

    public static class Item
    implements Writeable {
        private final SearchTemplateResponse response;
        private final Exception exception;

        private Item(StreamInput in) throws IOException {
            if (in.readBoolean()) {
                this.response = new SearchTemplateResponse(in);
                this.exception = null;
            } else {
                this.exception = in.readException();
                this.response = null;
            }
        }

        public Item(SearchTemplateResponse response, Exception exception) {
            this.response = response;
            this.exception = exception;
        }

        public boolean isFailure() {
            return this.exception != null;
        }

        @Nullable
        public String getFailureMessage() {
            return this.exception == null ? null : this.exception.getMessage();
        }

        @Nullable
        public SearchTemplateResponse getResponse() {
            return this.response;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (this.response != null) {
                out.writeBoolean(true);
                this.response.writeTo(out);
            } else {
                out.writeBoolean(false);
                out.writeException(this.exception);
            }
        }

        public Exception getFailure() {
            return this.exception;
        }

        public String toString() {
            return "Item [response=" + String.valueOf(this.response) + ", exception=" + String.valueOf(this.exception) + "]";
        }
    }

    static final class Fields {
        static final String RESPONSES = "responses";
        static final String STATUS = "status";

        Fields() {
        }
    }
}

