/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.graylog.shaded.opensearch2.org.apache.lucene.geo.GeoEncodingUtils;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.SloppyMath;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchParseException;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.GeoPoint;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.GeoShapeDocValue;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.GeoUtils;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.OpenSearchSloppyMath;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.support.XContentMapValues;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.geometry.Rectangle;

public final class GeoTileUtils {
    private static final double PI_DIV_2 = 1.5707963267948966;
    public static final int MAX_ZOOM = 29;
    public static final double LATITUDE_MASK = 85.0511287798066;
    public static final double NORMALIZED_LATITUDE_MASK = GeoEncodingUtils.decodeLatitude(GeoEncodingUtils.encodeLatitude(85.0511287798066));
    public static final double NORMALIZED_NEGATIVE_LATITUDE_MASK = GeoEncodingUtils.decodeLatitude(GeoEncodingUtils.encodeLatitude(-85.0511287798066));
    private static final int ZOOM_SHIFT = 58;
    private static final long X_Y_VALUE_MASK = 0x1FFFFFFFL;

    private GeoTileUtils() {
    }

    public static int parsePrecision(XContentParser parser) throws IOException, OpenSearchParseException {
        Object node = parser.currentToken().equals((Object)XContentParser.Token.VALUE_NUMBER) ? Integer.valueOf(parser.intValue()) : parser.text();
        return XContentMapValues.nodeIntegerValue(node);
    }

    public static int checkPrecisionRange(int precision) {
        if (precision < 0 || precision > 29) {
            throw new IllegalArgumentException("Invalid geotile_grid precision of " + precision + ". Must be between 0 and 29.");
        }
        return precision;
    }

    public static int getXTile(double longitude, long tiles) {
        if (longitude == -180.0) {
            return 0;
        }
        int xTile = (int)Math.floor((GeoUtils.normalizeLon(longitude) + 180.0) / 360.0 * (double)tiles);
        if (xTile < 0) {
            return 0;
        }
        if ((long)xTile >= tiles) {
            return (int)tiles - 1;
        }
        return xTile;
    }

    public static int getYTile(double latitude, long tiles) {
        double latSin = SloppyMath.cos(1.5707963267948966 - Math.toRadians(GeoUtils.normalizeLat(latitude)));
        int yTile = (int)Math.floor((0.5 - Math.log((1.0 + latSin) / (1.0 - latSin)) / (Math.PI * 4)) * (double)tiles);
        if (yTile < 0) {
            yTile = 0;
        }
        if ((long)yTile >= tiles) {
            return (int)tiles - 1;
        }
        return yTile;
    }

    public static long longEncode(double longitude, double latitude, int precision) {
        long tiles = 1 << GeoTileUtils.checkPrecisionRange(precision);
        long xTile = GeoTileUtils.getXTile(longitude, tiles);
        long yTile = GeoTileUtils.getYTile(latitude, tiles);
        return GeoTileUtils.longEncodeTiles(precision, xTile, yTile);
    }

    public static long longEncode(String hashAsString) {
        int[] parsed = GeoTileUtils.parseHash(hashAsString);
        return GeoTileUtils.longEncode(parsed[0], parsed[1], (long)parsed[2]);
    }

    public static long longEncodeTiles(int precision, long xTile, long yTile) {
        return (long)precision << 58 | xTile << 29 | yTile;
    }

    private static int[] parseHash(long hash) {
        int zoom = (int)(hash >>> 58);
        int xTile = (int)(hash >>> 29 & 0x1FFFFFFFL);
        int yTile = (int)(hash & 0x1FFFFFFFL);
        return new int[]{zoom, xTile, yTile};
    }

    private static long longEncode(long precision, long xTile, long yTile) {
        return precision << 58 | xTile << 29 | yTile;
    }

    private static int[] parseHash(String hashAsString) {
        String[] parts = hashAsString.split("/", 4);
        if (parts.length != 3) {
            throw new IllegalArgumentException("Invalid geotile_grid hash string of " + hashAsString + ". Must be three integers in a form \"zoom/x/y\".");
        }
        try {
            return new int[]{Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2])};
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid geotile_grid hash string of " + hashAsString + ". Must be three integers in a form \"zoom/x/y\".", e);
        }
    }

    public static String stringEncode(long hash) {
        int[] res = GeoTileUtils.parseHash(hash);
        GeoTileUtils.validateZXY(res[0], res[1], res[2]);
        return res[0] + "/" + res[1] + "/" + res[2];
    }

    public static String stringEncode(double longitude, double latitude, int precision) {
        return GeoTileUtils.stringEncode(GeoTileUtils.longEncode(longitude, latitude, precision));
    }

    public static GeoPoint hashToGeoPoint(long hash) {
        int[] res = GeoTileUtils.parseHash(hash);
        return GeoTileUtils.zxyToGeoPoint(res[0], res[1], res[2]);
    }

    public static GeoPoint keyToGeoPoint(String hashAsString) {
        int[] hashAsInts = GeoTileUtils.parseHash(hashAsString);
        return GeoTileUtils.zxyToGeoPoint(hashAsInts[0], hashAsInts[1], hashAsInts[2]);
    }

    public static Rectangle toBoundingBox(long hash) {
        int[] hashAsInts = GeoTileUtils.parseHash(hash);
        return GeoTileUtils.toBoundingBox(hashAsInts[1], hashAsInts[2], hashAsInts[0]);
    }

    public static Rectangle toBoundingBox(String hash) {
        int[] hashAsInts = GeoTileUtils.parseHash(hash);
        return GeoTileUtils.toBoundingBox(hashAsInts[1], hashAsInts[2], hashAsInts[0]);
    }

    public static List<Long> encodeShape(GeoShapeDocValue geoShapeDocValue, int precision) {
        GeoShapeDocValue.BoundingRectangle boundingRectangle = geoShapeDocValue.getBoundingRectangle();
        long totalTilesAtPrecision = 1L << GeoTileUtils.checkPrecisionRange(precision);
        int maxXTile = GeoTileUtils.getXTile(boundingRectangle.getMaxX(), totalTilesAtPrecision);
        int minXTile = GeoTileUtils.getXTile(boundingRectangle.getMinX(), totalTilesAtPrecision);
        int minYTile = GeoTileUtils.getYTile(boundingRectangle.getMaxY(), totalTilesAtPrecision);
        int maxYTile = GeoTileUtils.getYTile(boundingRectangle.getMinY(), totalTilesAtPrecision);
        ArrayList<Long> encodedValues = new ArrayList<Long>();
        for (int x = minXTile; x <= maxXTile; ++x) {
            for (int y = minYTile; y <= maxYTile; ++y) {
                long encodedValue = GeoTileUtils.longEncodeTiles(precision, x, y);
                Rectangle tileRectangle = GeoTileUtils.toBoundingBox(encodedValue);
                if (!geoShapeDocValue.isIntersectingRectangle(tileRectangle)) continue;
                encodedValues.add(encodedValue);
            }
        }
        return encodedValues;
    }

    public static Rectangle toBoundingBox(int xTile, int yTile, int precision) {
        double tiles = GeoTileUtils.validateZXY(precision, xTile, yTile);
        double minN = Math.PI - Math.PI * 2 * (double)(yTile + 1) / tiles;
        double maxN = Math.PI - Math.PI * 2 * (double)yTile / tiles;
        double minY = Math.toDegrees(OpenSearchSloppyMath.atan(OpenSearchSloppyMath.sinh(minN)));
        double minX = (double)xTile / tiles * 360.0 - 180.0;
        double maxY = Math.toDegrees(OpenSearchSloppyMath.atan(OpenSearchSloppyMath.sinh(maxN)));
        double maxX = (double)(xTile + 1) / tiles * 360.0 - 180.0;
        return new Rectangle(minX, maxX, maxY, minY);
    }

    private static int validateZXY(int zoom, int xTile, int yTile) {
        int tiles = 1 << GeoTileUtils.checkPrecisionRange(zoom);
        if (xTile < 0 || yTile < 0 || xTile >= tiles || yTile >= tiles) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Zoom/X/Y combination is not valid: %d/%d/%d", zoom, xTile, yTile));
        }
        return tiles;
    }

    private static GeoPoint zxyToGeoPoint(int zoom, int xTile, int yTile) {
        int tiles = GeoTileUtils.validateZXY(zoom, xTile, yTile);
        double n = Math.PI - Math.PI * 2 * ((double)yTile + 0.5) / (double)tiles;
        double lat = Math.toDegrees(OpenSearchSloppyMath.atan(OpenSearchSloppyMath.sinh(n)));
        double lon = ((double)xTile + 0.5) / (double)tiles * 360.0 - 180.0;
        return new GeoPoint(lat, lon);
    }
}

