/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.adjacency;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.IndexSearcher;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Query;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ScoreMode;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Weight;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryShardContext;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.Aggregator;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.AggregatorFactories;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.AggregatorFactory;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.CardinalityUpperBound;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.adjacency.AdjacencyMatrixAggregator;
import org.graylog.shaded.opensearch2.org.opensearch.search.internal.SearchContext;

public class AdjacencyMatrixAggregatorFactory
extends AggregatorFactory {
    private final String[] keys;
    private final Weight[] weights;
    private final boolean showOnlyIntersecting;
    private final String separator;

    public AdjacencyMatrixAggregatorFactory(String name, List<AdjacencyMatrixAggregator.KeyedFilter> filters, boolean showOnlyIntersecting, String separator, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactories, Map<String, Object> metadata) throws IOException {
        super(name, queryShardContext, parent, subFactories, metadata);
        IndexSearcher contextSearcher = queryShardContext.searcher();
        this.separator = separator;
        this.weights = new Weight[filters.size()];
        this.keys = new String[filters.size()];
        for (int i = 0; i < filters.size(); ++i) {
            AdjacencyMatrixAggregator.KeyedFilter keyedFilter = filters.get(i);
            this.keys[i] = keyedFilter.key();
            Query filter = keyedFilter.filter().toQuery(queryShardContext);
            this.weights[i] = contextSearcher.createWeight(contextSearcher.rewrite(filter), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        }
        this.showOnlyIntersecting = showOnlyIntersecting;
    }

    @Override
    public Aggregator createInternal(SearchContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        return new AdjacencyMatrixAggregator(this.name, this.factories, this.separator, this.keys, this.weights, this.showOnlyIntersecting, searchContext, parent, metadata);
    }

    @Override
    protected boolean supportsConcurrentSegmentSearch() {
        return true;
    }
}

