/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.filterrewrite;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.PointValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ConstantScoreQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.FieldExistsQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.IndexOrDocValuesQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.MatchAllDocsQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.PointRangeQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Query;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.NumericUtils;
import org.graylog.shaded.opensearch2.org.opensearch.common.Rounding;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.search.function.FunctionScoreQuery;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.DateFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.NumberFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.DateRangeIncludingNowQuery;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.filterrewrite.Ranges;
import org.graylog.shaded.opensearch2.org.opensearch.search.approximate.ApproximateScoreQuery;
import org.graylog.shaded.opensearch2.org.opensearch.search.internal.SearchContext;

final class Helper {
    static final String loggerName = Helper.class.getPackageName();
    private static final Logger logger = LogManager.getLogger((String)loggerName);
    private static final Map<Class<?>, Function<Query, Query>> queryWrappers = new HashMap();

    private Helper() {
    }

    private static Query unwrapIntoConcreteQuery(Query query) {
        while (queryWrappers.containsKey(query.getClass())) {
            query = queryWrappers.get(query.getClass()).apply(query);
        }
        return query;
    }

    private static long[] getShardBounds(List<LeafReaderContext> leaves, String fieldName) throws IOException {
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        for (LeafReaderContext leaf : leaves) {
            PointValues values = leaf.reader().getPointValues(fieldName);
            if (values == null) continue;
            min = Math.min(min, NumericUtils.sortableBytesToLong(values.getMinPackedValue(), 0));
            max = Math.max(max, NumericUtils.sortableBytesToLong(values.getMaxPackedValue(), 0));
        }
        if (min == Long.MAX_VALUE || max == Long.MIN_VALUE) {
            return null;
        }
        return new long[]{min, max};
    }

    static long[] getSegmentBounds(LeafReaderContext context, String fieldName) throws IOException {
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        PointValues values = context.reader().getPointValues(fieldName);
        if (values != null) {
            min = Math.min(min, NumericUtils.sortableBytesToLong(values.getMinPackedValue(), 0));
            max = Math.max(max, NumericUtils.sortableBytesToLong(values.getMaxPackedValue(), 0));
        }
        if (min == Long.MAX_VALUE || max == Long.MIN_VALUE) {
            return null;
        }
        return new long[]{min, max};
    }

    public static long[] getDateHistoAggBounds(SearchContext context, String fieldName) throws IOException {
        Query cq = Helper.unwrapIntoConcreteQuery(context.query());
        List<LeafReaderContext> leaves = context.searcher().getIndexReader().leaves();
        if (cq instanceof PointRangeQuery) {
            PointRangeQuery prq = (PointRangeQuery)cq;
            long[] indexBounds = Helper.getShardBounds(leaves, fieldName);
            if (indexBounds == null) {
                return null;
            }
            return Helper.getBoundsWithRangeQuery(prq, fieldName, indexBounds);
        }
        if (cq instanceof MatchAllDocsQuery) {
            return Helper.getShardBounds(leaves, fieldName);
        }
        if (cq instanceof FieldExistsQuery && ((FieldExistsQuery)cq).getField().equals(fieldName)) {
            return Helper.getShardBounds(leaves, fieldName);
        }
        return null;
    }

    private static long[] getBoundsWithRangeQuery(PointRangeQuery prq, String fieldName, long[] indexBounds) {
        if (prq.getField().equals(fieldName)) {
            long upper;
            long lower = Math.max(NumericUtils.sortableBytesToLong(prq.getLowerPoint(), 0), indexBounds[0]);
            if (lower > (upper = Math.min(NumericUtils.sortableBytesToLong(prq.getUpperPoint(), 0), indexBounds[1]))) {
                return null;
            }
            return new long[]{lower, upper};
        }
        return null;
    }

    static Ranges createRangesFromAgg(DateFieldMapper.DateFieldType fieldType, long interval, Rounding.Prepared preparedRounding, long low, long high, int maxAggRewriteFilters) {
        long roundedLow;
        long prevRounded = roundedLow = preparedRounding.round(fieldType.convertNanosToMillis(low));
        int bucketCount = 0;
        while (roundedLow <= fieldType.convertNanosToMillis(high)) {
            if (++bucketCount > maxAggRewriteFilters) {
                logger.debug("Max number of range filters reached [{}], skip the optimization", (Object)maxAggRewriteFilters);
                return null;
            }
            if (prevRounded == (roundedLow = preparedRounding.round(roundedLow + interval))) break;
            prevRounded = roundedLow;
        }
        long[][] ranges = new long[bucketCount][2];
        if (bucketCount > 0) {
            roundedLow = preparedRounding.round(fieldType.convertNanosToMillis(low));
            for (int i = 0; i < bucketCount; ++i) {
                long lower = i == 0 ? low : fieldType.convertRoundedMillisToNanos(roundedLow);
                roundedLow = preparedRounding.round(roundedLow + interval);
                long upper = i + 1 == bucketCount ? high + 1L : fieldType.convertRoundedMillisToNanos(roundedLow);
                ranges[i][0] = lower;
                ranges[i][1] = upper;
            }
        }
        byte[][] lowers = new byte[ranges.length][];
        byte[][] uppers = new byte[ranges.length][];
        for (int i = 0; i < ranges.length; ++i) {
            byte[] lower = NumberFieldMapper.NumberType.LONG.encodePoint(ranges[i][0]);
            byte[] max = NumberFieldMapper.NumberType.LONG.encodePoint(ranges[i][1]);
            lowers[i] = lower;
            uppers[i] = max;
        }
        return new Ranges(lowers, uppers);
    }

    static {
        queryWrappers.put(ConstantScoreQuery.class, q -> ((ConstantScoreQuery)q).getQuery());
        queryWrappers.put(FunctionScoreQuery.class, q -> ((FunctionScoreQuery)q).getSubQuery());
        queryWrappers.put(DateRangeIncludingNowQuery.class, q -> ((DateRangeIncludingNowQuery)q).getQuery());
        queryWrappers.put(IndexOrDocValuesQuery.class, q -> ((IndexOrDocValuesQuery)q).getIndexQuery());
        queryWrappers.put(ApproximateScoreQuery.class, q -> ((ApproximateScoreQuery)q).getOriginalQuery());
    }
}

