/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.filterrewrite;

import java.io.IOException;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.PointValues;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MappedFieldType;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.NumericPointEncoder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.filterrewrite.AggregatorBridge;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.filterrewrite.FilterRewriteOptimizationContext;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.filterrewrite.PointTreeTraversal;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.filterrewrite.Ranges;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.range.RangeAggregator;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.ValuesSource;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.ValuesSourceConfig;

public abstract class RangeAggregatorBridge
extends AggregatorBridge {
    protected boolean canOptimize(ValuesSourceConfig config, RangeAggregator.Range[] ranges) {
        if (config.fieldType() == null) {
            return false;
        }
        MappedFieldType fieldType = config.fieldType();
        assert (fieldType != null);
        if (!fieldType.isSearchable() || !(fieldType instanceof NumericPointEncoder)) {
            return false;
        }
        if (config.script() == null && config.missing() == null && config.getValuesSource() instanceof ValuesSource.Numeric.FieldData) {
            double prevTo = ranges[0].getTo();
            for (int i = 1; i < ranges.length; ++i) {
                if (prevTo > ranges[i].getFrom()) {
                    return false;
                }
                prevTo = ranges[i].getTo();
            }
            this.fieldType = config.fieldType();
            return true;
        }
        return false;
    }

    protected void buildRanges(RangeAggregator.Range[] ranges) {
        assert (this.fieldType instanceof NumericPointEncoder);
        NumericPointEncoder numericPointEncoder = (NumericPointEncoder)((Object)this.fieldType);
        byte[][] lowers = new byte[ranges.length][];
        byte[][] uppers = new byte[ranges.length][];
        for (int i = 0; i < ranges.length; ++i) {
            double rangeMin = ranges[i].getFrom();
            double rangeMax = ranges[i].getTo();
            byte[] lower = numericPointEncoder.encodePoint(rangeMin);
            byte[] upper = numericPointEncoder.encodePoint(rangeMax);
            lowers[i] = lower;
            uppers[i] = upper;
        }
        this.setRanges.accept(new Ranges(lowers, uppers));
    }

    @Override
    final Ranges tryBuildRangesFromSegment(LeafReaderContext leaf) {
        throw new UnsupportedOperationException("Range aggregation should not build ranges at segment level");
    }

    @Override
    final FilterRewriteOptimizationContext.DebugInfo tryOptimize(PointValues values, BiConsumer<Long, Long> incrementDocCount, Ranges ranges) throws IOException {
        int size = Integer.MAX_VALUE;
        BiConsumer<Integer, Integer> incrementFunc = (activeIndex, docCount) -> {
            long bucketOrd = this.bucketOrdProducer().apply(activeIndex);
            incrementDocCount.accept(bucketOrd, Long.valueOf(docCount.intValue()));
        };
        return PointTreeTraversal.multiRangesTraverse(values.getPointTree(), ranges, incrementFunc, size);
    }

    protected abstract Function<Object, Long> bucketOrdProducer();
}

