/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.DocValueFormat;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.Aggregation;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.InternalSignificantTerms;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.SignificantTerms;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.TermsAggregator;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.heuristic.SignificanceHeuristic;

public abstract class InternalMappedSignificantTerms<A extends InternalMappedSignificantTerms<A, B>, B extends InternalSignificantTerms.Bucket<B>>
extends InternalSignificantTerms<A, B> {
    protected final DocValueFormat format;
    protected final long subsetSize;
    protected final long supersetSize;
    protected final SignificanceHeuristic significanceHeuristic;
    protected final List<B> buckets;
    protected Map<String, B> bucketMap;

    protected InternalMappedSignificantTerms(String name, Map<String, Object> metadata, DocValueFormat format, long subsetSize, long supersetSize, SignificanceHeuristic significanceHeuristic, List<B> buckets, TermsAggregator.BucketCountThresholds bucketCountThresholds) {
        super(name, bucketCountThresholds, metadata);
        this.format = format;
        this.buckets = buckets;
        this.subsetSize = subsetSize;
        this.supersetSize = supersetSize;
        this.significanceHeuristic = significanceHeuristic;
    }

    protected InternalMappedSignificantTerms(StreamInput in, InternalSignificantTerms.Bucket.Reader<B> bucketReader) throws IOException {
        super(in);
        this.format = in.readNamedWriteable(DocValueFormat.class);
        this.subsetSize = in.readVLong();
        this.supersetSize = in.readVLong();
        this.significanceHeuristic = in.readNamedWriteable(SignificanceHeuristic.class);
        this.buckets = in.readList(stream -> bucketReader.read(stream, this.subsetSize, this.supersetSize, this.format));
    }

    @Override
    protected final void writeTermTypeInfoTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.format);
        out.writeVLong(this.subsetSize);
        out.writeVLong(this.supersetSize);
        out.writeNamedWriteable(this.significanceHeuristic);
        out.writeList(this.buckets);
    }

    @Override
    public Iterator<SignificantTerms.Bucket> iterator() {
        return this.buckets.stream().map(bucket -> bucket).collect(Collectors.toList()).iterator();
    }

    @Override
    public List<B> getBuckets() {
        return this.buckets;
    }

    public B getBucketByKey(String term) {
        if (this.bucketMap == null) {
            this.bucketMap = this.buckets.stream().collect(Collectors.toMap(MultiBucketsAggregation.Bucket::getKeyAsString, Function.identity()));
        }
        return (B)((InternalSignificantTerms.Bucket)this.bucketMap.get(term));
    }

    @Override
    protected long getSubsetSize() {
        return this.subsetSize;
    }

    @Override
    protected long getSupersetSize() {
        return this.supersetSize;
    }

    @Override
    protected SignificanceHeuristic getSignificanceHeuristic() {
        return this.significanceHeuristic;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalMappedSignificantTerms that = (InternalMappedSignificantTerms)obj;
        return Objects.equals(this.format, that.format) && this.subsetSize == that.subsetSize && this.supersetSize == that.supersetSize && Objects.equals(this.significanceHeuristic, that.significanceHeuristic) && Objects.equals(this.buckets, that.buckets) && Objects.equals(this.bucketMap, that.bucketMap);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.format, this.subsetSize, this.supersetSize, this.significanceHeuristic, this.buckets, this.bucketMap);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.subsetSize);
        builder.field("bg_count", this.supersetSize);
        builder.startArray(Aggregation.CommonFields.BUCKETS.getPreferredName());
        for (InternalSignificantTerms.Bucket bucket : this.buckets) {
            if (bucket.subsetDf < this.minDocCount) continue;
            bucket.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }
}

