/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.HdrHistogram.DoubleHistogram;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.search.DocValueFormat;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.AbstractInternalHDRPercentiles;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.Percentile;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.Percentiles;

public class InternalHDRPercentiles
extends AbstractInternalHDRPercentiles
implements Percentiles {
    public static final String NAME = "hdr_percentiles";

    public InternalHDRPercentiles(String name, double[] percents, DoubleHistogram state, boolean keyed, DocValueFormat formatter, Map<String, Object> metadata) {
        super(name, percents, state, keyed, formatter, metadata);
    }

    public InternalHDRPercentiles(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public Iterator<Percentile> iterator() {
        return new Iter(this.keys, this.state);
    }

    @Override
    public double percentile(double percent) {
        if (this.state.getTotalCount() == 0L) {
            return Double.NaN;
        }
        return this.state.getValueAtPercentile(percent);
    }

    @Override
    public String percentileAsString(double percent) {
        return this.valueAsString(String.valueOf(percent));
    }

    @Override
    public double value(double key) {
        return this.percentile(key);
    }

    @Override
    protected AbstractInternalHDRPercentiles createReduced(String name, double[] keys, DoubleHistogram merged, boolean keyed, Map<String, Object> metadata) {
        return new InternalHDRPercentiles(name, keys, merged, keyed, this.format, metadata);
    }

    public static class Iter
    implements Iterator<Percentile> {
        private final double[] percents;
        private final DoubleHistogram state;
        private int i;

        public Iter(double[] percents, DoubleHistogram state) {
            this.percents = percents;
            this.state = state;
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.percents.length;
        }

        @Override
        public Percentile next() {
            double percent = this.percents[this.i];
            double value = this.state.getTotalCount() == 0L ? Double.NaN : this.state.getValueAtPercentile(percent);
            Percentile next = new Percentile(percent, value);
            ++this.i;
            return next;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

