/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SortedNumericDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ScoreMode;
import org.graylog.shaded.opensearch2.org.opensearch.common.lease.Releasable;
import org.graylog.shaded.opensearch2.org.opensearch.common.lease.Releasables;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.BigArrays;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.LongArray;
import org.graylog.shaded.opensearch2.org.opensearch.index.codec.composite.CompositeIndexFieldInfo;
import org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube.MetricStat;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.MultiGeoPointValues;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.SortedBinaryDocValues;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.Aggregator;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.InternalAggregation;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.LeafBucketCollector;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.StarTreeBucketCollector;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.StarTreePreComputeCollector;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.InternalValueCount;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.ValuesSource;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.graylog.shaded.opensearch2.org.opensearch.search.internal.SearchContext;
import org.graylog.shaded.opensearch2.org.opensearch.search.startree.StarTreeQueryHelper;

public class ValueCountAggregator
extends NumericMetricsAggregator.SingleValue
implements StarTreePreComputeCollector {
    final ValuesSource valuesSource;
    LongArray counts;

    public ValueCountAggregator(String name, ValuesSourceConfig valuesSourceConfig, SearchContext aggregationContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, aggregationContext, parent, metadata);
        ValuesSource valuesSource = this.valuesSource = valuesSourceConfig.hasValues() ? valuesSourceConfig.getValuesSource() : null;
        if (this.valuesSource != null) {
            this.counts = this.context.bigArrays().newLongArray(1L, true);
        }
    }

    @Override
    protected boolean tryPrecomputeAggregationForLeaf(LeafReaderContext ctx) throws IOException {
        CompositeIndexFieldInfo supportedStarTree;
        if (this.valuesSource instanceof ValuesSource.Numeric && (supportedStarTree = StarTreeQueryHelper.getSupportedStarTree(this.context.getQueryShardContext())) != null) {
            if (this.parent != null && this.subAggregators.length == 0) {
                return true;
            }
            this.precomputeLeafUsingStarTree(ctx, supportedStarTree);
            return true;
        }
        return false;
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.context.bigArrays();
        if (this.valuesSource instanceof ValuesSource.Numeric) {
            final SortedNumericDocValues values = ((ValuesSource.Numeric)this.valuesSource).longValues(ctx);
            return new LeafBucketCollectorBase(sub, values){

                @Override
                public void collect(int doc, long bucket) throws IOException {
                    ValueCountAggregator.this.counts = bigArrays.grow(ValueCountAggregator.this.counts, bucket + 1L);
                    if (values.advanceExact(doc)) {
                        ValueCountAggregator.this.counts.increment(bucket, values.docValueCount());
                    }
                }
            };
        }
        if (this.valuesSource instanceof ValuesSource.GeoPoint) {
            final MultiGeoPointValues values = ((ValuesSource.GeoPoint)this.valuesSource).geoPointValues(ctx);
            return new LeafBucketCollectorBase(sub, null){

                @Override
                public void collect(int doc, long bucket) throws IOException {
                    ValueCountAggregator.this.counts = bigArrays.grow(ValueCountAggregator.this.counts, bucket + 1L);
                    if (values.advanceExact(doc)) {
                        ValueCountAggregator.this.counts.increment(bucket, values.docValueCount());
                    }
                }
            };
        }
        final SortedBinaryDocValues values = this.valuesSource.bytesValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                ValueCountAggregator.this.counts = bigArrays.grow(ValueCountAggregator.this.counts, bucket + 1L);
                if (values.advanceExact(doc)) {
                    ValueCountAggregator.this.counts.increment(bucket, values.docValueCount());
                }
            }
        };
    }

    private void precomputeLeafUsingStarTree(LeafReaderContext ctx, CompositeIndexFieldInfo starTree) throws IOException {
        StarTreeQueryHelper.precomputeLeafUsingStarTree(this.context, (ValuesSource.Numeric)this.valuesSource, ctx, starTree, MetricStat.VALUE_COUNT.getTypeName(), value -> this.counts.increment(0L, (long)value), () -> {});
    }

    @Override
    public double metric(long owningBucketOrd) {
        return this.valuesSource == null || owningBucketOrd >= this.counts.size() ? 0.0 : (double)this.counts.get(owningBucketOrd);
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSource == null || bucket >= this.counts.size()) {
            return this.buildEmptyAggregation();
        }
        return new InternalValueCount(this.name, this.counts.get(bucket), this.metadata());
    }

    @Override
    public ScoreMode scoreMode() {
        return this.valuesSource != null && this.valuesSource.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalValueCount(this.name, 0L, this.metadata());
    }

    @Override
    public void doClose() {
        Releasables.close((Releasable)this.counts);
    }

    @Override
    public StarTreeBucketCollector getStarTreeBucketCollector(LeafReaderContext ctx, CompositeIndexFieldInfo starTree, StarTreeBucketCollector parentCollector) throws IOException {
        return StarTreeQueryHelper.getStarTreeBucketMetricCollector(starTree, MetricStat.VALUE_COUNT.getTypeName(), (ValuesSource.Numeric)this.valuesSource, parentCollector, bucket -> {
            this.counts = this.context.bigArrays().grow(this.counts, bucket + 1L);
        }, (bucket, metricValue) -> this.counts.increment((long)bucket, (long)metricValue));
    }
}

