/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support;

import java.io.IOException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.LegacyESVersion;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.common.joda.Joda;
import org.graylog.shaded.opensearch2.org.opensearch.common.time.DateUtils;
import org.graylog.shaded.opensearch2.org.opensearch.core.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.AbstractObjectParser;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ObjectParser;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryShardContext;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.WithFieldName;
import org.graylog.shaded.opensearch2.org.opensearch.script.Script;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.AbstractAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.AggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.AggregationInitializationException;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.AggregatorFactories;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.AggregatorFactory;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.ValueType;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.ValuesSource;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.ValuesSourceRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.ValuesSourceType;

public abstract class ValuesSourceAggregationBuilder<AB extends ValuesSourceAggregationBuilder<AB>>
extends AbstractAggregationBuilder<AB>
implements WithFieldName {
    private String field = null;
    private Script script = null;
    private ValueType userValueTypeHint = null;
    private String format = null;
    private Object missing = null;
    private ZoneId timeZone = null;
    protected ValuesSourceConfig config;

    public static <T> void declareFields(AbstractObjectParser<? extends ValuesSourceAggregationBuilder<?>, T> objectParser, boolean scriptable, boolean formattable, boolean timezoneAware) {
        ValuesSourceAggregationBuilder.declareFields(objectParser, scriptable, formattable, timezoneAware, true);
    }

    public static <T> void declareFields(AbstractObjectParser<? extends ValuesSourceAggregationBuilder<?>, T> objectParser, boolean scriptable, boolean formattable, boolean timezoneAware, boolean fieldRequired) {
        objectParser.declareField(ValuesSourceAggregationBuilder::field, XContentParser::text, ParseField.CommonFields.FIELD, ObjectParser.ValueType.STRING);
        objectParser.declareField(ValuesSourceAggregationBuilder::missing, XContentParser::objectText, ParseField.CommonFields.MISSING, ObjectParser.ValueType.VALUE);
        objectParser.declareField(ValuesSourceAggregationBuilder::userValueTypeHint, p -> {
            ValueType type = ValueType.lenientParse(p.text());
            if (type == null) {
                throw new IllegalArgumentException("Unknown value type [" + p.text() + "]");
            }
            return type;
        }, ValueType.VALUE_TYPE, ObjectParser.ValueType.STRING);
        if (formattable) {
            objectParser.declareField(ValuesSourceAggregationBuilder::format, XContentParser::text, ParseField.CommonFields.FORMAT, ObjectParser.ValueType.STRING);
        }
        if (scriptable) {
            objectParser.declareField(ValuesSourceAggregationBuilder::script, (parser, context) -> Script.parse(parser), Script.SCRIPT_PARSE_FIELD, ObjectParser.ValueType.OBJECT_OR_STRING);
            if (fieldRequired) {
                String[] fields = new String[]{ParseField.CommonFields.FIELD.getPreferredName(), Script.SCRIPT_PARSE_FIELD.getPreferredName()};
                objectParser.declareRequiredFieldSet(fields);
            }
        } else if (fieldRequired) {
            objectParser.declareRequiredFieldSet(ParseField.CommonFields.FIELD.getPreferredName());
        }
        if (timezoneAware) {
            objectParser.declareField(ValuesSourceAggregationBuilder::timeZone, p -> {
                if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                    return ZoneId.of(p.text());
                }
                return ZoneOffset.ofHours(p.intValue());
            }, ParseField.CommonFields.TIME_ZONE, ObjectParser.ValueType.LONG);
        }
    }

    protected ValuesSourceAggregationBuilder(String name) {
        super(name);
    }

    protected ValuesSourceAggregationBuilder(ValuesSourceAggregationBuilder<AB> clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super(clone, factoriesBuilder, metadata);
        this.field = clone.field;
        this.userValueTypeHint = clone.userValueTypeHint;
        this.format = clone.format;
        this.missing = clone.missing;
        this.timeZone = clone.timeZone;
        this.config = clone.config;
        this.script = clone.script;
    }

    protected ValuesSourceAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        if (this.serializeTargetValueType(in.getVersion())) {
            ValueType valueType = in.readOptionalWriteable(ValueType::readFromStream);
            assert (valueType == null);
        }
        this.read(in);
    }

    private void read(StreamInput in) throws IOException {
        this.field = in.readOptionalString();
        if (in.readBoolean()) {
            this.script = new Script(in);
        }
        if (in.readBoolean()) {
            this.userValueTypeHint = ValueType.readFromStream(in);
        }
        this.format = in.readOptionalString();
        this.missing = in.readGenericValue();
        this.timeZone = in.getVersion().before(LegacyESVersion.V_7_0_0) ? DateUtils.dateTimeZoneToZoneId(Joda.readOptionalTimeZone(in)) : in.readOptionalZoneId();
    }

    @Override
    protected final void doWriteTo(StreamOutput out) throws IOException {
        if (this.serializeTargetValueType(out.getVersion())) {
            out.writeOptionalWriteable(null);
        }
        out.writeOptionalString(this.field);
        boolean hasScript = this.script != null;
        out.writeBoolean(hasScript);
        if (hasScript) {
            this.script.writeTo(out);
        }
        boolean hasValueType = this.userValueTypeHint != null;
        out.writeBoolean(hasValueType);
        if (hasValueType) {
            this.userValueTypeHint.writeTo(out);
        }
        out.writeOptionalString(this.format);
        out.writeGenericValue(this.missing);
        if (out.getVersion().before(LegacyESVersion.V_7_0_0)) {
            Joda.writeOptionalTimeZone(out, DateUtils.zoneIdToDateTimeZone(this.timeZone));
        } else {
            out.writeOptionalZoneId(this.timeZone);
        }
        this.innerWriteTo(out);
    }

    protected abstract void innerWriteTo(StreamOutput var1) throws IOException;

    protected boolean serializeTargetValueType(Version version) {
        return false;
    }

    public AB field(String field) {
        if (field == null) {
            throw new IllegalArgumentException("[field] must not be null: [" + this.name + "]");
        }
        this.field = field;
        return (AB)this;
    }

    public String field() {
        return this.field;
    }

    @Override
    public String fieldName() {
        return this.field();
    }

    public AB script(Script script) {
        if (script == null) {
            throw new IllegalArgumentException("[script] must not be null: [" + this.name + "]");
        }
        this.script = script;
        return (AB)this;
    }

    public Script script() {
        return this.script;
    }

    public AB userValueTypeHint(ValueType valueType) {
        if (valueType == null) {
            throw new IllegalArgumentException("[userValueTypeHint] must not be null: [" + this.name + "]");
        }
        this.userValueTypeHint = valueType;
        return (AB)this;
    }

    public ValueType userValueTypeHint() {
        return this.userValueTypeHint;
    }

    public AB format(String format) {
        if (format == null) {
            throw new IllegalArgumentException("[format] must not be null: [" + this.name + "]");
        }
        this.format = format;
        return (AB)this;
    }

    public String format() {
        return this.format;
    }

    public AB missing(Object missing) {
        if (missing == null) {
            throw new IllegalArgumentException("[missing] must not be null: [" + this.name + "]");
        }
        this.missing = missing;
        return (AB)this;
    }

    public Object missing() {
        return this.missing;
    }

    public AB timeZone(ZoneId timeZone) {
        if (timeZone == null) {
            throw new IllegalArgumentException("[timeZone] must not be null: [" + this.name + "]");
        }
        this.timeZone = timeZone;
        return (AB)this;
    }

    public ZoneId timeZone() {
        return this.timeZone;
    }

    @Override
    protected final ValuesSourceAggregatorFactory doBuild(QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        ValuesSourceConfig config = this.resolveConfig(queryShardContext);
        if (queryShardContext.getValuesSourceRegistry().isRegistered(this.getRegistryKey())) {
            queryShardContext.getValuesSourceRegistry().getAggregator(this.getRegistryKey(), config);
        }
        ValuesSourceAggregatorFactory factory = this.innerBuild(queryShardContext, config, parent, subFactoriesBuilder);
        return factory;
    }

    protected abstract ValuesSourceRegistry.RegistryKey<?> getRegistryKey();

    protected abstract ValuesSourceType defaultValueSourceType();

    protected ValuesSourceConfig resolveConfig(QueryShardContext queryShardContext) {
        return ValuesSourceConfig.resolve(queryShardContext, this.userValueTypeHint, this.field, this.script, this.missing, this.timeZone, this.format, this.defaultValueSourceType());
    }

    protected abstract ValuesSourceAggregatorFactory innerBuild(QueryShardContext var1, ValuesSourceConfig var2, AggregatorFactory var3, AggregatorFactories.Builder var4) throws IOException;

    @Override
    public final XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.field != null) {
            builder.field("field", this.field);
        }
        if (this.script != null) {
            builder.field("script", this.script);
        }
        if (this.missing != null) {
            builder.field("missing", this.missing);
        }
        if (this.format != null) {
            builder.field("format", this.format);
        }
        if (this.timeZone != null) {
            builder.field("time_zone", this.timeZone.toString());
        }
        if (this.userValueTypeHint != null) {
            builder.field("value_type", this.userValueTypeHint.getPreferredName());
        }
        this.doXContentBody(builder, params);
        builder.endObject();
        return builder;
    }

    protected abstract XContentBuilder doXContentBody(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.field, this.format, this.missing, this.script, this.timeZone, this.userValueTypeHint);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ValuesSourceAggregationBuilder other = (ValuesSourceAggregationBuilder)obj;
        return Objects.equals(this.field, other.field) && Objects.equals(this.format, other.format) && Objects.equals(this.missing, other.missing) && Objects.equals(this.script, other.script) && Objects.equals(this.timeZone, other.timeZone) && Objects.equals(this.userValueTypeHint, other.userValueTypeHint);
    }

    public static abstract class LeafOnly<VS extends ValuesSource, AB extends ValuesSourceAggregationBuilder<AB>>
    extends ValuesSourceAggregationBuilder<AB> {
        protected LeafOnly(String name) {
            super(name);
        }

        protected LeafOnly(LeafOnly<VS, AB> clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
            super(clone, factoriesBuilder, metadata);
            if (factoriesBuilder.count() > 0) {
                throw new AggregationInitializationException("Aggregator [" + this.name + "] of type [" + this.getType() + "] cannot accept sub-aggregations");
            }
        }

        protected LeafOnly(StreamInput in) throws IOException {
            super(in);
        }

        @Override
        public final AB subAggregations(AggregatorFactories.Builder subFactories) {
            throw new AggregationInitializationException("Aggregator [" + this.name + "] of type [" + this.getType() + "] cannot accept sub-aggregations");
        }

        @Override
        public final AggregationBuilder.BucketCardinality bucketCardinality() {
            return AggregationBuilder.BucketCardinality.NONE;
        }
    }
}

