/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.approximate;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.BooleanClause;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.IndexSearcher;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Query;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.QueryVisitor;
import org.graylog.shaded.opensearch2.org.opensearch.search.approximate.ApproximateQuery;
import org.graylog.shaded.opensearch2.org.opensearch.search.internal.SearchContext;

public final class ApproximateScoreQuery
extends Query {
    private final Query originalQuery;
    private final ApproximateQuery approximationQuery;
    Query resolvedQuery;

    public ApproximateScoreQuery(Query originalQuery, ApproximateQuery approximationQuery) {
        this.originalQuery = originalQuery;
        this.approximationQuery = approximationQuery;
    }

    public Query getOriginalQuery() {
        return this.originalQuery;
    }

    public ApproximateQuery getApproximationQuery() {
        return this.approximationQuery;
    }

    @Override
    public final Query rewrite(IndexSearcher indexSearcher) throws IOException {
        if (this.resolvedQuery == null) {
            throw new IllegalStateException("Cannot rewrite resolved query without setContext being called");
        }
        return this.resolvedQuery.rewrite(indexSearcher);
    }

    public void setContext(SearchContext context) {
        if (this.resolvedQuery != null) {
            throw new IllegalStateException("Query already resolved, duplicate call to setContext");
        }
        this.resolvedQuery = this.approximationQuery.canApproximate(context) ? this.approximationQuery : this.originalQuery;
    }

    @Override
    public String toString(String s) {
        return "ApproximateScoreQuery(originalQuery=" + this.originalQuery.toString() + ", approximationQuery=" + this.approximationQuery.toString() + ")";
    }

    @Override
    public void visit(QueryVisitor queryVisitor) {
        QueryVisitor v = queryVisitor.getSubVisitor(BooleanClause.Occur.MUST, this);
        this.originalQuery.visit(v);
        this.approximationQuery.visit(v);
    }

    @Override
    public boolean equals(Object o) {
        return this.sameClassAs(o);
    }

    @Override
    public int hashCode() {
        int h = this.classHash();
        h = 31 * h + this.originalQuery.hashCode();
        h = 31 * h + this.approximationQuery.hashCode();
        return h;
    }
}

