/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.backpressure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.opensearch.ExceptionsHelper;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchShardTask;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchTask;
import org.graylog.shaded.opensearch2.org.opensearch.common.lifecycle.AbstractLifecycleComponent;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.ClusterSettings;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Setting;
import org.graylog.shaded.opensearch2.org.opensearch.monitor.jvm.JvmStats;
import org.graylog.shaded.opensearch2.org.opensearch.monitor.process.ProcessProbe;
import org.graylog.shaded.opensearch2.org.opensearch.search.backpressure.SearchBackpressureState;
import org.graylog.shaded.opensearch2.org.opensearch.search.backpressure.settings.SearchBackpressureMode;
import org.graylog.shaded.opensearch2.org.opensearch.search.backpressure.settings.SearchBackpressureSettings;
import org.graylog.shaded.opensearch2.org.opensearch.search.backpressure.settings.SearchShardTaskSettings;
import org.graylog.shaded.opensearch2.org.opensearch.search.backpressure.settings.SearchTaskSettings;
import org.graylog.shaded.opensearch2.org.opensearch.search.backpressure.stats.SearchBackpressureStats;
import org.graylog.shaded.opensearch2.org.opensearch.search.backpressure.stats.SearchShardTaskStats;
import org.graylog.shaded.opensearch2.org.opensearch.search.backpressure.stats.SearchTaskStats;
import org.graylog.shaded.opensearch2.org.opensearch.search.backpressure.trackers.CpuUsageTracker;
import org.graylog.shaded.opensearch2.org.opensearch.search.backpressure.trackers.ElapsedTimeTracker;
import org.graylog.shaded.opensearch2.org.opensearch.search.backpressure.trackers.HeapUsageTracker;
import org.graylog.shaded.opensearch2.org.opensearch.search.backpressure.trackers.NodeDuressTrackers;
import org.graylog.shaded.opensearch2.org.opensearch.search.backpressure.trackers.TaskResourceUsageTrackerType;
import org.graylog.shaded.opensearch2.org.opensearch.search.backpressure.trackers.TaskResourceUsageTrackers;
import org.graylog.shaded.opensearch2.org.opensearch.tasks.CancellableTask;
import org.graylog.shaded.opensearch2.org.opensearch.tasks.SearchBackpressureTask;
import org.graylog.shaded.opensearch2.org.opensearch.tasks.Task;
import org.graylog.shaded.opensearch2.org.opensearch.tasks.TaskCancellation;
import org.graylog.shaded.opensearch2.org.opensearch.tasks.TaskManager;
import org.graylog.shaded.opensearch2.org.opensearch.tasks.TaskResourceTrackingService;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.Scheduler;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;
import org.graylog.shaded.opensearch2.org.opensearch.wlm.QueryGroupService;
import org.graylog.shaded.opensearch2.org.opensearch.wlm.ResourceType;

public class SearchBackpressureService
extends AbstractLifecycleComponent
implements TaskResourceTrackingService.TaskCompletionListener {
    private static final Logger logger = LogManager.getLogger(SearchBackpressureService.class);
    private static final Map<TaskResourceUsageTrackerType, Function<NodeDuressTrackers, Boolean>> trackerApplyConditions = Map.of(TaskResourceUsageTrackerType.CPU_USAGE_TRACKER, nodeDuressTrackers -> nodeDuressTrackers.isResourceInDuress(ResourceType.CPU), TaskResourceUsageTrackerType.HEAP_USAGE_TRACKER, nodeDuressTrackers -> HeapUsageTracker.isHeapTrackingSupported() && nodeDuressTrackers.isResourceInDuress(ResourceType.MEMORY), TaskResourceUsageTrackerType.ELAPSED_TIME_TRACKER, nodeDuressTrackers -> true);
    private volatile Scheduler.Cancellable scheduledFuture;
    private final SearchBackpressureSettings settings;
    private final TaskResourceTrackingService taskResourceTrackingService;
    private final ThreadPool threadPool;
    private final NodeDuressTrackers nodeDuressTrackers;
    private final Map<Class<? extends SearchBackpressureTask>, TaskResourceUsageTrackers> taskTrackers;
    private final Map<Class<? extends SearchBackpressureTask>, SearchBackpressureState> searchBackpressureStates;
    private final TaskManager taskManager;
    private final QueryGroupService queryGroupService;

    public SearchBackpressureService(final SearchBackpressureSettings settings, TaskResourceTrackingService taskResourceTrackingService, ThreadPool threadPool, TaskManager taskManager, QueryGroupService queryGroupService) {
        this(settings, taskResourceTrackingService, threadPool, System::nanoTime, new NodeDuressTrackers((Map<ResourceType, NodeDuressTrackers.NodeDuressTracker>)new EnumMap<ResourceType, NodeDuressTrackers.NodeDuressTracker>(ResourceType.class){
            {
                super(arg0);
                this.put(ResourceType.CPU, new NodeDuressTrackers.NodeDuressTracker(() -> (double)ProcessProbe.getInstance().getProcessCpuPercent() / 100.0 >= settings.getNodeDuressSettings().getCpuThreshold(), () -> settings.getNodeDuressSettings().getNumSuccessiveBreaches()));
                this.put(ResourceType.MEMORY, new NodeDuressTrackers.NodeDuressTracker(() -> (double)JvmStats.jvmStats().getMem().getHeapUsedPercent() / 100.0 >= settings.getNodeDuressSettings().getHeapThreshold(), () -> settings.getNodeDuressSettings().getNumSuccessiveBreaches()));
            }
        }), SearchBackpressureService.getTrackers(settings.getSearchTaskSettings()::getCpuTimeNanosThreshold, settings.getSearchTaskSettings()::getHeapVarianceThreshold, settings.getSearchTaskSettings()::getHeapPercentThreshold, settings.getSearchTaskSettings().getHeapMovingAverageWindowSize(), settings.getSearchTaskSettings()::getElapsedTimeNanosThreshold, settings.getClusterSettings(), SearchTaskSettings.SETTING_HEAP_MOVING_AVERAGE_WINDOW_SIZE), SearchBackpressureService.getTrackers(settings.getSearchShardTaskSettings()::getCpuTimeNanosThreshold, settings.getSearchShardTaskSettings()::getHeapVarianceThreshold, settings.getSearchShardTaskSettings()::getHeapPercentThreshold, settings.getSearchShardTaskSettings().getHeapMovingAverageWindowSize(), settings.getSearchShardTaskSettings()::getElapsedTimeNanosThreshold, settings.getClusterSettings(), SearchShardTaskSettings.SETTING_HEAP_MOVING_AVERAGE_WINDOW_SIZE), taskManager, queryGroupService);
    }

    SearchBackpressureService(SearchBackpressureSettings settings, TaskResourceTrackingService taskResourceTrackingService, ThreadPool threadPool, LongSupplier timeNanosSupplier, NodeDuressTrackers nodeDuressTrackers, TaskResourceUsageTrackers searchTaskTrackers, TaskResourceUsageTrackers searchShardTaskTrackers, TaskManager taskManager, QueryGroupService queryGroupService) {
        this.settings = settings;
        this.taskResourceTrackingService = taskResourceTrackingService;
        this.taskResourceTrackingService.addTaskCompletionListener(this);
        this.threadPool = threadPool;
        this.nodeDuressTrackers = nodeDuressTrackers;
        this.taskManager = taskManager;
        this.queryGroupService = queryGroupService;
        this.searchBackpressureStates = Map.of(SearchTask.class, new SearchBackpressureState(timeNanosSupplier, this.getSettings().getSearchTaskSettings().getCancellationRateNanos(), this.getSettings().getSearchTaskSettings().getCancellationBurst(), this.getSettings().getSearchTaskSettings().getCancellationRatio(), this.getSettings().getSearchTaskSettings().getCancellationRate()), SearchShardTask.class, new SearchBackpressureState(timeNanosSupplier, this.getSettings().getSearchShardTaskSettings().getCancellationRateNanos(), this.getSettings().getSearchShardTaskSettings().getCancellationBurst(), this.getSettings().getSearchShardTaskSettings().getCancellationRatio(), this.getSettings().getSearchShardTaskSettings().getCancellationRate()));
        this.settings.getSearchTaskSettings().addListener(this.searchBackpressureStates.get(SearchTask.class));
        this.settings.getSearchShardTaskSettings().addListener(this.searchBackpressureStates.get(SearchShardTask.class));
        this.taskTrackers = Map.of(SearchTask.class, searchTaskTrackers, SearchShardTask.class, searchShardTaskTrackers);
    }

    void doRun() {
        SearchBackpressureMode mode = this.getSettings().getMode();
        if (mode == SearchBackpressureMode.DISABLED) {
            return;
        }
        if (!this.nodeDuressTrackers.isNodeInDuress()) {
            return;
        }
        List<CancellableTask> searchTasks = this.getTaskByType(SearchTask.class);
        List<CancellableTask> searchShardTasks = this.getTaskByType(SearchShardTask.class);
        boolean isHeapUsageDominatedBySearchTasks = this.isHeapUsageDominatedBySearch(searchTasks, this.getSettings().getSearchTaskSettings().getTotalHeapPercentThreshold());
        boolean isHeapUsageDominatedBySearchShardTasks = this.isHeapUsageDominatedBySearch(searchShardTasks, this.getSettings().getSearchShardTaskSettings().getTotalHeapPercentThreshold());
        Map<Class<? extends SearchBackpressureTask>, List<CancellableTask>> cancellableTasks = Map.of(SearchTask.class, isHeapUsageDominatedBySearchTasks ? searchTasks : Collections.emptyList(), SearchShardTask.class, isHeapUsageDominatedBySearchShardTasks ? searchShardTasks : Collections.emptyList());
        this.taskResourceTrackingService.refreshResourceStats(searchTasks.toArray(new Task[0]));
        this.taskResourceTrackingService.refreshResourceStats(searchShardTasks.toArray(new Task[0]));
        List<TaskCancellation> taskCancellations = new ArrayList<TaskCancellation>();
        for (TaskResourceUsageTrackerType trackerType : TaskResourceUsageTrackerType.values()) {
            if (!this.shouldApply(trackerType)) continue;
            this.addResourceTrackerBasedCancellations(trackerType, taskCancellations, cancellableTasks);
        }
        taskCancellations = this.mergeTaskCancellations(taskCancellations).stream().map(this::addSBPStateUpdateCallback).filter(TaskCancellation::isEligibleForCancellation).collect(Collectors.toList());
        for (TaskCancellation taskCancellation : taskCancellations) {
            boolean ratioLimitReached;
            logger.warn("[{} mode] cancelling task [{}] due to high resource consumption [{}]", (Object)mode.getName(), (Object)taskCancellation.getTask().getId(), (Object)taskCancellation.getReasonString());
            if (mode != SearchBackpressureMode.ENFORCED) continue;
            Class<? extends SearchBackpressureTask> taskType = this.getTaskType(taskCancellation.getTask());
            SearchBackpressureState searchBackpressureState = this.searchBackpressureStates.get(taskType);
            boolean rateLimitReached = !searchBackpressureState.getRateLimiter().request();
            boolean bl = ratioLimitReached = !searchBackpressureState.getRatioLimiter().request();
            if (rateLimitReached && ratioLimitReached) {
                logger.debug("task cancellation limit reached");
                searchBackpressureState.incrementLimitReachedCount();
                break;
            }
            taskCancellation.cancelTaskAndDescendants(this.taskManager);
        }
    }

    boolean isHeapUsageDominatedBySearch(List<CancellableTask> searchTasks, double threshold) {
        return HeapUsageTracker.isHeapUsageDominatedBySearch(searchTasks, threshold);
    }

    private TaskCancellation addSBPStateUpdateCallback(TaskCancellation taskCancellation) {
        CancellableTask task = taskCancellation.getTask();
        Runnable toAddCancellationCallbackForSBPState = this.searchBackpressureStates.get(SearchShardTask.class)::incrementCancellationCount;
        if (task instanceof SearchTask) {
            toAddCancellationCallbackForSBPState = this.searchBackpressureStates.get(SearchTask.class)::incrementCancellationCount;
        }
        ArrayList<Runnable> newOnCancelCallbacks = new ArrayList<Runnable>(taskCancellation.getOnCancelCallbacks());
        newOnCancelCallbacks.add(toAddCancellationCallbackForSBPState);
        return new TaskCancellation(task, taskCancellation.getReasons(), newOnCancelCallbacks);
    }

    private boolean shouldApply(TaskResourceUsageTrackerType trackerType) {
        return trackerApplyConditions.get((Object)trackerType).apply(this.nodeDuressTrackers);
    }

    private List<TaskCancellation> addResourceTrackerBasedCancellations(TaskResourceUsageTrackerType type, List<TaskCancellation> taskCancellations, Map<Class<? extends SearchBackpressureTask>, List<CancellableTask>> cancellableTasks) {
        for (Map.Entry<Class<? extends SearchBackpressureTask>, TaskResourceUsageTrackers> taskResourceUsageTrackers : this.taskTrackers.entrySet()) {
            Optional<TaskResourceUsageTrackers.TaskResourceUsageTracker> taskResourceUsageTracker = taskResourceUsageTrackers.getValue().getTracker(type);
            Class<? extends SearchBackpressureTask> taskType = taskResourceUsageTrackers.getKey();
            taskResourceUsageTracker.ifPresent(tracker -> taskCancellations.addAll(tracker.getTaskCancellations((List)cancellableTasks.get(taskType))));
        }
        return taskCancellations;
    }

    private List<TaskCancellation> mergeTaskCancellations(List<TaskCancellation> taskCancellations) {
        HashMap<Long, TaskCancellation> uniqueTaskCancellations = new HashMap<Long, TaskCancellation>();
        for (TaskCancellation taskCancellation : taskCancellations) {
            long taskId = taskCancellation.getTask().getId();
            uniqueTaskCancellations.put(taskId, uniqueTaskCancellations.getOrDefault(taskId, taskCancellation).merge(taskCancellation));
        }
        return new ArrayList<TaskCancellation>(uniqueTaskCancellations.values());
    }

    Class<? extends SearchBackpressureTask> getTaskType(Task task) {
        if (task instanceof SearchTask) {
            return SearchTask.class;
        }
        if (task instanceof SearchShardTask) {
            return SearchShardTask.class;
        }
        throw new IllegalArgumentException("task must be instance of either SearchTask or SearchShardTask");
    }

    boolean isNodeInDuress() {
        return this.nodeDuressTrackers.isNodeInDuress();
    }

    <T extends CancellableTask> List<CancellableTask> getTaskByType(Class<T> type) {
        return this.taskResourceTrackingService.getResourceAwareTasks().values().stream().filter(type::isInstance).map(type::cast).filter(x$0 -> this.queryGroupService.shouldSBPHandle((Task)x$0)).collect(Collectors.toUnmodifiableList());
    }

    SearchBackpressureSettings getSettings() {
        return this.settings;
    }

    SearchBackpressureState getSearchBackpressureState(Class<? extends SearchBackpressureTask> taskType) {
        return this.searchBackpressureStates.get(taskType);
    }

    public static TaskResourceUsageTrackers getTrackers(LongSupplier cpuThresholdSupplier, DoubleSupplier heapVarianceSupplier, DoubleSupplier heapPercentThresholdSupplier, int heapMovingAverageWindowSize, LongSupplier ElapsedTimeNanosSupplier, ClusterSettings clusterSettings, Setting<Integer> windowSizeSetting) {
        TaskResourceUsageTrackers trackers = new TaskResourceUsageTrackers();
        trackers.addTracker(new CpuUsageTracker(cpuThresholdSupplier), TaskResourceUsageTrackerType.CPU_USAGE_TRACKER);
        if (HeapUsageTracker.isHeapTrackingSupported()) {
            trackers.addTracker(new HeapUsageTracker(heapVarianceSupplier, heapPercentThresholdSupplier, heapMovingAverageWindowSize, clusterSettings, windowSizeSetting), TaskResourceUsageTrackerType.HEAP_USAGE_TRACKER);
        } else {
            logger.warn("heap size couldn't be determined");
        }
        trackers.addTracker(new ElapsedTimeTracker(ElapsedTimeNanosSupplier, System::nanoTime), TaskResourceUsageTrackerType.ELAPSED_TIME_TRACKER);
        return trackers;
    }

    @Override
    public void onTaskCompleted(Task task) {
        if (this.getSettings().getMode() == SearchBackpressureMode.DISABLED) {
            return;
        }
        if (!(task instanceof SearchBackpressureTask)) {
            return;
        }
        CancellableTask cancellableTask = (CancellableTask)task;
        Class<? extends SearchBackpressureTask> taskType = this.getTaskType(task);
        if (!cancellableTask.isCancelled()) {
            this.searchBackpressureStates.get(taskType).incrementCompletionCount();
        }
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        TaskResourceUsageTrackers trackers = this.taskTrackers.get(taskType);
        for (TaskResourceUsageTrackers.TaskResourceUsageTracker tracker : trackers.all()) {
            try {
                tracker.update(task);
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        ExceptionsHelper.maybeThrowRuntimeAndSuppress(exceptions);
    }

    @Override
    protected void doStart() {
        this.scheduledFuture = this.threadPool.scheduleWithFixedDelay(() -> {
            try {
                this.doRun();
            }
            catch (Exception e) {
                logger.debug("failure in search search backpressure", (Throwable)e);
            }
        }, this.getSettings().getInterval(), "generic");
    }

    @Override
    protected void doStop() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel();
        }
    }

    @Override
    protected void doClose() throws IOException {
    }

    public SearchBackpressureStats nodeStats() {
        List<CancellableTask> searchTasks = this.getTaskByType(SearchTask.class);
        List<CancellableTask> searchShardTasks = this.getTaskByType(SearchShardTask.class);
        SearchTaskStats searchTaskStats = new SearchTaskStats(this.searchBackpressureStates.get(SearchTask.class).getCancellationCount(), this.searchBackpressureStates.get(SearchTask.class).getLimitReachedCount(), this.taskTrackers.get(SearchTask.class).all().stream().collect(Collectors.toUnmodifiableMap(t -> TaskResourceUsageTrackerType.fromName(t.name()), t -> t.stats(searchTasks))));
        SearchShardTaskStats searchShardTaskStats = new SearchShardTaskStats(this.searchBackpressureStates.get(SearchShardTask.class).getCancellationCount(), this.searchBackpressureStates.get(SearchShardTask.class).getLimitReachedCount(), this.taskTrackers.get(SearchShardTask.class).all().stream().collect(Collectors.toUnmodifiableMap(t -> TaskResourceUsageTrackerType.fromName(t.name()), t -> t.stats(searchShardTasks))));
        return new SearchBackpressureStats(searchTaskStats, searchShardTaskStats, this.getSettings().getMode());
    }
}

