/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.backpressure;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.LongSupplier;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.TokenBucket;
import org.graylog.shaded.opensearch2.org.opensearch.search.backpressure.CancellationSettingsListener;

public class SearchBackpressureState
implements CancellationSettingsListener {
    private final AtomicReference<TokenBucket> rateLimiter;
    private final AtomicReference<TokenBucket> ratioLimiter;
    private final LongSupplier timeNanosSupplier;
    private final AtomicLong completionCount = new AtomicLong();
    private final AtomicLong cancellationCount = new AtomicLong();
    private final AtomicLong limitReachedCount = new AtomicLong();
    private volatile double cancellationBurst;
    private volatile double cancellationRate;
    private volatile double cancellationRatio;

    SearchBackpressureState(LongSupplier timeNanosSupplier, double cancellationRateNanos, double cancellationBurst, double cancellationRatio, double cancellationRate) {
        this.rateLimiter = new AtomicReference<TokenBucket>(new TokenBucket(timeNanosSupplier, cancellationRateNanos, cancellationBurst));
        this.ratioLimiter = new AtomicReference<TokenBucket>(new TokenBucket(this::getCompletionCount, cancellationRatio, cancellationBurst));
        this.timeNanosSupplier = timeNanosSupplier;
        this.cancellationBurst = cancellationBurst;
        this.cancellationRatio = cancellationRatio;
        this.cancellationRate = cancellationRate;
    }

    public long getCompletionCount() {
        return this.completionCount.get();
    }

    long incrementCompletionCount() {
        return this.completionCount.incrementAndGet();
    }

    public long getCancellationCount() {
        return this.cancellationCount.get();
    }

    long incrementCancellationCount() {
        return this.cancellationCount.incrementAndGet();
    }

    public long getLimitReachedCount() {
        return this.limitReachedCount.get();
    }

    long incrementLimitReachedCount() {
        return this.limitReachedCount.incrementAndGet();
    }

    public TokenBucket getRateLimiter() {
        return this.rateLimiter.get();
    }

    public TokenBucket getRatioLimiter() {
        return this.ratioLimiter.get();
    }

    @Override
    public void onRatioChanged(double ratio) {
        this.cancellationRatio = ratio;
        this.ratioLimiter.set(new TokenBucket(this::getCompletionCount, this.cancellationRatio, this.cancellationBurst));
    }

    @Override
    public void onRateChanged(double rate) {
        this.cancellationRate = rate;
        this.rateLimiter.set(new TokenBucket(this.timeNanosSupplier, this.cancellationRate, this.cancellationBurst));
    }

    @Override
    public void onBurstChanged(double burst) {
        this.cancellationBurst = burst;
        this.onRateChanged(this.cancellationRate);
        this.onRatioChanged(this.cancellationRatio);
    }
}

