/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.dfs;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.Term;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.CollectionStatistics;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TermStatistics;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.search.dfs.DfsSearchResult;

@PublicApi(since="1.0.0")
public class AggregatedDfs
implements Writeable {
    private Map<Term, TermStatistics> termStatistics;
    private Map<String, CollectionStatistics> fieldStatistics;
    private long maxDoc;

    public AggregatedDfs(StreamInput in) throws IOException {
        int size = in.readVInt();
        HashMap<Term, TermStatistics> termStatistics = new HashMap<Term, TermStatistics>(size);
        for (int i = 0; i < size; ++i) {
            Term term = new Term(in.readString(), in.readBytesRef());
            TermStatistics stats = new TermStatistics(in.readBytesRef(), in.readVLong(), DfsSearchResult.subOne(in.readVLong()));
            termStatistics.put(term, stats);
        }
        this.termStatistics = Collections.unmodifiableMap(termStatistics);
        this.fieldStatistics = DfsSearchResult.readFieldStats(in);
        this.maxDoc = in.readVLong();
    }

    public AggregatedDfs(Map<Term, TermStatistics> termStatistics, Map<String, CollectionStatistics> fieldStatistics, long maxDoc) {
        this.termStatistics = termStatistics;
        this.fieldStatistics = fieldStatistics;
        this.maxDoc = maxDoc;
    }

    public Map<Term, TermStatistics> termStatistics() {
        return this.termStatistics;
    }

    public Map<String, CollectionStatistics> fieldStatistics() {
        return this.fieldStatistics;
    }

    public long maxDoc() {
        return this.maxDoc;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.termStatistics.size());
        for (Map.Entry<Term, TermStatistics> c : this.termStatistics().entrySet()) {
            Term term = c.getKey();
            out.writeString(term.field());
            out.writeBytesRef(term.bytes());
            TermStatistics stats = c.getValue();
            out.writeBytesRef(stats.term());
            out.writeVLong(stats.docFreq());
            out.writeVLong(DfsSearchResult.addOne(stats.totalTermFreq()));
        }
        DfsSearchResult.writeFieldStats(out, this.fieldStatistics);
        out.writeVLong(this.maxDoc);
    }
}

