/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.internal;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.StoredFieldsReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.DirectoryReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FilterDirectoryReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FilterLeafReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.PointValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.Terms;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.TermsEnum;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.suggest.document.CompletionTerms;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.automaton.CompiledAutomaton;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.index.SequentialStoredFieldsLeafReader;

class ExitableDirectoryReader
extends FilterDirectoryReader {
    ExitableDirectoryReader(DirectoryReader in, final QueryCancellation queryCancellation) throws IOException {
        super(in, new FilterDirectoryReader.SubReaderWrapper(){

            @Override
            public LeafReader wrap(LeafReader reader) {
                return new ExitableLeafReader(reader, queryCancellation);
            }
        });
    }

    @Override
    protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) {
        throw new UnsupportedOperationException("doWrapDirectoryReader() should never be invoked");
    }

    @Override
    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.in.getReaderCacheHelper();
    }

    static interface QueryCancellation {
        public boolean isEnabled();

        public void checkCancelled();
    }

    private static class ExitableIntersectVisitor
    implements PointValues.IntersectVisitor {
        private static final int MAX_CALLS_BEFORE_QUERY_TIMEOUT_CHECK = 8191;
        private PointValues.IntersectVisitor in;
        private final QueryCancellation queryCancellation;
        private int calls;

        private ExitableIntersectVisitor(QueryCancellation queryCancellation) {
            this.queryCancellation = queryCancellation;
        }

        private void checkAndThrowWithSampling() {
            if ((this.calls++ & 0x1FFF) == 0) {
                this.queryCancellation.checkCancelled();
            }
        }

        private void setVisitor(PointValues.IntersectVisitor in) {
            this.in = in;
        }

        @Override
        public void visit(int docID) throws IOException {
            this.checkAndThrowWithSampling();
            this.in.visit(docID);
        }

        @Override
        public void visit(int docID, byte[] packedValue) throws IOException {
            this.checkAndThrowWithSampling();
            this.in.visit(docID, packedValue);
        }

        @Override
        public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
            this.queryCancellation.checkCancelled();
            return this.in.compare(minPackedValue, maxPackedValue);
        }

        @Override
        public void grow(int count) {
            this.queryCancellation.checkCancelled();
            this.in.grow(count);
        }
    }

    static class ExitablePointValues
    extends PointValues {
        private final PointValues in;
        private final QueryCancellation queryCancellation;

        private ExitablePointValues(PointValues in, QueryCancellation queryCancellation) {
            this.in = in;
            this.queryCancellation = queryCancellation;
            this.queryCancellation.checkCancelled();
        }

        @Override
        public PointValues.PointTree getPointTree() throws IOException {
            return new ExitablePointTree(this.in, this.in.getPointTree(), this.queryCancellation);
        }

        @Override
        public byte[] getMinPackedValue() throws IOException {
            this.queryCancellation.checkCancelled();
            return this.in.getMinPackedValue();
        }

        @Override
        public byte[] getMaxPackedValue() throws IOException {
            this.queryCancellation.checkCancelled();
            return this.in.getMaxPackedValue();
        }

        @Override
        public int getNumDimensions() throws IOException {
            this.queryCancellation.checkCancelled();
            return this.in.getNumDimensions();
        }

        @Override
        public int getNumIndexDimensions() throws IOException {
            this.queryCancellation.checkCancelled();
            return this.in.getNumIndexDimensions();
        }

        @Override
        public int getBytesPerDimension() throws IOException {
            this.queryCancellation.checkCancelled();
            return this.in.getBytesPerDimension();
        }

        @Override
        public long size() {
            this.queryCancellation.checkCancelled();
            return this.in.size();
        }

        @Override
        public int getDocCount() {
            this.queryCancellation.checkCancelled();
            return this.in.getDocCount();
        }
    }

    private static class ExitablePointTree
    implements PointValues.PointTree {
        private final PointValues values;
        private final PointValues.PointTree pointTree;
        private final ExitableIntersectVisitor exitableIntersectVisitor;
        private final QueryCancellation queryCancellation;
        private int calls;

        private ExitablePointTree(PointValues values, PointValues.PointTree pointTree, QueryCancellation queryCancellation) {
            this.values = values;
            this.pointTree = pointTree;
            this.exitableIntersectVisitor = new ExitableIntersectVisitor(queryCancellation);
            this.queryCancellation = queryCancellation;
        }

        @Override
        public PointValues.PointTree clone() {
            this.queryCancellation.checkCancelled();
            return new ExitablePointTree(this.values, this.pointTree.clone(), this.queryCancellation);
        }

        @Override
        public boolean moveToChild() throws IOException {
            this.checkAndThrowWithSampling();
            return this.pointTree.moveToChild();
        }

        @Override
        public boolean moveToSibling() throws IOException {
            this.checkAndThrowWithSampling();
            return this.pointTree.moveToSibling();
        }

        @Override
        public boolean moveToParent() throws IOException {
            this.checkAndThrowWithSampling();
            return this.pointTree.moveToParent();
        }

        @Override
        public byte[] getMinPackedValue() {
            this.checkAndThrowWithSampling();
            return this.pointTree.getMinPackedValue();
        }

        @Override
        public byte[] getMaxPackedValue() {
            this.checkAndThrowWithSampling();
            return this.pointTree.getMaxPackedValue();
        }

        @Override
        public long size() {
            this.queryCancellation.checkCancelled();
            return this.pointTree.size();
        }

        @Override
        public void visitDocIDs(PointValues.IntersectVisitor visitor) throws IOException {
            this.queryCancellation.checkCancelled();
            this.pointTree.visitDocIDs(visitor);
        }

        @Override
        public void visitDocValues(PointValues.IntersectVisitor visitor) throws IOException {
            this.queryCancellation.checkCancelled();
            this.exitableIntersectVisitor.setVisitor(visitor);
            this.pointTree.visitDocValues(this.exitableIntersectVisitor);
        }

        private void checkAndThrowWithSampling() {
            if ((this.calls++ & 0x1FFF) == 0) {
                this.queryCancellation.checkCancelled();
            }
        }
    }

    private static class ExitableTermsEnum
    extends FilterLeafReader.FilterTermsEnum {
        private static final int MAX_CALLS_BEFORE_QUERY_TIMEOUT_CHECK = 15;
        private int calls;
        private final QueryCancellation queryCancellation;

        private ExitableTermsEnum(TermsEnum termsEnum, QueryCancellation queryCancellation) {
            super(termsEnum);
            this.queryCancellation = queryCancellation;
            this.queryCancellation.checkCancelled();
        }

        private void checkAndThrowWithSampling() {
            if ((this.calls++ & 0xF) == 0) {
                this.queryCancellation.checkCancelled();
            }
        }

        @Override
        public BytesRef next() throws IOException {
            this.checkAndThrowWithSampling();
            return this.in.next();
        }
    }

    static class ExitableTerms
    extends FilterLeafReader.FilterTerms {
        private final QueryCancellation queryCancellation;

        private ExitableTerms(Terms terms, QueryCancellation queryCancellation) {
            super(terms);
            this.queryCancellation = queryCancellation;
        }

        @Override
        public TermsEnum intersect(CompiledAutomaton compiled, BytesRef startTerm) throws IOException {
            return new ExitableTermsEnum(this.in.intersect(compiled, startTerm), this.queryCancellation);
        }

        @Override
        public TermsEnum iterator() throws IOException {
            return new ExitableTermsEnum(this.in.iterator(), this.queryCancellation);
        }
    }

    static class ExitableLeafReader
    extends SequentialStoredFieldsLeafReader {
        private final QueryCancellation queryCancellation;

        private ExitableLeafReader(LeafReader leafReader, QueryCancellation queryCancellation) {
            super(leafReader);
            this.queryCancellation = queryCancellation;
        }

        @Override
        public PointValues getPointValues(String field) throws IOException {
            PointValues pointValues = this.in.getPointValues(field);
            if (pointValues == null) {
                return null;
            }
            return this.queryCancellation.isEnabled() ? new ExitablePointValues(pointValues, this.queryCancellation) : pointValues;
        }

        @Override
        public Terms terms(String field) throws IOException {
            Terms terms = this.in.terms(field);
            if (terms == null) {
                return null;
            }
            return this.queryCancellation.isEnabled() && !(terms instanceof CompletionTerms) ? new ExitableTerms(terms, this.queryCancellation) : terms;
        }

        @Override
        public IndexReader.CacheHelper getCoreCacheHelper() {
            return this.in.getCoreCacheHelper();
        }

        @Override
        public IndexReader.CacheHelper getReaderCacheHelper() {
            return this.in.getReaderCacheHelper();
        }

        @Override
        protected StoredFieldsReader doGetSequentialStoredFieldsReader(StoredFieldsReader reader) {
            return reader;
        }
    }
}

