/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.internal;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchResponseSections;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentFragment;
import org.graylog.shaded.opensearch2.org.opensearch.search.SearchExtBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.SearchHits;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.InternalAggregations;
import org.graylog.shaded.opensearch2.org.opensearch.search.pipeline.ProcessorExecutionDetail;
import org.graylog.shaded.opensearch2.org.opensearch.search.profile.SearchProfileShardResults;
import org.graylog.shaded.opensearch2.org.opensearch.search.suggest.Suggest;

@PublicApi(since="1.0.0")
public class InternalSearchResponse
extends SearchResponseSections
implements Writeable,
ToXContentFragment {
    public static InternalSearchResponse empty() {
        return InternalSearchResponse.empty(true);
    }

    public static InternalSearchResponse empty(boolean withTotalHits) {
        return new InternalSearchResponse(SearchHits.empty(withTotalHits), null, null, null, false, null, 1);
    }

    public InternalSearchResponse(SearchHits hits, InternalAggregations aggregations, Suggest suggest, SearchProfileShardResults profileResults, boolean timedOut, Boolean terminatedEarly, int numReducePhases) {
        this(hits, aggregations, suggest, profileResults, timedOut, terminatedEarly, numReducePhases, Collections.emptyList(), Collections.emptyList());
    }

    public InternalSearchResponse(SearchHits hits, InternalAggregations aggregations, Suggest suggest, SearchProfileShardResults profileResults, boolean timedOut, Boolean terminatedEarly, int numReducePhases, List<SearchExtBuilder> searchExtBuilderList, List<ProcessorExecutionDetail> processorResult) {
        super(hits, aggregations, suggest, timedOut, terminatedEarly, profileResults, numReducePhases, searchExtBuilderList, processorResult);
    }

    public InternalSearchResponse(SearchHits hits, InternalAggregations aggregations, Suggest suggest, SearchProfileShardResults profileResults, boolean timedOut, Boolean terminatedEarly, int numReducePhases, List<SearchExtBuilder> searchExtBuilderList) {
        this(hits, aggregations, suggest, profileResults, timedOut, terminatedEarly, numReducePhases, searchExtBuilderList, Collections.emptyList());
    }

    public InternalSearchResponse(StreamInput in) throws IOException {
        super(new SearchHits(in), in.readBoolean() ? InternalAggregations.readFrom(in) : null, in.readBoolean() ? new Suggest(in) : null, in.readBoolean(), in.readOptionalBoolean(), in.readOptionalWriteable(SearchProfileShardResults::new), in.readVInt(), InternalSearchResponse.readSearchExtBuildersOnOrAfter(in), InternalSearchResponse.readProcessorResultOnOrAfter(in));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.hits.writeTo(out);
        out.writeOptionalWriteable((InternalAggregations)this.aggregations);
        out.writeOptionalWriteable(this.suggest);
        out.writeBoolean(this.timedOut);
        out.writeOptionalBoolean(this.terminatedEarly);
        out.writeOptionalWriteable(this.profileResults);
        out.writeVInt(this.numReducePhases);
        InternalSearchResponse.writeSearchExtBuildersOnOrAfter(out, this.searchExtBuilders);
        InternalSearchResponse.writeProcessorResultOnOrAfter(out, this.processorResult);
    }

    private static List<SearchExtBuilder> readSearchExtBuildersOnOrAfter(StreamInput in) throws IOException {
        return in.getVersion().onOrAfter(Version.V_2_10_0) ? in.readNamedWriteableList(SearchExtBuilder.class) : Collections.emptyList();
    }

    private static void writeSearchExtBuildersOnOrAfter(StreamOutput out, List<SearchExtBuilder> searchExtBuilders) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_2_10_0)) {
            out.writeNamedWriteableList(searchExtBuilders);
        }
    }

    private static List<ProcessorExecutionDetail> readProcessorResultOnOrAfter(StreamInput in) throws IOException {
        return in.getVersion().onOrAfter(Version.V_2_19_0) ? in.readList(ProcessorExecutionDetail::new) : Collections.emptyList();
    }

    private static void writeProcessorResultOnOrAfter(StreamOutput out, List<ProcessorExecutionDetail> processorResult) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_2_19_0)) {
            out.writeList(processorResult);
        }
    }
}

