/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.lookup;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.opensearch.ExceptionsHelper;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.IndexFieldData;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.ScriptDocValues;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MappedFieldType;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MapperService;

@PublicApi(since="1.0.0")
public class LeafDocLookup
implements Map<String, ScriptDocValues<?>> {
    private final Map<String, ScriptDocValues<?>> localCacheFieldData = new HashMap(4);
    private final MapperService mapperService;
    private final Function<MappedFieldType, IndexFieldData<?>> fieldDataLookup;
    private final LeafReaderContext reader;
    private int docId = -1;

    LeafDocLookup(MapperService mapperService, Function<MappedFieldType, IndexFieldData<?>> fieldDataLookup, LeafReaderContext reader) {
        this.mapperService = mapperService;
        this.fieldDataLookup = fieldDataLookup;
        this.reader = reader;
    }

    public MapperService mapperService() {
        return this.mapperService;
    }

    public void setDocument(int docId) {
        this.docId = docId;
    }

    @Override
    public ScriptDocValues<?> get(Object key) {
        String fieldName = key.toString();
        ScriptDocValues scriptValues = this.localCacheFieldData.get(fieldName);
        if (scriptValues == null) {
            final MappedFieldType fieldType = this.mapperService.fieldType(fieldName);
            if (fieldType == null) {
                throw new IllegalArgumentException("No field found for [" + fieldName + "] in mapping");
            }
            scriptValues = (ScriptDocValues)AccessController.doPrivileged(new PrivilegedAction<ScriptDocValues<?>>(){

                @Override
                public ScriptDocValues<?> run() {
                    return LeafDocLookup.this.fieldDataLookup.apply(fieldType).load(LeafDocLookup.this.reader).getScriptValues();
                }
            });
            this.localCacheFieldData.put(fieldName, scriptValues);
        }
        try {
            scriptValues.setNextDocId(this.docId);
        }
        catch (IOException e) {
            throw ExceptionsHelper.convertToOpenSearchException(e);
        }
        return scriptValues;
    }

    @Override
    public boolean containsKey(Object key) {
        MappedFieldType fieldType;
        String fieldName = key.toString();
        ScriptDocValues<?> scriptValues = this.localCacheFieldData.get(fieldName);
        return scriptValues != null || (fieldType = this.mapperService.fieldType(fieldName)) != null;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ScriptDocValues<?> put(String key, ScriptDocValues<?> value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ScriptDocValues<?> remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends ScriptDocValues<?>> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<ScriptDocValues<?>> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<String, ScriptDocValues<?>>> entrySet() {
        throw new UnsupportedOperationException();
    }
}

