/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.pipeline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.graylog.shaded.opensearch2.org.opensearch.common.metrics.OperationMetrics;
import org.graylog.shaded.opensearch2.org.opensearch.common.metrics.OperationStats;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentFragment;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;

public class SearchPipelineStats
implements Writeable,
ToXContentFragment {
    private final OperationStats totalRequestStats;
    private final OperationStats totalResponseStats;
    private final List<PerPipelineStats> perPipelineStats;
    private final Map<String, PipelineDetailStats> perPipelineProcessorStats;

    public SearchPipelineStats(OperationStats totalRequestStats, OperationStats totalResponseStats, List<PerPipelineStats> perPipelineStats, Map<String, PipelineDetailStats> perPipelineProcessorStats) {
        this.totalRequestStats = totalRequestStats;
        this.totalResponseStats = totalResponseStats;
        this.perPipelineStats = perPipelineStats;
        this.perPipelineProcessorStats = perPipelineProcessorStats;
    }

    public SearchPipelineStats(StreamInput in) throws IOException {
        this.totalRequestStats = new OperationStats(in);
        this.totalResponseStats = new OperationStats(in);
        int size = in.readVInt();
        ArrayList<PerPipelineStats> perPipelineStats = new ArrayList<PerPipelineStats>(size);
        TreeMap<String, PipelineDetailStats> pipelineDetailStatsMap = new TreeMap<String, PipelineDetailStats>();
        for (int i = 0; i < size; ++i) {
            String pipelineId = in.readString();
            OperationStats pipelineRequestStats = new OperationStats(in);
            OperationStats pipelineResponseStats = new OperationStats(in);
            perPipelineStats.add(new PerPipelineStats(pipelineId, pipelineRequestStats, pipelineResponseStats));
            int numRequestProcessors = in.readVInt();
            ArrayList<ProcessorStats> requestProcessorStats = new ArrayList<ProcessorStats>(numRequestProcessors);
            for (int j = 0; j < numRequestProcessors; ++j) {
                String processorName = in.readString();
                String processorType = in.readString();
                OperationStats processorStats = new OperationStats(in);
                requestProcessorStats.add(new ProcessorStats(processorName, processorType, processorStats));
            }
            int numResponseProcessors = in.readVInt();
            ArrayList<ProcessorStats> responseProcessorStats = new ArrayList<ProcessorStats>(numResponseProcessors);
            for (int j = 0; j < numResponseProcessors; ++j) {
                String processorName = in.readString();
                String processorType = in.readString();
                OperationStats processorStats = new OperationStats(in);
                responseProcessorStats.add(new ProcessorStats(processorName, processorType, processorStats));
            }
            pipelineDetailStatsMap.put(pipelineId, new PipelineDetailStats(Collections.unmodifiableList(requestProcessorStats), Collections.unmodifiableList(responseProcessorStats)));
        }
        this.perPipelineStats = Collections.unmodifiableList(perPipelineStats);
        this.perPipelineProcessorStats = Collections.unmodifiableMap(pipelineDetailStatsMap);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("search_pipeline");
        builder.startObject("total_request");
        this.totalRequestStats.toXContent(builder, params);
        builder.endObject();
        builder.startObject("total_response");
        this.totalResponseStats.toXContent(builder, params);
        builder.endObject();
        builder.startObject("pipelines");
        for (PerPipelineStats pipelineStat : this.perPipelineStats) {
            builder.startObject(pipelineStat.pipelineId);
            builder.startObject("request");
            pipelineStat.requestStats.toXContent(builder, params);
            builder.endObject();
            builder.startObject("response");
            pipelineStat.responseStats.toXContent(builder, params);
            builder.endObject();
            PipelineDetailStats pipelineDetailStats = this.perPipelineProcessorStats.get(pipelineStat.pipelineId);
            builder.startArray("request_processors");
            for (ProcessorStats processorStats : pipelineDetailStats.requestProcessorStats) {
                builder.startObject();
                processorStats.toXContent(builder, params);
                builder.endObject();
            }
            builder.endArray();
            builder.startArray("response_processors");
            for (ProcessorStats processorStats : pipelineDetailStats.responseProcessorStats) {
                builder.startObject();
                processorStats.toXContent(builder, params);
                builder.endObject();
            }
            builder.endArray();
            builder.endObject();
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.totalRequestStats.writeTo(out);
        this.totalResponseStats.writeTo(out);
        out.writeVInt(this.perPipelineStats.size());
        for (PerPipelineStats pipelineStat : this.perPipelineStats) {
            out.writeString(pipelineStat.pipelineId);
            pipelineStat.requestStats.writeTo(out);
            pipelineStat.responseStats.writeTo(out);
            PipelineDetailStats pipelineDetailStats = this.perPipelineProcessorStats.get(pipelineStat.pipelineId);
            out.writeVInt(pipelineDetailStats.requestProcessorStats.size());
            for (ProcessorStats processorStats : pipelineDetailStats.requestProcessorStats) {
                out.writeString(processorStats.processorName);
                out.writeString(processorStats.processorType);
                processorStats.stats.writeTo(out);
            }
            out.writeVInt(pipelineDetailStats.responseProcessorStats.size());
            for (ProcessorStats processorStats : pipelineDetailStats.responseProcessorStats) {
                out.writeString(processorStats.processorName);
                out.writeString(processorStats.processorType);
                processorStats.stats.writeTo(out);
            }
        }
    }

    OperationStats getTotalRequestStats() {
        return this.totalRequestStats;
    }

    OperationStats getTotalResponseStats() {
        return this.totalResponseStats;
    }

    List<PerPipelineStats> getPipelineStats() {
        return this.perPipelineStats;
    }

    Map<String, PipelineDetailStats> getPerPipelineProcessorStats() {
        return this.perPipelineProcessorStats;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchPipelineStats stats = (SearchPipelineStats)o;
        return this.totalRequestStats.equals(stats.totalRequestStats) && this.totalResponseStats.equals(stats.totalResponseStats) && this.perPipelineStats.equals(stats.perPipelineStats) && this.perPipelineProcessorStats.equals(stats.perPipelineProcessorStats);
    }

    public int hashCode() {
        return Objects.hash(this.totalRequestStats, this.totalResponseStats, this.perPipelineStats, this.perPipelineProcessorStats);
    }

    static class PerPipelineStats {
        private final String pipelineId;
        private final OperationStats requestStats;
        private final OperationStats responseStats;

        public PerPipelineStats(String pipelineId, OperationStats requestStats, OperationStats responseStats) {
            this.pipelineId = pipelineId;
            this.requestStats = requestStats;
            this.responseStats = responseStats;
        }

        public String getPipelineId() {
            return this.pipelineId;
        }

        public OperationStats getRequestStats() {
            return this.requestStats;
        }

        public OperationStats getResponseStats() {
            return this.responseStats;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PerPipelineStats that = (PerPipelineStats)o;
            return this.pipelineId.equals(that.pipelineId) && this.requestStats.equals(that.requestStats) && this.responseStats.equals(that.responseStats);
        }

        public int hashCode() {
            return Objects.hash(this.pipelineId, this.requestStats, this.responseStats);
        }
    }

    static class ProcessorStats
    implements ToXContentFragment {
        private final String processorName;
        private final String processorType;
        private final OperationStats stats;

        public ProcessorStats(String processorName, String processorType, OperationStats stats) {
            this.processorName = processorName;
            this.processorType = processorType;
            this.stats = stats;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProcessorStats that = (ProcessorStats)o;
            return this.processorName.equals(that.processorName) && this.processorType.equals(that.processorType) && this.stats.equals(that.stats);
        }

        public int hashCode() {
            return Objects.hash(this.processorName, this.processorType, this.stats);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(this.processorName);
            builder.field("type", this.processorType);
            builder.startObject("stats");
            this.stats.toXContent(builder, params);
            builder.endObject();
            builder.endObject();
            return builder;
        }

        String getProcessorName() {
            return this.processorName;
        }

        String getProcessorType() {
            return this.processorType;
        }

        OperationStats getStats() {
            return this.stats;
        }
    }

    static class PipelineDetailStats {
        private final List<ProcessorStats> requestProcessorStats;
        private final List<ProcessorStats> responseProcessorStats;

        public PipelineDetailStats(List<ProcessorStats> requestProcessorStats, List<ProcessorStats> responseProcessorStats) {
            this.requestProcessorStats = requestProcessorStats;
            this.responseProcessorStats = responseProcessorStats;
        }

        public List<ProcessorStats> requestProcessorStats() {
            return this.requestProcessorStats;
        }

        public List<ProcessorStats> responseProcessorStats() {
            return this.responseProcessorStats;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PipelineDetailStats that = (PipelineDetailStats)o;
            return this.requestProcessorStats.equals(that.requestProcessorStats) && this.responseProcessorStats.equals(that.responseProcessorStats);
        }

        public int hashCode() {
            return Objects.hash(this.requestProcessorStats, this.responseProcessorStats);
        }
    }

    static class Builder {
        private OperationStats totalRequestStats;
        private OperationStats totalResponseStats;
        private final List<PerPipelineStats> perPipelineStats = new ArrayList<PerPipelineStats>();
        private final Map<String, List<ProcessorStats>> requestProcessorStatsPerPipeline = new HashMap<String, List<ProcessorStats>>();
        private final Map<String, List<ProcessorStats>> responseProcessorStatsPerPipeline = new HashMap<String, List<ProcessorStats>>();

        Builder() {
        }

        Builder withTotalStats(OperationMetrics totalRequestMetrics, OperationMetrics totalResponseMetrics) {
            this.totalRequestStats = totalRequestMetrics.createStats();
            this.totalResponseStats = totalResponseMetrics.createStats();
            return this;
        }

        Builder addPipelineStats(String pipelineId, OperationMetrics pipelineRequestMetrics, OperationMetrics pipelineResponseMetrics) {
            this.perPipelineStats.add(new PerPipelineStats(pipelineId, pipelineRequestMetrics.createStats(), pipelineResponseMetrics.createStats()));
            return this;
        }

        Builder addRequestProcessorStats(String pipelineId, String processorName, String processorType, OperationMetrics processorMetrics) {
            this.requestProcessorStatsPerPipeline.computeIfAbsent(pipelineId, k -> new ArrayList()).add(new ProcessorStats(processorName, processorType, processorMetrics.createStats()));
            return this;
        }

        Builder addResponseProcessorStats(String pipelineId, String processorName, String processorType, OperationMetrics processorMetrics) {
            this.responseProcessorStatsPerPipeline.computeIfAbsent(pipelineId, k -> new ArrayList()).add(new ProcessorStats(processorName, processorType, processorMetrics.createStats()));
            return this;
        }

        SearchPipelineStats build() {
            TreeMap<String, PipelineDetailStats> pipelineDetailStatsMap = new TreeMap<String, PipelineDetailStats>();
            for (PerPipelineStats pipelineStat : this.perPipelineStats) {
                List requestProcessorStats = this.requestProcessorStatsPerPipeline.getOrDefault(pipelineStat.pipelineId, Collections.emptyList());
                List responseProcessorStats = this.responseProcessorStatsPerPipeline.getOrDefault(pipelineStat.pipelineId, Collections.emptyList());
                PipelineDetailStats pipelineDetailStats = new PipelineDetailStats(Collections.unmodifiableList(requestProcessorStats), Collections.unmodifiableList(responseProcessorStats));
                pipelineDetailStatsMap.put(pipelineStat.pipelineId, pipelineDetailStats);
            }
            return new SearchPipelineStats(this.totalRequestStats, this.totalResponseStats, Collections.unmodifiableList(this.perPipelineStats), Collections.unmodifiableMap(pipelineDetailStatsMap));
        }
    }
}

