/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Collector;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.CollectorManager;
import org.graylog.shaded.opensearch2.org.opensearch.search.query.EarlyTerminatingCollector;
import org.graylog.shaded.opensearch2.org.opensearch.search.query.EarlyTerminatingListener;
import org.graylog.shaded.opensearch2.org.opensearch.search.query.QuerySearchResult;
import org.graylog.shaded.opensearch2.org.opensearch.search.query.ReduceableSearchResult;

public class EarlyTerminatingCollectorManager<C extends Collector>
implements CollectorManager<EarlyTerminatingCollector, ReduceableSearchResult>,
EarlyTerminatingListener {
    private final CollectorManager<C, ReduceableSearchResult> manager;
    private final int maxCountHits;
    private boolean forceTermination;

    EarlyTerminatingCollectorManager(CollectorManager<C, ReduceableSearchResult> manager, int maxCountHits, boolean forceTermination) {
        this.manager = manager;
        this.maxCountHits = maxCountHits;
        this.forceTermination = forceTermination;
    }

    @Override
    public EarlyTerminatingCollector newCollector() throws IOException {
        return new EarlyTerminatingCollector((Collector)this.manager.newCollector(), this.maxCountHits, false);
    }

    @Override
    public ReduceableSearchResult reduce(Collection<EarlyTerminatingCollector> collectors) throws IOException {
        ArrayList<Collector> innerCollectors = new ArrayList<Collector>(collectors.size());
        boolean didTerminateEarly = false;
        for (EarlyTerminatingCollector collector : collectors) {
            innerCollectors.add(collector.getCollector());
            if (!collector.hasEarlyTerminated()) continue;
            didTerminateEarly = true;
        }
        if (didTerminateEarly) {
            this.onEarlyTermination(this.maxCountHits, this.forceTermination);
            final ReduceableSearchResult result = this.manager.reduce(innerCollectors);
            return new ReduceableSearchResult(){

                @Override
                public void reduce(QuerySearchResult r) throws IOException {
                    result.reduce(r);
                    r.terminatedEarly(true);
                }
            };
        }
        return this.manager.reduce(innerCollectors);
    }

    @Override
    public void onEarlyTermination(int maxCountHits, boolean forcedTermination) {
        if (this.manager instanceof EarlyTerminatingListener) {
            ((EarlyTerminatingListener)((Object)this.manager)).onEarlyTermination(maxCountHits, forcedTermination);
        }
    }
}

