/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.query;

import java.io.IOException;
import java.util.Collection;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.CollectorManager;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.LeafCollector;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Scorable;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ScoreMode;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Sort;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TopDocs;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TopFieldDocs;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TotalHitCountCollector;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TotalHits;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.Lucene;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.search.TopDocsAndMaxScore;
import org.graylog.shaded.opensearch2.org.opensearch.search.query.EarlyTerminatingListener;
import org.graylog.shaded.opensearch2.org.opensearch.search.query.ReduceableSearchResult;

public class TotalHitCountCollectorManager
implements CollectorManager<TotalHitCountCollector, ReduceableSearchResult>,
EarlyTerminatingListener {
    private static final TotalHitCountCollector EMPTY_COLLECTOR = new TotalHitCountCollector(){

        @Override
        public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
            return new LeafCollector(){

                @Override
                public void setScorer(Scorable scorer) throws IOException {
                }

                @Override
                public void collect(int doc) throws IOException {
                }
            };
        }

        @Override
        public ScoreMode scoreMode() {
            return ScoreMode.COMPLETE_NO_SCORES;
        }
    };
    private final Sort sort;
    private Integer terminatedAfter;

    public TotalHitCountCollectorManager(Sort sort) {
        this.sort = sort;
    }

    @Override
    public void onEarlyTermination(int maxCountHits, boolean forcedTermination) {
        this.terminatedAfter = maxCountHits;
    }

    @Override
    public TotalHitCountCollector newCollector() throws IOException {
        return new TotalHitCountCollector();
    }

    @Override
    public ReduceableSearchResult reduce(Collection<TotalHitCountCollector> collectors) throws IOException {
        return result -> {
            TotalHits.Relation relation = this.terminatedAfter != null ? TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO : TotalHits.Relation.EQUAL_TO;
            int totalHits = collectors.stream().mapToInt(TotalHitCountCollector::getTotalHits).sum();
            if (this.terminatedAfter != null && totalHits > this.terminatedAfter) {
                totalHits = this.terminatedAfter;
            }
            TotalHits totalHitCount = new TotalHits(totalHits, relation);
            TopDocs topDocs = this.sort != null ? new TopFieldDocs(totalHitCount, Lucene.EMPTY_SCORE_DOCS, this.sort.getSort()) : new TopDocs(totalHitCount, Lucene.EMPTY_SCORE_DOCS);
            result.topDocs(new TopDocsAndMaxScore(topDocs, Float.NaN), null);
        };
    }

    static class Empty
    implements CollectorManager<TotalHitCountCollector, ReduceableSearchResult> {
        private final TotalHits totalHits;
        private final Sort sort;

        Empty(TotalHits totalHits, Sort sort) {
            this.totalHits = totalHits;
            this.sort = sort;
        }

        @Override
        public TotalHitCountCollector newCollector() throws IOException {
            return EMPTY_COLLECTOR;
        }

        @Override
        public ReduceableSearchResult reduce(Collection<TotalHitCountCollector> collectors) throws IOException {
            return result -> {
                TopDocs topDocs = this.sort != null ? new TopFieldDocs(this.totalHits, Lucene.EMPTY_SCORE_DOCS, this.sort.getSort()) : new TopDocs(this.totalHits, Lucene.EMPTY_SCORE_DOCS);
                result.topDocs(new TopDocsAndMaxScore(topDocs, Float.NaN), null);
            };
        }
    }
}

