/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.slice;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.DocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SortedNumericDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ConstantScoreScorer;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ConstantScoreWeight;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.DocIdSetIterator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.IndexSearcher;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ScoreMode;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Scorer;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TwoPhaseIterator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Weight;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.BitMixer;
import org.graylog.shaded.opensearch2.org.opensearch.search.slice.SliceQuery;

public final class DocValuesSliceQuery
extends SliceQuery {
    public DocValuesSliceQuery(String field, int id, int max) {
        super(field, id, max);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                final SortedNumericDocValues values = DocValues.getSortedNumeric(context.reader(), DocValuesSliceQuery.this.getField());
                DocIdSetIterator approximation = DocIdSetIterator.all(context.reader().maxDoc());
                TwoPhaseIterator twoPhase = new TwoPhaseIterator(approximation){

                    @Override
                    public boolean matches() throws IOException {
                        if (values.advanceExact(this.approximation.docID())) {
                            for (int i = 0; i < values.docValueCount(); ++i) {
                                if (!DocValuesSliceQuery.this.contains(BitMixer.mix(values.nextValue()))) continue;
                                return true;
                            }
                            return false;
                        }
                        return DocValuesSliceQuery.this.contains(0L);
                    }

                    @Override
                    public float matchCost() {
                        return 10.0f;
                    }
                };
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, twoPhase);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return DocValues.isCacheable(ctx, DocValuesSliceQuery.this.getField());
            }
        };
    }
}

