/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.startree;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.FixedBitSet;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.ExperimentalApi;
import org.graylog.shaded.opensearch2.org.opensearch.index.codec.composite.CompositeIndexFieldInfo;
import org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube.DateDimension;
import org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube.Dimension;
import org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube.Metric;
import org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube.MetricStat;
import org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube.startree.utils.date.DateTimeUnitAdapter;
import org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube.startree.utils.date.DateTimeUnitRounding;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.CompositeDataCubeFieldType;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.AggregatorFactory;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.histogram.DateHistogramAggregatorFactory;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.MetricAggregatorFactory;
import org.graylog.shaded.opensearch2.org.opensearch.search.internal.SearchContext;
import org.graylog.shaded.opensearch2.org.opensearch.search.startree.filter.StarTreeFilter;
import org.graylog.shaded.opensearch2.org.opensearch.search.startree.filter.provider.StarTreeFilterProvider;

@ExperimentalApi
public class StarTreeQueryContext {
    private final CompositeDataCubeFieldType compositeMappedFieldType;
    private final FixedBitSet[] perSegmentNodeIdsCache;
    private final QueryBuilder baseQueryBuilder;
    private StarTreeFilter baseStarTreeFilter;

    public StarTreeQueryContext(SearchContext context, QueryBuilder baseQueryBuilder) {
        this.baseQueryBuilder = baseQueryBuilder;
        this.compositeMappedFieldType = (CompositeDataCubeFieldType)context.mapperService().getCompositeFieldTypes().iterator().next();
        boolean cacheStarTreeValues = context.aggregations().factories().getFactories().length > 1;
        int cacheSize = cacheStarTreeValues ? context.indexShard().segments(false).size() : -1;
        this.perSegmentNodeIdsCache = cacheSize > -1 ? new FixedBitSet[cacheSize] : null;
    }

    public StarTreeQueryContext(CompositeDataCubeFieldType compositeMappedFieldType, QueryBuilder baseQueryBuilder, int cacheSize) {
        this.compositeMappedFieldType = compositeMappedFieldType;
        this.baseQueryBuilder = baseQueryBuilder;
        this.perSegmentNodeIdsCache = cacheSize > -1 ? new FixedBitSet[cacheSize] : null;
    }

    public CompositeIndexFieldInfo getStarTree() {
        return new CompositeIndexFieldInfo(this.compositeMappedFieldType.name(), this.compositeMappedFieldType.getCompositeIndexType());
    }

    public FixedBitSet maybeGetCachedNodeIdsForSegment(int ordinal) {
        return this.perSegmentNodeIdsCache != null ? this.perSegmentNodeIdsCache[ordinal] : null;
    }

    public FixedBitSet[] getAllCachedValues() {
        return this.perSegmentNodeIdsCache;
    }

    public void maybeSetCachedNodeIdsForSegment(int key, FixedBitSet values) {
        if (this.perSegmentNodeIdsCache != null) {
            this.perSegmentNodeIdsCache[key] = values;
        }
    }

    public boolean consolidateAllFilters(SearchContext context) {
        for (AggregatorFactory aggregatorFactory : context.aggregations().factories().getFactories()) {
            if (StarTreeQueryContext.validateStarTreeMetricSupport(this.compositeMappedFieldType, aggregatorFactory) || StarTreeQueryContext.validateDateHistogramSupport(this.compositeMappedFieldType, aggregatorFactory)) continue;
            return false;
        }
        if (this.baseQueryBuilder != null) {
            this.baseStarTreeFilter = this.getStarTreeFilter(context, this.baseQueryBuilder, this.compositeMappedFieldType);
            return this.baseStarTreeFilter != null;
        }
        return true;
    }

    public StarTreeFilter getBaseQueryStarTreeFilter() {
        if (this.baseStarTreeFilter == null) {
            return new StarTreeFilter(Collections.emptyMap());
        }
        return this.baseStarTreeFilter;
    }

    private static boolean validateStarTreeMetricSupport(CompositeDataCubeFieldType compositeIndexFieldInfo, AggregatorFactory aggregatorFactory) {
        if (aggregatorFactory instanceof MetricAggregatorFactory && aggregatorFactory.getSubFactories().getFactories().length == 0) {
            Map<String, List> supportedMetrics = compositeIndexFieldInfo.getMetrics().stream().collect(Collectors.toMap(Metric::getField, Metric::getMetrics));
            MetricStat metricStat = ((MetricAggregatorFactory)aggregatorFactory).getMetricStat();
            String field = ((MetricAggregatorFactory)aggregatorFactory).getField();
            return field != null && supportedMetrics.containsKey(field) && supportedMetrics.get(field).contains((Object)metricStat);
        }
        return false;
    }

    private StarTreeFilter getStarTreeFilter(SearchContext context, QueryBuilder queryBuilder, CompositeDataCubeFieldType compositeMappedFieldType) {
        StarTreeFilterProvider starTreeFilterProvider = StarTreeFilterProvider.SingletonFactory.getProvider(queryBuilder);
        if (starTreeFilterProvider == null) {
            return null;
        }
        try {
            return starTreeFilterProvider.getFilter(context, queryBuilder, compositeMappedFieldType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean validateDateHistogramSupport(CompositeDataCubeFieldType compositeIndexFieldInfo, AggregatorFactory aggregatorFactory) {
        if (!(aggregatorFactory instanceof DateHistogramAggregatorFactory) || aggregatorFactory.getSubFactories().getFactories().length < 1) {
            return false;
        }
        DateHistogramAggregatorFactory dateHistogramAggregatorFactory = (DateHistogramAggregatorFactory)aggregatorFactory;
        DateDimension starTreeDateDimension = null;
        for (Dimension dimension : compositeIndexFieldInfo.getDimensions()) {
            if (!(dimension instanceof DateDimension)) continue;
            starTreeDateDimension = (DateDimension)dimension;
            break;
        }
        if (starTreeDateDimension == null) {
            return false;
        }
        if (dateHistogramAggregatorFactory.getRounding() == null) {
            return false;
        }
        DateTimeUnitRounding rounding = starTreeDateDimension.findClosestValidInterval(new DateTimeUnitAdapter(dateHistogramAggregatorFactory.getRounding()));
        if (rounding == null) {
            return false;
        }
        for (AggregatorFactory subFactory : aggregatorFactory.getSubFactories().getFactories()) {
            if (StarTreeQueryContext.validateStarTreeMetricSupport(compositeIndexFieldInfo, subFactory)) continue;
            return false;
        }
        return true;
    }
}

