/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.snapshots;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.opensearch2.org.opensearch.LegacyESVersion;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.action.StepListener;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.IndicesOptions;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterChangedEvent;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterInfo;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterStateApplier;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterStateTaskConfig;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterStateTaskExecutor;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterStateTaskListener;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterStateUpdateTask;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.RestoreInProgress;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.SnapshotDeletionsInProgress;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.block.ClusterBlocks;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.AliasMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.DataStream;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexTemplateMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.Metadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.MetadataCreateIndexService;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.MetadataIndexStateService;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.MetadataIndexUpgradeService;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.RecoverySource;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.RoutingChangesObserver;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.RoutingTable;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.ShardRouting;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.ShardsIterator;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.UnassignedInfo;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.AllocationService;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterManagerTaskThrottler;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.Priority;
import org.graylog.shaded.opensearch2.org.opensearch.common.UUIDs;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.Lucene;
import org.graylog.shaded.opensearch2.org.opensearch.common.regex.Regex;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.ClusterSettings;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.IndexScopedSettings;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.ArrayUtils;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.FeatureFlags;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.IndexUtils;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.set.Sets;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.Index;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.index.IndexModule;
import org.graylog.shaded.opensearch2.org.opensearch.index.IndexSettings;
import org.graylog.shaded.opensearch2.org.opensearch.index.remote.RemoteStoreEnums;
import org.graylog.shaded.opensearch2.org.opensearch.index.snapshots.IndexShardSnapshotStatus;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.remote.directory.RemoteSnapshotDirectory;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.remote.filecache.FileCacheStats;
import org.graylog.shaded.opensearch2.org.opensearch.indices.IndicesService;
import org.graylog.shaded.opensearch2.org.opensearch.indices.ShardLimitValidator;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.common.ReplicationType;
import org.graylog.shaded.opensearch2.org.opensearch.node.Node;
import org.graylog.shaded.opensearch2.org.opensearch.node.remotestore.RemoteStoreNodeAttribute;
import org.graylog.shaded.opensearch2.org.opensearch.node.remotestore.RemoteStoreNodeService;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.IndexId;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.RepositoriesService;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.Repository;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.RepositoryData;
import org.graylog.shaded.opensearch2.org.opensearch.snapshots.ConcurrentSnapshotExecutionException;
import org.graylog.shaded.opensearch2.org.opensearch.snapshots.RestoreInfo;
import org.graylog.shaded.opensearch2.org.opensearch.snapshots.Snapshot;
import org.graylog.shaded.opensearch2.org.opensearch.snapshots.SnapshotId;
import org.graylog.shaded.opensearch2.org.opensearch.snapshots.SnapshotInfo;
import org.graylog.shaded.opensearch2.org.opensearch.snapshots.SnapshotRestoreException;
import org.graylog.shaded.opensearch2.org.opensearch.snapshots.SnapshotShardFailure;

public class RestoreService
implements ClusterStateApplier {
    private static final Logger logger = LogManager.getLogger(RestoreService.class);
    private static final Set<String> USER_UNMODIFIABLE_SETTINGS = Collections.unmodifiableSet(Sets.newHashSet("index.uuid", "index.creation_date", "index.history.uuid", "index.remote_store.enabled", "index.remote_store.segment.repository", "index.remote_store.translog.repository"));
    private static final Set<String> USER_UNREMOVABLE_SETTINGS;
    private static final String REMOTE_STORE_INDEX_SETTINGS_REGEX = "index.remote_store.*";
    private final ClusterService clusterService;
    private final RepositoriesService repositoriesService;
    private final AllocationService allocationService;
    private final MetadataCreateIndexService createIndexService;
    private final MetadataIndexUpgradeService metadataIndexUpgradeService;
    private final ShardLimitValidator shardLimitValidator;
    private final ClusterSettings clusterSettings;
    private final IndexScopedSettings indexScopedSettings;
    private final IndicesService indicesService;
    private final Supplier<ClusterInfo> clusterInfoSupplier;
    private final ClusterManagerTaskThrottler.ThrottlingKey restoreSnapshotTaskKey;
    private final Supplier<Double> dataToFileCacheSizeRatioSupplier;
    private static final CleanRestoreStateTaskExecutor cleanRestoreStateTaskExecutor;

    public RestoreService(ClusterService clusterService, RepositoriesService repositoriesService, AllocationService allocationService, MetadataCreateIndexService createIndexService, MetadataIndexUpgradeService metadataIndexUpgradeService, ShardLimitValidator shardLimitValidator, IndicesService indicesService, Supplier<ClusterInfo> clusterInfoSupplier, Supplier<Double> dataToFileCacheSizeRatioSupplier) {
        this.clusterService = clusterService;
        this.repositoriesService = repositoriesService;
        this.allocationService = allocationService;
        this.createIndexService = createIndexService;
        this.metadataIndexUpgradeService = metadataIndexUpgradeService;
        if (DiscoveryNode.isClusterManagerNode(clusterService.getSettings())) {
            clusterService.addStateApplier(this);
        }
        this.clusterSettings = clusterService.getClusterSettings();
        this.shardLimitValidator = shardLimitValidator;
        this.indicesService = indicesService;
        this.indexScopedSettings = createIndexService.getIndexScopedSettings();
        this.clusterInfoSupplier = clusterInfoSupplier;
        this.dataToFileCacheSizeRatioSupplier = dataToFileCacheSizeRatioSupplier;
        this.restoreSnapshotTaskKey = clusterService.registerClusterManagerTask("restore-snapshot", true);
    }

    public void restoreSnapshot(final RestoreSnapshotRequest request, ActionListener<RestoreCompletionResponse> listener) {
        try {
            String storeTypeSetting = request.indexSettings().get(IndexModule.INDEX_STORE_TYPE_SETTING.getKey());
            if (storeTypeSetting != null && storeTypeSetting.equals(RestoreSnapshotRequest.StorageType.REMOTE_SNAPSHOT.toString())) {
                throw new SnapshotRestoreException(request.repository(), request.snapshot(), "cannot restore remote snapshot with index settings \"index.store.type\" set to \"remote_snapshot\". Instead use \"storage_type\": \"remote_snapshot\" as argument to restore.");
            }
            String repositoryName = request.repository();
            Repository repository = this.repositoriesService.repository(repositoryName);
            StepListener<RepositoryData> repositoryDataListener = new StepListener<RepositoryData>();
            repository.getRepositoryData(repositoryDataListener);
            repositoryDataListener.whenComplete(repositoryData -> {
                Metadata.Builder metadataBuilder;
                HashMap<String, DataStream> dataStreams;
                String snapshotName = request.snapshot();
                Optional<SnapshotId> matchingSnapshotId = repositoryData.getSnapshotIds().stream().filter(s -> snapshotName.equals(s.getName())).findFirst();
                if (!matchingSnapshotId.isPresent()) {
                    throw new SnapshotRestoreException(repositoryName, snapshotName, "snapshot does not exist");
                }
                final SnapshotId snapshotId = matchingSnapshotId.get();
                if (request.snapshotUuid() != null && !request.snapshotUuid().equals(snapshotId.getUUID())) {
                    throw new SnapshotRestoreException(repositoryName, snapshotName, "snapshot UUID mismatch: expected [" + request.snapshotUuid() + "] but got [" + snapshotId.getUUID() + "]");
                }
                SnapshotInfo snapshotInfo = repository.getSnapshotInfo(snapshotId);
                final Snapshot snapshot = new Snapshot(repositoryName, snapshotId);
                RestoreService.validateSnapshotRestorable(repositoryName, snapshotInfo);
                Metadata globalMetadata = null;
                ArrayList<String> requestIndices = new ArrayList<String>(Arrays.asList(request.indices()));
                List<String> requestedDataStreams = IndexUtils.filterIndices(snapshotInfo.dataStreams(), requestIndices.toArray(new String[0]), IndicesOptions.fromOptions(true, true, true, true));
                if (requestedDataStreams.isEmpty()) {
                    dataStreams = new HashMap<String, DataStream>();
                } else {
                    globalMetadata = repository.getSnapshotGlobalMetadata(snapshotId);
                    Map<String, DataStream> dataStreamsInSnapshot = globalMetadata.dataStreams();
                    dataStreams = new HashMap(requestedDataStreams.size());
                    for (String requestedDataStream : requestedDataStreams) {
                        DataStream dataStreamInSnapshot = dataStreamsInSnapshot.get(requestedDataStream);
                        assert (dataStreamInSnapshot != null) : "DataStream [" + requestedDataStream + "] not found in snapshot";
                        dataStreams.put(requestedDataStream, dataStreamInSnapshot);
                    }
                }
                requestIndices.removeAll(dataStreams.keySet());
                Set<String> dataStreamIndices = dataStreams.values().stream().flatMap(ds -> ds.getIndices().stream()).map(Index::getName).collect(Collectors.toSet());
                requestIndices.addAll(dataStreamIndices);
                List<String> indicesInSnapshot = IndexUtils.filterIndices(snapshotInfo.indices(), requestIndices.toArray(new String[0]), request.indicesOptions());
                if (request.includeGlobalState()) {
                    if (globalMetadata == null) {
                        globalMetadata = repository.getSnapshotGlobalMetadata(snapshotId);
                    }
                    metadataBuilder = Metadata.builder(globalMetadata);
                } else {
                    metadataBuilder = Metadata.builder();
                }
                List<IndexId> indexIdsInSnapshot = repositoryData.resolveIndices(indicesInSnapshot);
                for (IndexId indexId : indexIdsInSnapshot) {
                    metadataBuilder.put(repository.getSnapshotIndexMetaData((RepositoryData)repositoryData, snapshotId, indexId), false);
                }
                Metadata metadata = metadataBuilder.build();
                final Map<String, String> indices = RestoreService.renamedIndices(request, indicesInSnapshot, dataStreamIndices);
                this.clusterService.submitStateUpdateTask("restore_snapshot[" + snapshotName + "]", new ClusterStateUpdateTask((RepositoryData)repositoryData, metadata, snapshotInfo, repository, dataStreams, listener){
                    final String restoreUUID = UUIDs.randomBase64UUID();
                    RestoreInfo restoreInfo = null;
                    final /* synthetic */ RepositoryData val$repositoryData;
                    final /* synthetic */ Metadata val$metadata;
                    final /* synthetic */ SnapshotInfo val$snapshotInfo;
                    final /* synthetic */ Repository val$repository;
                    final /* synthetic */ Map val$dataStreams;
                    final /* synthetic */ ActionListener val$listener;
                    {
                        this.val$repositoryData = repositoryData;
                        this.val$metadata = metadata;
                        this.val$snapshotInfo = snapshotInfo;
                        this.val$repository = repository;
                        this.val$dataStreams = map2;
                        this.val$listener = actionListener;
                    }

                    @Override
                    public ClusterManagerTaskThrottler.ThrottlingKey getClusterManagerThrottlingKey() {
                        return RestoreService.this.restoreSnapshotTaskKey;
                    }

                    @Override
                    public ClusterState execute(ClusterState currentState) {
                        Map<ShardId, RestoreInProgress.ShardRestoreStatus> shards;
                        RestoreInProgress restoreInProgress = currentState.custom("restore", RestoreInProgress.EMPTY);
                        if (currentState.getNodes().getMinNodeVersion().before(LegacyESVersion.V_7_0_0) && !restoreInProgress.isEmpty()) {
                            throw new ConcurrentSnapshotExecutionException(snapshot, "Restore process is already running in this cluster");
                        }
                        SnapshotDeletionsInProgress deletionsInProgress = currentState.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY);
                        if (deletionsInProgress.getEntries().stream().anyMatch(entry -> entry.getSnapshots().contains(snapshotId))) {
                            throw new ConcurrentSnapshotExecutionException(snapshot, "cannot restore a snapshot while a snapshot deletion is in-progress [" + String.valueOf(deletionsInProgress.getEntries().get(0)) + "]");
                        }
                        ClusterState.Builder builder = ClusterState.builder(currentState);
                        Metadata.Builder mdBuilder = Metadata.builder(currentState.metadata());
                        ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
                        RoutingTable.Builder rtBuilder = RoutingTable.builder(currentState.routingTable());
                        boolean isRemoteSnapshot = IndexModule.Type.REMOTE_SNAPSHOT.match(request.storageType().toString());
                        HashSet<String> aliases = new HashSet<String>();
                        long totalRestorableRemoteIndexesSize = 0L;
                        if (!indices.isEmpty()) {
                            HashMap<ShardId, RestoreInProgress.ShardRestoreStatus> shardsBuilder = new HashMap<ShardId, RestoreInProgress.ShardRestoreStatus>();
                            for (Map.Entry entry2 : indices.entrySet()) {
                                Index renamedIndex;
                                IndexMetadata updatedIndexMetadata;
                                boolean isRemoteStoreShallowCopy;
                                String renamedIndexName = (String)entry2.getKey();
                                String index = (String)entry2.getValue();
                                boolean partial = this.checkPartial(index);
                                IndexId snapshotIndexId = this.val$repositoryData.resolveIndexId(index);
                                Settings overrideSettingsInternal = this.getOverrideSettingsInternal();
                                String[] ignoreSettingsInternal = this.getIgnoreSettingsInternal();
                                IndexMetadata snapshotIndexMetadata = this.updateIndexSettings(this.val$metadata.index(index), request.indexSettings(), request.ignoreIndexSettings(), overrideSettingsInternal, ignoreSettingsInternal);
                                RestoreService.validateReplicationTypeRestoreSettings(snapshot, this.val$metadata.index(index).getSettings().get("index.replication.type"), snapshotIndexMetadata);
                                if (isRemoteSnapshot) {
                                    snapshotIndexMetadata = RestoreService.addSnapshotToIndexSettings(snapshotIndexMetadata, snapshot, snapshotIndexId);
                                }
                                boolean isSearchableSnapshot = snapshotIndexMetadata.isRemoteSnapshot();
                                boolean bl = isRemoteStoreShallowCopy = Boolean.TRUE.equals(this.val$snapshotInfo.isRemoteStoreIndexShallowCopyEnabled()) && this.val$metadata.index(index).getSettings().getAsBoolean("index.remote_store.enabled", false) != false;
                                if (isSearchableSnapshot && isRemoteStoreShallowCopy) {
                                    throw new SnapshotRestoreException(snapshot, "Shallow copy snapshot cannot be restored as searchable snapshot.");
                                }
                                if (isRemoteStoreShallowCopy && !currentState.getNodes().getMinNodeVersion().onOrAfter(Version.V_2_9_0)) {
                                    throw new SnapshotRestoreException(snapshot, "cannot restore shallow copy snapshot for index [" + index + "] as some of the nodes in cluster have version less than 2.9");
                                }
                                RecoverySource.SnapshotRecoverySource recoverySource = new RecoverySource.SnapshotRecoverySource(this.restoreUUID, snapshot, this.val$snapshotInfo.version(), snapshotIndexId, isSearchableSnapshot, isRemoteStoreShallowCopy, request.getSourceRemoteStoreRepository(), request.getSourceRemoteTranslogRepository(), this.val$snapshotInfo.getPinnedTimestamp());
                                Version minIndexCompatibilityVersion = isSearchableSnapshot && RestoreService.isSearchableSnapshotsExtendedCompatibilityEnabled() ? RemoteSnapshotDirectory.SEARCHABLE_SNAPSHOT_EXTENDED_COMPATIBILITY_MINIMUM_VERSION.minimumIndexCompatibilityVersion() : currentState.getNodes().getMaxNodeVersion().minimumIndexCompatibilityVersion();
                                try {
                                    snapshotIndexMetadata = RestoreService.this.metadataIndexUpgradeService.upgradeIndexMetadata(snapshotIndexMetadata, minIndexCompatibilityVersion);
                                }
                                catch (Exception ex) {
                                    throw new SnapshotRestoreException(snapshot, "cannot restore index [" + index + "] because it cannot be upgraded", ex);
                                }
                                IndexMetadata currentIndexMetadata = currentState.metadata().index(renamedIndexName);
                                HashSet<Integer> ignoreShards = new HashSet<Integer>();
                                if (currentIndexMetadata == null) {
                                    boolean isHidden = IndexMetadata.INDEX_HIDDEN_SETTING.get(snapshotIndexMetadata.getSettings());
                                    RestoreService.this.createIndexService.validateIndexName(renamedIndexName, currentState);
                                    RestoreService.this.createIndexService.validateDotIndex(renamedIndexName, isHidden);
                                    RestoreService.this.createIndexService.validateIndexSettings(renamedIndexName, snapshotIndexMetadata.getSettings(), false);
                                    MetadataCreateIndexService.validateRefreshIntervalSettings(snapshotIndexMetadata.getSettings(), RestoreService.this.clusterSettings);
                                    IndexMetadata.Builder indexMdBuilder = IndexMetadata.builder(snapshotIndexMetadata).state(IndexMetadata.State.OPEN).index(renamedIndexName);
                                    indexMdBuilder.settings(Settings.builder().put(snapshotIndexMetadata.getSettings()).put("index.uuid", UUIDs.randomBase64UUID()));
                                    RestoreService.this.createIndexService.addRemoteStoreCustomMetadata(indexMdBuilder, false);
                                    RestoreService.this.shardLimitValidator.validateShardLimit(renamedIndexName, snapshotIndexMetadata.getSettings(), currentState);
                                    if (!request.includeAliases() && !snapshotIndexMetadata.getAliases().isEmpty()) {
                                        indexMdBuilder.removeAllAliases();
                                    } else {
                                        this.applyAliasesWithRename(snapshotIndexMetadata, indexMdBuilder, aliases);
                                    }
                                    updatedIndexMetadata = indexMdBuilder.build();
                                    if (partial) {
                                        this.populateIgnoredShards(index, ignoreShards);
                                    }
                                    rtBuilder.addAsNewRestore(updatedIndexMetadata, recoverySource, ignoreShards);
                                    blocks.addBlocks(updatedIndexMetadata);
                                    mdBuilder.put(updatedIndexMetadata, true);
                                    renamedIndex = updatedIndexMetadata.getIndex();
                                } else {
                                    this.validateExistingIndex(currentIndexMetadata, snapshotIndexMetadata, renamedIndexName, partial);
                                    IndexMetadata.Builder indexMdBuilder = IndexMetadata.builder(snapshotIndexMetadata).state(IndexMetadata.State.OPEN);
                                    indexMdBuilder.version(Math.max(snapshotIndexMetadata.getVersion(), 1L + currentIndexMetadata.getVersion()));
                                    indexMdBuilder.mappingVersion(Math.max(snapshotIndexMetadata.getMappingVersion(), 1L + currentIndexMetadata.getMappingVersion()));
                                    indexMdBuilder.settingsVersion(Math.max(snapshotIndexMetadata.getSettingsVersion(), 1L + currentIndexMetadata.getSettingsVersion()));
                                    indexMdBuilder.aliasesVersion(Math.max(snapshotIndexMetadata.getAliasesVersion(), 1L + currentIndexMetadata.getAliasesVersion()));
                                    for (int shard = 0; shard < snapshotIndexMetadata.getNumberOfShards(); ++shard) {
                                        indexMdBuilder.primaryTerm(shard, Math.max(snapshotIndexMetadata.primaryTerm(shard), currentIndexMetadata.primaryTerm(shard)));
                                    }
                                    if (!request.includeAliases()) {
                                        if (!snapshotIndexMetadata.getAliases().isEmpty()) {
                                            indexMdBuilder.removeAllAliases();
                                        }
                                        for (AliasMetadata alias : currentIndexMetadata.getAliases().values()) {
                                            indexMdBuilder.putAlias(alias);
                                        }
                                    } else {
                                        this.applyAliasesWithRename(snapshotIndexMetadata, indexMdBuilder, aliases);
                                    }
                                    Settings.Builder indexSettingsBuilder = Settings.builder().put(snapshotIndexMetadata.getSettings()).put("index.uuid", currentIndexMetadata.getIndexUUID());
                                    if (snapshotIndexMetadata.getCreationVersion().onOrAfter(LegacyESVersion.V_7_9_0) || currentState.nodes().getMinNodeVersion().onOrAfter(LegacyESVersion.V_7_9_0)) {
                                        indexSettingsBuilder.put("index.history.uuid", UUIDs.randomBase64UUID());
                                    }
                                    indexMdBuilder.settings(indexSettingsBuilder);
                                    updatedIndexMetadata = indexMdBuilder.index(renamedIndexName).build();
                                    rtBuilder.addAsRestore(updatedIndexMetadata, recoverySource);
                                    blocks.updateBlocks(updatedIndexMetadata);
                                    mdBuilder.put(updatedIndexMetadata, true);
                                    renamedIndex = updatedIndexMetadata.getIndex();
                                }
                                for (int shard = 0; shard < snapshotIndexMetadata.getNumberOfShards(); ++shard) {
                                    if (isRemoteSnapshot) {
                                        IndexShardSnapshotStatus.Copy shardStatus = this.val$repository.getShardSnapshotStatus(this.val$snapshotInfo, snapshotIndexId, new ShardId(this.val$metadata.index(index).getIndex(), shard)).asCopy();
                                        totalRestorableRemoteIndexesSize += shardStatus.getTotalSize();
                                    }
                                    if (!ignoreShards.contains(shard)) {
                                        shardsBuilder.put(new ShardId(renamedIndex, shard), new RestoreInProgress.ShardRestoreStatus(RestoreService.this.clusterService.state().nodes().getLocalNodeId()));
                                        continue;
                                    }
                                    shardsBuilder.put(new ShardId(renamedIndex, shard), new RestoreInProgress.ShardRestoreStatus(RestoreService.this.clusterService.state().nodes().getLocalNodeId(), RestoreInProgress.State.FAILURE));
                                }
                            }
                            shards = Collections.unmodifiableMap(shardsBuilder);
                            RestoreInProgress.Entry restoreEntry = new RestoreInProgress.Entry(this.restoreUUID, snapshot, RestoreService.overallState(RestoreInProgress.State.INIT, shards), Collections.unmodifiableList(new ArrayList(indices.keySet())), shards);
                            builder.putCustom("restore", new RestoreInProgress.Builder(currentState.custom("restore", RestoreInProgress.EMPTY)).add(restoreEntry).build());
                        } else {
                            shards = Map.of();
                        }
                        this.checkAliasNameConflicts(indices, aliases);
                        if (isRemoteSnapshot) {
                            this.validateSearchableSnapshotRestorable(totalRestorableRemoteIndexesSize);
                        }
                        HashMap<String, DataStream> updatedDataStreams = new HashMap<String, DataStream>(currentState.metadata().dataStreams());
                        updatedDataStreams.putAll(this.val$dataStreams.values().stream().map(ds -> RestoreService.updateDataStream(ds, mdBuilder, request)).collect(Collectors.toMap(DataStream::getName, Function.identity())));
                        mdBuilder.dataStreams(updatedDataStreams);
                        if (request.includeGlobalState()) {
                            if (this.val$metadata.persistentSettings() != null) {
                                Iterator<Map.Entry<String, Metadata.Custom>> settings = this.val$metadata.persistentSettings();
                                RestoreService.this.clusterSettings.validateUpdate((Settings)((Object)settings));
                                mdBuilder.persistentSettings((Settings)((Object)settings));
                            }
                            if (this.val$metadata.templates() != null) {
                                for (IndexTemplateMetadata indexTemplateMetadata : this.val$metadata.templates().values()) {
                                    MetadataCreateIndexService.validateRefreshIntervalSettings(indexTemplateMetadata.settings(), RestoreService.this.clusterSettings);
                                    mdBuilder.put(indexTemplateMetadata);
                                }
                            }
                            if (this.val$metadata.customs() != null) {
                                for (Map.Entry<String, Metadata.Custom> entry3 : this.val$metadata.customs().entrySet()) {
                                    if ("repositories".equals(entry3.getKey()) || "data_stream".equals(entry3.getKey())) continue;
                                    mdBuilder.putCustom(entry3.getKey(), entry3.getValue());
                                }
                            }
                        }
                        if (RestoreService.completed(shards)) {
                            this.restoreInfo = new RestoreInfo(snapshotId.getName(), Collections.unmodifiableList(new ArrayList(indices.keySet())), shards.size(), shards.size() - RestoreService.failedShards(shards));
                        }
                        RoutingTable rt = rtBuilder.build();
                        ClusterState clusterState = builder.metadata(mdBuilder).blocks(blocks).routingTable(rt).build();
                        return RestoreService.this.allocationService.reroute(clusterState, "restored snapshot [" + String.valueOf(snapshot) + "]");
                    }

                    private void checkAliasNameConflicts(Map<String, String> renamedIndices, Set<String> aliases) {
                        for (Map.Entry<String, String> renamedIndex : renamedIndices.entrySet()) {
                            if (!aliases.contains(renamedIndex.getKey())) continue;
                            throw new SnapshotRestoreException(snapshot, "cannot rename index [" + renamedIndex.getValue() + "] into [" + renamedIndex.getKey() + "] because of conflict with an alias with the same name");
                        }
                    }

                    private void applyAliasesWithRename(IndexMetadata snapshotIndexMetadata, IndexMetadata.Builder indexMdBuilder, Set<String> aliases) {
                        if (request.renameAliasPattern() == null || request.renameAliasReplacement() == null) {
                            aliases.addAll(snapshotIndexMetadata.getAliases().keySet());
                        } else {
                            Pattern renameAliasPattern = Pattern.compile(request.renameAliasPattern());
                            for (Map.Entry<String, AliasMetadata> alias : snapshotIndexMetadata.getAliases().entrySet()) {
                                String currentAliasName = alias.getKey();
                                indexMdBuilder.removeAlias(currentAliasName);
                                String newAliasName = renameAliasPattern.matcher(currentAliasName).replaceAll(request.renameAliasReplacement());
                                AliasMetadata newAlias = AliasMetadata.newAliasMetadata(alias.getValue(), newAliasName);
                                indexMdBuilder.putAlias(newAlias);
                                aliases.add(newAliasName);
                            }
                        }
                    }

                    private String[] getIgnoreSettingsInternal() {
                        String[] indexSettingsToBeIgnored = new String[]{};
                        if (!RemoteStoreNodeAttribute.isRemoteStoreAttributePresent(RestoreService.this.clusterService.getSettings())) {
                            indexSettingsToBeIgnored = ArrayUtils.concat(indexSettingsToBeIgnored, new String[]{RestoreService.REMOTE_STORE_INDEX_SETTINGS_REGEX});
                        }
                        return indexSettingsToBeIgnored;
                    }

                    private Settings getOverrideSettingsInternal() {
                        Settings.Builder settingsBuilder = Settings.builder();
                        if (RemoteStoreNodeAttribute.isRemoteStoreAttributePresent(RestoreService.this.clusterService.getSettings()) || RestoreService.this.clusterSettings.get(IndicesService.CLUSTER_INDEX_RESTRICT_REPLICATION_TYPE_SETTING).booleanValue() || RemoteStoreNodeService.isMigratingToRemoteStore(RestoreService.this.clusterSettings)) {
                            MetadataCreateIndexService.updateReplicationStrategy(settingsBuilder, request.indexSettings(), RestoreService.this.clusterService.getSettings(), null, RestoreService.this.clusterSettings);
                        }
                        MetadataCreateIndexService.updateRemoteStoreSettings(settingsBuilder, RestoreService.this.clusterService.state(), RestoreService.this.clusterSettings, RestoreService.this.clusterService.getSettings(), String.join((CharSequence)",", request.indices()));
                        return settingsBuilder.build();
                    }

                    private void populateIgnoredShards(String index, Set<Integer> ignoreShards) {
                        for (SnapshotShardFailure failure : this.val$snapshotInfo.shardFailures()) {
                            if (!index.equals(failure.index())) continue;
                            ignoreShards.add(failure.shardId());
                        }
                    }

                    private boolean checkPartial(String index) {
                        if (RestoreService.failed(this.val$snapshotInfo, index)) {
                            if (request.partial()) {
                                return true;
                            }
                            throw new SnapshotRestoreException(snapshot, "index [" + index + "] wasn't fully snapshotted - cannot restore");
                        }
                        return false;
                    }

                    private void validateExistingIndex(IndexMetadata currentIndexMetadata, IndexMetadata snapshotIndexMetadata, String renamedIndex, boolean partial) {
                        if (currentIndexMetadata.getState() != IndexMetadata.State.CLOSE) {
                            throw new SnapshotRestoreException(snapshot, "cannot restore index [" + renamedIndex + "] because an open index with same name already exists in the cluster. Either close or delete the existing index or restore the index under a different name by providing a rename pattern and replacement name");
                        }
                        if (partial) {
                            throw new SnapshotRestoreException(snapshot, "cannot restore partial index [" + renamedIndex + "] because such index already exists");
                        }
                        if (currentIndexMetadata.getNumberOfShards() != snapshotIndexMetadata.getNumberOfShards()) {
                            throw new SnapshotRestoreException(snapshot, "cannot restore index [" + renamedIndex + "] with [" + currentIndexMetadata.getNumberOfShards() + "] shards from a snapshot of index [" + snapshotIndexMetadata.getIndex().getName() + "] with [" + snapshotIndexMetadata.getNumberOfShards() + "] shards");
                        }
                    }

                    private IndexMetadata updateIndexSettings(IndexMetadata indexMetadata, Settings overrideSettings, String[] ignoreSettings, Settings overrideSettingsInternal, String[] ignoreSettingsInternal) {
                        Settings normalizedChangeSettings = Settings.builder().put(overrideSettings).normalizePrefix("index.").build();
                        if (IndexSettings.INDEX_SOFT_DELETES_SETTING.get(indexMetadata.getSettings()).booleanValue() && IndexSettings.INDEX_SOFT_DELETES_SETTING.exists(overrideSettings) && !IndexSettings.INDEX_SOFT_DELETES_SETTING.get(overrideSettings).booleanValue()) {
                            throw new SnapshotRestoreException(snapshot, "cannot disable setting [" + IndexSettings.INDEX_SOFT_DELETES_SETTING.getKey() + "] on restore");
                        }
                        IndexMetadata.Builder builder = IndexMetadata.builder(indexMetadata);
                        Settings settings = indexMetadata.getSettings();
                        HashSet<String> keyFilters = new HashSet<String>();
                        ArrayList<String> simpleMatchPatterns = new ArrayList<String>();
                        for (String ignoredSetting : ignoreSettings) {
                            if (!Regex.isSimpleMatchPattern(ignoredSetting)) {
                                if (USER_UNREMOVABLE_SETTINGS.contains(ignoredSetting)) {
                                    throw new SnapshotRestoreException(snapshot, "cannot remove setting [" + ignoredSetting + "] on restore");
                                }
                                if (RestoreService.this.indexScopedSettings.isUnmodifiableOnRestoreSetting(ignoredSetting)) {
                                    throw new SnapshotRestoreException(snapshot, "cannot remove UnmodifiableOnRestore setting [" + ignoredSetting + "] on restore");
                                }
                                keyFilters.add(ignoredSetting);
                                continue;
                            }
                            simpleMatchPatterns.add(ignoredSetting);
                        }
                        for (String ignoredSetting : ignoreSettingsInternal) {
                            if (!Regex.isSimpleMatchPattern(ignoredSetting)) {
                                keyFilters.add(ignoredSetting);
                                continue;
                            }
                            simpleMatchPatterns.add(ignoredSetting);
                        }
                        Predicate<String> settingsFilter = k -> {
                            if (!USER_UNREMOVABLE_SETTINGS.contains(k) && !RestoreService.this.indexScopedSettings.isUnmodifiableOnRestoreSetting((String)k)) {
                                for (String filterKey : keyFilters) {
                                    if (!k.equals(filterKey)) continue;
                                    return false;
                                }
                                for (String pattern : simpleMatchPatterns) {
                                    if (!Regex.simpleMatch(pattern, k)) continue;
                                    return false;
                                }
                            }
                            return true;
                        };
                        Settings.Builder settingsBuilder = Settings.builder().put(settings.filter(settingsFilter)).put(normalizedChangeSettings.filter(k -> {
                            if (USER_UNMODIFIABLE_SETTINGS.contains(k)) {
                                throw new SnapshotRestoreException(snapshot, "cannot modify setting [" + k + "] on restore");
                            }
                            if (RestoreService.this.indexScopedSettings.isUnmodifiableOnRestoreSetting((String)k)) {
                                throw new SnapshotRestoreException(snapshot, "cannot modify UnmodifiableOnRestore setting [" + k + "] on restore");
                            }
                            return true;
                        }));
                        if (overrideSettingsInternal != null) {
                            settingsBuilder.put(overrideSettingsInternal).normalizePrefix("index.");
                        }
                        settingsBuilder.remove(MetadataIndexStateService.VERIFIED_BEFORE_CLOSE_SETTING.getKey());
                        return builder.settings(settingsBuilder).build();
                    }

                    private void validateSearchableSnapshotRestorable(long totalRestorableRemoteIndexesSize) {
                        ClusterInfo clusterInfo = RestoreService.this.clusterInfoSupplier.get();
                        double remoteDataToFileCacheRatio = RestoreService.this.dataToFileCacheSizeRatioSupplier.get();
                        Map<String, FileCacheStats> nodeFileCacheStats = clusterInfo.getNodeFileCacheStats();
                        if (nodeFileCacheStats.isEmpty() || remoteDataToFileCacheRatio <= (double)0.01f) {
                            return;
                        }
                        long totalNodeFileCacheSize = clusterInfo.getNodeFileCacheStats().values().stream().map(fileCacheStats -> fileCacheStats.getTotal().getBytes()).mapToLong(Long::longValue).sum();
                        Predicate<ShardRouting> isRemoteSnapshotShard = shardRouting -> shardRouting.primary() && RestoreService.this.clusterService.state().getMetadata().getIndexSafe(shardRouting.index()).isRemoteSnapshot();
                        ShardsIterator shardsIterator = RestoreService.this.clusterService.state().routingTable().allShardsSatisfyingPredicate(isRemoteSnapshotShard);
                        long totalRestoredRemoteIndexesSize = shardsIterator.getShardRoutings().stream().map(clusterInfo::getShardSize).mapToLong(Long::longValue).sum();
                        if ((double)(totalRestoredRemoteIndexesSize + totalRestorableRemoteIndexesSize) > remoteDataToFileCacheRatio * (double)totalNodeFileCacheSize) {
                            throw new SnapshotRestoreException(snapshot, "Size of the indexes to be restored exceeds the file cache bounds. Increase the file cache capacity on the cluster nodes using " + Node.NODE_SEARCH_CACHE_SIZE_SETTING.getKey() + " setting.");
                        }
                    }

                    @Override
                    public void onFailure(String source, Exception e) {
                        logger.warn(() -> new ParameterizedMessage("[{}] failed to restore snapshot", (Object)snapshotId), (Throwable)e);
                        this.val$listener.onFailure(e);
                    }

                    @Override
                    public TimeValue timeout() {
                        return request.clusterManagerNodeTimeout();
                    }

                    @Override
                    public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                        this.val$listener.onResponse(new RestoreCompletionResponse(this.restoreUUID, snapshot, this.restoreInfo));
                    }
                });
            }, listener::onFailure);
        }
        catch (Exception e) {
            logger.warn(() -> new ParameterizedMessage("[{}] failed to restore snapshot", (Object)(request.repository() + ":" + request.snapshot())), (Throwable)e);
            listener.onFailure(e);
        }
    }

    static DataStream updateDataStream(DataStream dataStream, Metadata.Builder metadata, RestoreSnapshotRequest request) {
        String dataStreamName = dataStream.getName();
        if (request.renamePattern() != null && request.renameReplacement() != null) {
            dataStreamName = dataStreamName.replaceAll(request.renamePattern(), request.renameReplacement());
        }
        List<Index> updatedIndices = dataStream.getIndices().stream().map(i -> metadata.get(RestoreService.renameIndex(i.getName(), request, true)).getIndex()).collect(Collectors.toList());
        return new DataStream(dataStreamName, dataStream.getTimeStampField(), updatedIndices, dataStream.getGeneration());
    }

    public static RestoreInProgress updateRestoreStateWithDeletedIndices(RestoreInProgress oldRestore, Set<Index> deletedIndices) {
        boolean changesMade = false;
        RestoreInProgress.Builder builder = new RestoreInProgress.Builder();
        for (RestoreInProgress.Entry entry : oldRestore) {
            HashMap<ShardId, RestoreInProgress.ShardRestoreStatus> shardsBuilder = null;
            for (Map.Entry<ShardId, RestoreInProgress.ShardRestoreStatus> cursor : entry.shards().entrySet()) {
                ShardId shardId = cursor.getKey();
                if (!deletedIndices.contains(shardId.getIndex())) continue;
                changesMade = true;
                if (shardsBuilder == null) {
                    shardsBuilder = new HashMap<ShardId, RestoreInProgress.ShardRestoreStatus>(entry.shards());
                }
                shardsBuilder.put(shardId, new RestoreInProgress.ShardRestoreStatus(null, RestoreInProgress.State.FAILURE, "index was deleted"));
            }
            if (shardsBuilder != null) {
                Map<ShardId, RestoreInProgress.ShardRestoreStatus> shards = Collections.unmodifiableMap(shardsBuilder);
                builder.add(new RestoreInProgress.Entry(entry.uuid(), entry.snapshot(), RestoreService.overallState(RestoreInProgress.State.STARTED, shards), entry.indices(), shards));
                continue;
            }
            builder.add(entry);
        }
        if (changesMade) {
            return builder.build();
        }
        return oldRestore;
    }

    public static RestoreInProgress.Entry restoreInProgress(ClusterState state, String restoreUUID) {
        return state.custom("restore", RestoreInProgress.EMPTY).get(restoreUUID);
    }

    private void cleanupRestoreState(ClusterChangedEvent event) {
        for (RestoreInProgress.Entry entry : event.state().custom("restore", RestoreInProgress.EMPTY)) {
            if (!entry.state().completed()) continue;
            assert (RestoreService.completed(entry.shards())) : "state says completed but restore entries are not";
            this.clusterService.submitStateUpdateTask("clean up snapshot restore state", new CleanRestoreStateTaskExecutor.Task(entry.uuid()), ClusterStateTaskConfig.build(Priority.URGENT), cleanRestoreStateTaskExecutor, cleanRestoreStateTaskExecutor);
        }
    }

    private static RestoreInProgress.State overallState(RestoreInProgress.State nonCompletedState, Map<ShardId, RestoreInProgress.ShardRestoreStatus> shards) {
        boolean hasFailed = false;
        for (RestoreInProgress.ShardRestoreStatus status : shards.values()) {
            if (!status.state().completed()) {
                return nonCompletedState;
            }
            if (status.state() != RestoreInProgress.State.FAILURE) continue;
            hasFailed = true;
        }
        if (hasFailed) {
            return RestoreInProgress.State.FAILURE;
        }
        return RestoreInProgress.State.SUCCESS;
    }

    public static boolean completed(Map<ShardId, RestoreInProgress.ShardRestoreStatus> shards) {
        for (RestoreInProgress.ShardRestoreStatus status : shards.values()) {
            if (status.state().completed()) continue;
            return false;
        }
        return true;
    }

    public static int failedShards(Map<ShardId, RestoreInProgress.ShardRestoreStatus> shards) {
        int failedShards = 0;
        for (RestoreInProgress.ShardRestoreStatus status : shards.values()) {
            if (status.state() != RestoreInProgress.State.FAILURE) continue;
            ++failedShards;
        }
        return failedShards;
    }

    private static Map<String, String> renamedIndices(RestoreSnapshotRequest request, List<String> filteredIndices, Set<String> dataStreamIndices) {
        HashMap<String, String> renamedIndices = new HashMap<String, String>();
        for (String index : filteredIndices) {
            String renamedIndex = RestoreService.renameIndex(index, request, dataStreamIndices.contains(index));
            String previousIndex = renamedIndices.put(renamedIndex, index);
            if (previousIndex == null) continue;
            throw new SnapshotRestoreException(request.repository(), request.snapshot(), "indices [" + index + "] and [" + previousIndex + "] are renamed into the same index [" + renamedIndex + "]");
        }
        return Collections.unmodifiableMap(renamedIndices);
    }

    private static String renameIndex(String index, RestoreSnapshotRequest request, boolean partOfDataStream) {
        Object renamedIndex = index;
        if (request.renameReplacement() != null && request.renamePattern() != null) {
            boolean bl = partOfDataStream = partOfDataStream && index.startsWith(".ds-");
            if (partOfDataStream) {
                index = index.substring(".ds-".length());
            }
            renamedIndex = index.replaceAll(request.renamePattern(), request.renameReplacement());
            if (partOfDataStream) {
                renamedIndex = ".ds-" + (String)renamedIndex;
            }
        }
        return renamedIndex;
    }

    private static void validateSnapshotRestorable(String repository, SnapshotInfo snapshotInfo) {
        if (!snapshotInfo.state().restorable()) {
            throw new SnapshotRestoreException(new Snapshot(repository, snapshotInfo.snapshotId()), "unsupported snapshot state [" + String.valueOf((Object)snapshotInfo.state()) + "]");
        }
        if (Version.CURRENT.before(snapshotInfo.version())) {
            throw new SnapshotRestoreException(new Snapshot(repository, snapshotInfo.snapshotId()), "the snapshot was created with OpenSearch version [" + String.valueOf(snapshotInfo.version()) + "] which is higher than the version of this node [" + String.valueOf(Version.CURRENT) + "]");
        }
    }

    static void validateReplicationTypeRestoreSettings(Snapshot snapshot, String snapshotReplicationType, IndexMetadata updatedMetadata) {
        int restoreNumberOfSearchReplicas = updatedMetadata.getSettings().getAsInt("index.number_of_search_only_replicas", 0);
        if (restoreNumberOfSearchReplicas > 0 && ReplicationType.DOCUMENT.toString().equals(updatedMetadata.getSettings().get("index.replication.type"))) {
            throw new SnapshotRestoreException(snapshot, "snapshot was created with [index.replication.type] as [" + snapshotReplicationType + "]. To restore with [index.replication.type] as [" + String.valueOf((Object)ReplicationType.DOCUMENT) + "], [index.number_of_search_only_replicas] must be set to [0]");
        }
    }

    public static boolean failed(SnapshotInfo snapshot, String index) {
        for (SnapshotShardFailure failure : snapshot.shardFailures()) {
            if (!index.equals(failure.index())) continue;
            return true;
        }
        return false;
    }

    public static Set<Index> restoringIndices(ClusterState currentState, Set<Index> indicesToCheck) {
        HashSet<Index> indices = new HashSet<Index>();
        for (RestoreInProgress.Entry entry : currentState.custom("restore", RestoreInProgress.EMPTY)) {
            for (Map.Entry<ShardId, RestoreInProgress.ShardRestoreStatus> shard : entry.shards().entrySet()) {
                Index index = shard.getKey().getIndex();
                if (!indicesToCheck.contains(index) || shard.getValue().state().completed() || currentState.getMetadata().index(index) == null) continue;
                indices.add(index);
            }
        }
        return indices;
    }

    @Override
    public void applyClusterState(ClusterChangedEvent event) {
        try {
            if (event.localNodeClusterManager()) {
                this.cleanupRestoreState(event);
            }
        }
        catch (Exception t) {
            logger.warn("Failed to update restore state ", (Throwable)t);
        }
    }

    private static IndexMetadata addSnapshotToIndexSettings(IndexMetadata metadata, Snapshot snapshot, IndexId indexId) {
        Settings newSettings = Settings.builder().put(metadata.getSettings()).put(IndexModule.INDEX_STORE_TYPE_SETTING.getKey(), IndexModule.Type.REMOTE_SNAPSHOT.getSettingsKey()).put(IndexSettings.SEARCHABLE_SNAPSHOT_REPOSITORY.getKey(), snapshot.getRepository()).put(IndexSettings.SEARCHABLE_SNAPSHOT_ID_UUID.getKey(), snapshot.getSnapshotId().getUUID()).put(IndexSettings.SEARCHABLE_SNAPSHOT_ID_NAME.getKey(), snapshot.getSnapshotId().getName()).put(IndexSettings.SEARCHABLE_SNAPSHOT_INDEX_ID.getKey(), indexId.getId()).put(IndexSettings.SEARCHABLE_SNAPSHOT_SHARD_PATH_TYPE.getKey(), RemoteStoreEnums.PathType.fromCode(indexId.getShardPathType())).build();
        return IndexMetadata.builder(metadata).settings(newSettings).build();
    }

    private static boolean isSearchableSnapshotsExtendedCompatibilityEnabled() {
        return Version.CURRENT.after(Version.V_2_4_0) && FeatureFlags.isEnabled("opensearch.experimental.feature.searchable_snapshot.extended_compatibility.enabled");
    }

    static {
        HashSet<String> unremovable = new HashSet<String>(USER_UNMODIFIABLE_SETTINGS.size() + 3);
        unremovable.addAll(USER_UNMODIFIABLE_SETTINGS);
        unremovable.add("index.number_of_replicas");
        unremovable.add("index.auto_expand_replicas");
        unremovable.add("index.version.upgraded");
        USER_UNREMOVABLE_SETTINGS = Collections.unmodifiableSet(unremovable);
        cleanRestoreStateTaskExecutor = new CleanRestoreStateTaskExecutor();
    }

    static class CleanRestoreStateTaskExecutor
    implements ClusterStateTaskExecutor<Task>,
    ClusterStateTaskListener {
        CleanRestoreStateTaskExecutor() {
        }

        @Override
        public ClusterStateTaskExecutor.ClusterTasksResult<Task> execute(ClusterState currentState, List<Task> tasks) {
            ClusterStateTaskExecutor.ClusterTasksResult.Builder<Task> resultBuilder = ClusterStateTaskExecutor.ClusterTasksResult.builder().successes(tasks);
            Set completedRestores = tasks.stream().map(e -> e.uuid).collect(Collectors.toSet());
            RestoreInProgress.Builder restoreInProgressBuilder = new RestoreInProgress.Builder();
            boolean changed = false;
            for (RestoreInProgress.Entry entry : currentState.custom("restore", RestoreInProgress.EMPTY)) {
                if (completedRestores.contains(entry.uuid())) {
                    changed = true;
                    continue;
                }
                restoreInProgressBuilder.add(entry);
            }
            if (!changed) {
                return resultBuilder.build(currentState);
            }
            HashMap<String, ClusterState.Custom> builder = new HashMap<String, ClusterState.Custom>(currentState.getCustoms());
            builder.put("restore", restoreInProgressBuilder.build());
            Map<String, ClusterState.Custom> customs = Collections.unmodifiableMap(builder);
            return resultBuilder.build(ClusterState.builder(currentState).customs(customs).build());
        }

        @Override
        public void onFailure(String source, Exception e) {
            logger.error(() -> new ParameterizedMessage("unexpected failure during [{}]", (Object)source), (Throwable)e);
        }

        @Override
        public void onNoLongerClusterManager(String source) {
            logger.debug("no longer cluster-manager while processing restore state update [{}]", (Object)source);
        }

        static class Task {
            final String uuid;

            Task(String uuid) {
                this.uuid = uuid;
            }

            public String toString() {
                return "clean restore state for restore " + this.uuid;
            }
        }
    }

    public static class RestoreInProgressUpdater
    extends RoutingChangesObserver.AbstractRoutingChangesObserver {
        private final Map<String, Map<ShardId, RestoreInProgress.ShardRestoreStatus>> shardChanges = new HashMap<String, Map<ShardId, RestoreInProgress.ShardRestoreStatus>>();

        @Override
        public void shardStarted(ShardRouting initializingShard, ShardRouting startedShard) {
            RecoverySource recoverySource;
            if (initializingShard.primary() && (recoverySource = initializingShard.recoverySource()).getType() == RecoverySource.Type.SNAPSHOT) {
                this.changes(recoverySource).put(initializingShard.shardId(), new RestoreInProgress.ShardRestoreStatus(initializingShard.currentNodeId(), RestoreInProgress.State.SUCCESS));
            }
        }

        @Override
        public void shardFailed(ShardRouting failedShard, UnassignedInfo unassignedInfo) {
            RecoverySource recoverySource;
            if (failedShard.primary() && failedShard.initializing() && (recoverySource = failedShard.recoverySource()).getType() == RecoverySource.Type.SNAPSHOT && unassignedInfo.getFailure() != null && Lucene.isCorruptionException(unassignedInfo.getFailure().getCause())) {
                this.changes(recoverySource).put(failedShard.shardId(), new RestoreInProgress.ShardRestoreStatus(failedShard.currentNodeId(), RestoreInProgress.State.FAILURE, unassignedInfo.getFailure().getCause().getMessage()));
            }
        }

        @Override
        public void shardInitialized(ShardRouting unassignedShard, ShardRouting initializedShard) {
            if (unassignedShard.recoverySource().getType() == RecoverySource.Type.SNAPSHOT && initializedShard.recoverySource().getType() != RecoverySource.Type.SNAPSHOT) {
                this.changes(unassignedShard.recoverySource()).put(unassignedShard.shardId(), new RestoreInProgress.ShardRestoreStatus(null, RestoreInProgress.State.FAILURE, "recovery source type changed from snapshot to " + String.valueOf(initializedShard.recoverySource())));
            }
        }

        @Override
        public void unassignedInfoUpdated(ShardRouting unassignedShard, UnassignedInfo newUnassignedInfo) {
            RecoverySource recoverySource = unassignedShard.recoverySource();
            if (recoverySource.getType() == RecoverySource.Type.SNAPSHOT && newUnassignedInfo.getLastAllocationStatus() == UnassignedInfo.AllocationStatus.DECIDERS_NO) {
                String reason = "shard could not be allocated to any of the nodes";
                this.changes(recoverySource).put(unassignedShard.shardId(), new RestoreInProgress.ShardRestoreStatus(unassignedShard.currentNodeId(), RestoreInProgress.State.FAILURE, reason));
            }
        }

        private Map<ShardId, RestoreInProgress.ShardRestoreStatus> changes(RecoverySource recoverySource) {
            assert (recoverySource.getType() == RecoverySource.Type.SNAPSHOT);
            return this.shardChanges.computeIfAbsent(((RecoverySource.SnapshotRecoverySource)recoverySource).restoreUUID(), k -> new HashMap());
        }

        public RestoreInProgress applyChanges(RestoreInProgress oldRestore) {
            if (!this.shardChanges.isEmpty()) {
                RestoreInProgress.Builder builder = new RestoreInProgress.Builder();
                for (RestoreInProgress.Entry entry : oldRestore) {
                    Map<ShardId, RestoreInProgress.ShardRestoreStatus> updates = this.shardChanges.get(entry.uuid());
                    Map<ShardId, RestoreInProgress.ShardRestoreStatus> shardStates = entry.shards();
                    if (updates != null && !updates.isEmpty()) {
                        HashMap<ShardId, RestoreInProgress.ShardRestoreStatus> shardsBuilder = new HashMap<ShardId, RestoreInProgress.ShardRestoreStatus>(shardStates);
                        for (Map.Entry<ShardId, RestoreInProgress.ShardRestoreStatus> shard : updates.entrySet()) {
                            ShardId shardId = shard.getKey();
                            RestoreInProgress.ShardRestoreStatus status = shardStates.get(shardId);
                            if (status != null && status.state().completed()) continue;
                            shardsBuilder.put(shardId, shard.getValue());
                        }
                        Map<ShardId, RestoreInProgress.ShardRestoreStatus> shards = Collections.unmodifiableMap(shardsBuilder);
                        RestoreInProgress.State newState = RestoreService.overallState(RestoreInProgress.State.STARTED, shards);
                        builder.add(new RestoreInProgress.Entry(entry.uuid(), entry.snapshot(), newState, entry.indices(), shards));
                        continue;
                    }
                    builder.add(entry);
                }
                return builder.build();
            }
            return oldRestore;
        }
    }

    public static final class RestoreCompletionResponse {
        private final String uuid;
        private final Snapshot snapshot;
        private final RestoreInfo restoreInfo;

        public RestoreCompletionResponse(String uuid, Snapshot snapshot, RestoreInfo restoreInfo) {
            this.uuid = uuid;
            this.snapshot = snapshot;
            this.restoreInfo = restoreInfo;
        }

        public String getUuid() {
            return this.uuid;
        }

        public Snapshot getSnapshot() {
            return this.snapshot;
        }

        public RestoreInfo getRestoreInfo() {
            return this.restoreInfo;
        }
    }
}

