/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.snapshots;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchParseException;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.core.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ShardOperationFailedException;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.snapshots.IndexShardSnapshotFailedException;
import org.graylog.shaded.opensearch2.org.opensearch.core.rest.RestStatus;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ConstructingObjectParser;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;

@PublicApi(since="1.0.0")
public class SnapshotShardFailure
extends ShardOperationFailedException {
    @Nullable
    private String nodeId;
    private ShardId shardId;
    static final ConstructingObjectParser<SnapshotShardFailure, Void> SNAPSHOT_SHARD_FAILURE_PARSER = new ConstructingObjectParser("shard_failure", true, SnapshotShardFailure::constructSnapshotShardFailure);

    SnapshotShardFailure(StreamInput in) throws IOException {
        this.nodeId = in.readOptionalString();
        this.shardId = new ShardId(in);
        ((ShardOperationFailedException)this).shardId = this.shardId.getId();
        this.index = this.shardId.getIndexName();
        this.reason = in.readString();
        this.status = RestStatus.readFrom(in);
    }

    public SnapshotShardFailure(@Nullable String nodeId, ShardId shardId, String reason) {
        this(nodeId, shardId, reason, RestStatus.INTERNAL_SERVER_ERROR);
    }

    private SnapshotShardFailure(@Nullable String nodeId, ShardId shardId, String reason, RestStatus status) {
        super(shardId.getIndexName(), shardId.id(), reason, status, new IndexShardSnapshotFailedException(shardId, reason));
        this.nodeId = nodeId;
        this.shardId = shardId;
    }

    @Nullable
    public String nodeId() {
        return this.nodeId;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.nodeId);
        this.shardId.writeTo(out);
        out.writeString(this.reason);
        RestStatus.writeTo(out, this.status);
    }

    public String toString() {
        return "SnapshotShardFailure{shardId=" + String.valueOf(this.shardId) + ", reason='" + this.reason + "', nodeId='" + this.nodeId + "', status=" + String.valueOf((Object)this.status) + "}";
    }

    private static SnapshotShardFailure constructSnapshotShardFailure(Object[] args) {
        String index = (String)args[0];
        String indexUuid = (String)args[1];
        String nodeId = (String)args[2];
        String reason = (String)args[3];
        Integer intShardId = (Integer)args[4];
        String status = (String)args[5];
        if (index == null) {
            throw new OpenSearchParseException("index name was not set", new Object[0]);
        }
        if (intShardId == null) {
            throw new OpenSearchParseException("index shard was not set", new Object[0]);
        }
        ShardId shardId = new ShardId(index, indexUuid != null ? indexUuid : "_na_", intShardId);
        String nonNullReason = reason != null ? reason : "";
        RestStatus restStatus = status != null ? RestStatus.valueOf(status) : RestStatus.INTERNAL_SERVER_ERROR;
        return new SnapshotShardFailure(nodeId, shardId, nonNullReason, restStatus);
    }

    public static SnapshotShardFailure fromXContent(XContentParser parser) throws IOException {
        return SNAPSHOT_SHARD_FAILURE_PARSER.parse(parser, null);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("index", this.shardId.getIndexName());
        builder.field("index_uuid", this.shardId.getIndexName());
        builder.field("shard_id", this.shardId.id());
        builder.field("reason", this.reason);
        if (this.nodeId != null) {
            builder.field("node_id", this.nodeId);
        }
        builder.field("status", this.status.name());
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotShardFailure that = (SnapshotShardFailure)o;
        return this.shardId.id() == that.shardId.id() && this.shardId.getIndexName().equals(this.shardId.getIndexName()) && Objects.equals(this.reason, that.reason) && Objects.equals(this.nodeId, that.nodeId) && this.status.getStatus() == that.status.getStatus();
    }

    public int hashCode() {
        return Objects.hash(this.shardId.id(), this.shardId.getIndexName(), this.reason, this.nodeId, this.status.getStatus());
    }

    static {
        SNAPSHOT_SHARD_FAILURE_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("index", new String[0]));
        SNAPSHOT_SHARD_FAILURE_PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("index_uuid", new String[0]));
        SNAPSHOT_SHARD_FAILURE_PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("node_id", new String[0]));
        SNAPSHOT_SHARD_FAILURE_PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), new ParseField("reason", new String[0]));
        SNAPSHOT_SHARD_FAILURE_PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField("shard_id", new String[0]));
        SNAPSHOT_SHARD_FAILURE_PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("status", new String[0]));
    }
}

