/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.task.commons.task;

import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.ExperimentalApi;
import org.graylog.shaded.opensearch2.org.opensearch.task.commons.task.TaskId;
import org.graylog.shaded.opensearch2.org.opensearch.task.commons.task.TaskParams;
import org.graylog.shaded.opensearch2.org.opensearch.task.commons.task.TaskStatus;
import org.graylog.shaded.opensearch2.org.opensearch.task.commons.task.TaskType;
import org.graylog.shaded.opensearch2.org.opensearch.task.commons.worker.WorkerNode;

@ExperimentalApi
public class Task {
    private final TaskId taskId;
    private final TaskStatus taskStatus;
    private final TaskParams params;
    private final TaskType taskType;
    private final WorkerNode assignedNode;
    private final long createdAt;
    private final long assignedAt;
    private final long startedAt;
    private final long completedAt;
    private final long lastHeartbeatAt;

    public Task(TaskId taskId, TaskStatus taskStatus, TaskParams params, TaskType taskType, long createdAt, @Nullable long assignedAt, @Nullable long startedAt, @Nullable long completedAt, @Nullable long lastHeartbeatAt, @Nullable WorkerNode assignedNode) {
        this.taskId = taskId;
        this.taskStatus = taskStatus;
        this.params = params;
        this.taskType = taskType;
        this.createdAt = createdAt;
        this.assignedAt = assignedAt;
        this.startedAt = startedAt;
        this.completedAt = completedAt;
        this.lastHeartbeatAt = lastHeartbeatAt;
        this.assignedNode = assignedNode;
    }

    public TaskId getTaskId() {
        return this.taskId;
    }

    public TaskStatus getTaskStatus() {
        return this.taskStatus;
    }

    public TaskParams getParams() {
        return this.params;
    }

    public TaskType getTaskType() {
        return this.taskType;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public long getAssignedAt() {
        return this.assignedAt;
    }

    public long getStartedAt() {
        return this.startedAt;
    }

    public long getCompletedAt() {
        return this.completedAt;
    }

    public long getLastHeartbeatAt() {
        return this.lastHeartbeatAt;
    }

    public WorkerNode getAssignedNode() {
        return this.assignedNode;
    }

    public static class Builder {
        private final TaskId taskId;
        private TaskStatus taskStatus;
        private final TaskParams params;
        private final TaskType taskType;
        private WorkerNode assignedNode;
        private final long createdAt;
        private long assignedAt;
        private long startedAt;
        private long completedAt;
        private long lastHeartbeatAt;

        private Builder(TaskId taskId, TaskStatus taskStatus, TaskParams params, TaskType taskType, long createdAt) {
            this.taskId = taskId;
            this.taskStatus = taskStatus;
            this.params = params;
            this.taskType = taskType;
            this.createdAt = createdAt;
        }

        public static Builder builder(Task task) {
            Builder builder = new Builder(task.getTaskId(), task.getTaskStatus(), task.getParams(), task.getTaskType(), task.getCreatedAt());
            builder.assignedAt(task.getAssignedAt());
            builder.startedAt(task.getStartedAt());
            builder.completedAt(task.getCompletedAt());
            builder.lastHeartbeatAt(task.getLastHeartbeatAt());
            builder.assignedNode(task.getAssignedNode());
            return builder;
        }

        public static Builder builder(TaskId taskId, TaskStatus taskStatus, TaskParams params, TaskType taskType, long createdAt) {
            return new Builder(taskId, taskStatus, params, taskType, createdAt);
        }

        public void assignedAt(long assignedAt) {
            this.assignedAt = assignedAt;
        }

        public void startedAt(long startedAt) {
            this.startedAt = startedAt;
        }

        public void completedAt(long completedAt) {
            this.completedAt = completedAt;
        }

        public void lastHeartbeatAt(long lastHeartbeatAt) {
            this.lastHeartbeatAt = lastHeartbeatAt;
        }

        public void taskStatus(TaskStatus taskStatus) {
            this.taskStatus = taskStatus;
        }

        public void assignedNode(WorkerNode node) {
            this.assignedNode = node;
        }

        public Task build() {
            return new Task(this.taskId, this.taskStatus, this.params, this.taskType, this.createdAt, this.assignedAt, this.startedAt, this.completedAt, this.lastHeartbeatAt, this.assignedNode);
        }
    }
}

