/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.tasks;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.opensearch2.org.opensearch.ExceptionsHelper;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.ResourceAlreadyExistsException;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.bulk.BackoffPolicy;
import org.graylog.shaded.opensearch2.org.opensearch.action.index.IndexRequestBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.action.index.IndexResponse;
import org.graylog.shaded.opensearch2.org.opensearch.client.Client;
import org.graylog.shaded.opensearch2.org.opensearch.client.OriginSettingClient;
import org.graylog.shaded.opensearch2.org.opensearch.client.Requests;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.MappingMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.Inject;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.io.Streams;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.core.concurrency.OpenSearchRejectedExecutionException;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.MediaTypeRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.tasks.TaskResult;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;

public class TaskResultsService {
    private static final Logger logger = LogManager.getLogger(TaskResultsService.class);
    public static final String TASK_INDEX = ".tasks";
    public static final String TASK_RESULT_INDEX_MAPPING_FILE = "task-index-mapping.json";
    public static final String TASK_RESULT_MAPPING_VERSION_META_FIELD = "version";
    public static final int TASK_RESULT_MAPPING_VERSION = 5;
    static final BackoffPolicy STORE_BACKOFF_POLICY = BackoffPolicy.exponentialBackoff(TimeValue.timeValueMillis(250L), 14);
    private final Client client;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;

    @Inject
    public TaskResultsService(Client client, ClusterService clusterService, ThreadPool threadPool) {
        this.client = new OriginSettingClient(client, "tasks");
        this.clusterService = clusterService;
        this.threadPool = threadPool;
    }

    public void storeResult(final TaskResult taskResult, final ActionListener<Void> listener) {
        ClusterState state = this.clusterService.state();
        if (!state.routingTable().hasIndex(TASK_INDEX)) {
            CreateIndexRequest createIndexRequest = new CreateIndexRequest();
            createIndexRequest.settings(this.taskResultIndexSettings());
            createIndexRequest.index(TASK_INDEX);
            createIndexRequest.mapping(this.taskResultIndexMapping());
            createIndexRequest.cause("auto(task api)");
            this.client.admin().indices().create(createIndexRequest, new ActionListener<CreateIndexResponse>(){

                @Override
                public void onResponse(CreateIndexResponse result) {
                    TaskResultsService.this.doStoreResult(taskResult, listener);
                }

                @Override
                public void onFailure(Exception e) {
                    if (ExceptionsHelper.unwrapCause(e) instanceof ResourceAlreadyExistsException) {
                        try {
                            TaskResultsService.this.doStoreResult(taskResult, listener);
                        }
                        catch (Exception inner) {
                            inner.addSuppressed(e);
                            listener.onFailure(inner);
                        }
                    } else {
                        listener.onFailure(e);
                    }
                }
            });
        } else {
            IndexMetadata metadata = state.getMetadata().index(TASK_INDEX);
            if (this.getTaskResultMappingVersion(metadata) < 5) {
                this.client.admin().indices().preparePutMapping(TASK_INDEX).setSource(this.taskResultIndexMapping(), MediaTypeRegistry.JSON).execute(ActionListener.delegateFailure(listener, (l, r) -> this.doStoreResult(taskResult, listener)));
            } else {
                this.doStoreResult(taskResult, listener);
            }
        }
    }

    private int getTaskResultMappingVersion(IndexMetadata metadata) {
        MappingMetadata mappingMetadata = metadata.mapping();
        if (mappingMetadata == null) {
            return 0;
        }
        Map meta = (Map)mappingMetadata.sourceAsMap().get("_meta");
        if (meta == null || !meta.containsKey(TASK_RESULT_MAPPING_VERSION_META_FIELD)) {
            return 1;
        }
        return (Integer)meta.get(TASK_RESULT_MAPPING_VERSION_META_FIELD);
    }

    private void doStoreResult(TaskResult taskResult, ActionListener<Void> listener) {
        IndexRequestBuilder index = this.client.prepareIndex(TASK_INDEX).setId(taskResult.getTask().getTaskId().toString());
        try (XContentBuilder builder = MediaTypeRegistry.contentBuilder(Requests.INDEX_CONTENT_TYPE);){
            taskResult.toXContent(builder, ToXContent.EMPTY_PARAMS);
            index.setSource(builder);
        }
        catch (IOException e) {
            throw new OpenSearchException("Couldn't convert task result to XContent for [{}]", (Throwable)e, taskResult.getTask());
        }
        this.doStoreResult(STORE_BACKOFF_POLICY.iterator(), index, listener);
    }

    private void doStoreResult(final Iterator<TimeValue> backoff, final IndexRequestBuilder index, final ActionListener<Void> listener) {
        index.execute(new ActionListener<IndexResponse>(){

            @Override
            public void onResponse(IndexResponse indexResponse) {
                listener.onResponse(null);
            }

            @Override
            public void onFailure(Exception e) {
                if (!(e instanceof OpenSearchRejectedExecutionException) || !backoff.hasNext()) {
                    listener.onFailure(e);
                } else {
                    TimeValue wait = (TimeValue)backoff.next();
                    logger.warn(() -> new ParameterizedMessage("failed to store task result, retrying in [{}]", (Object)wait), (Throwable)e);
                    TaskResultsService.this.threadPool.schedule(() -> TaskResultsService.this.doStoreResult(backoff, index, listener), wait, "same");
                }
            }
        });
    }

    private Settings taskResultIndexSettings() {
        return Settings.builder().put(IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.getKey(), 1).put(IndexMetadata.INDEX_AUTO_EXPAND_REPLICAS_SETTING.getKey(), "0-1").put("index.priority", Integer.MAX_VALUE).build();
    }

    public String taskResultIndexMapping() {
        String string;
        block8: {
            InputStream is = this.getClass().getResourceAsStream(TASK_RESULT_INDEX_MAPPING_FILE);
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                Streams.copy(is, out);
                string = out.toString(StandardCharsets.UTF_8.name());
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    logger.error(() -> new ParameterizedMessage("failed to create tasks results index template [{}]", (Object)TASK_RESULT_INDEX_MAPPING_FILE), (Throwable)e);
                    throw new IllegalStateException("failed to create tasks results index template [task-index-mapping.json]", e);
                }
            }
            is.close();
        }
        return string;
    }
}

