/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.InternalApi;
import org.graylog.shaded.opensearch2.org.opensearch.telemetry.TelemetrySettings;
import org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing.ScopedSpan;
import org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing.Span;
import org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing.SpanContext;
import org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing.SpanCreationContext;
import org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing.SpanScope;
import org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing.Tracer;
import org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing.noop.NoopTracer;

@InternalApi
final class WrappedTracer
implements Tracer {
    private final Tracer defaultTracer;
    private final TelemetrySettings telemetrySettings;

    public WrappedTracer(TelemetrySettings telemetrySettings, Tracer defaultTracer) {
        this.defaultTracer = defaultTracer;
        this.telemetrySettings = telemetrySettings;
    }

    @Override
    public Span startSpan(SpanCreationContext context) {
        return this.getDelegateTracer().startSpan(context);
    }

    @Override
    public SpanContext getCurrentSpan() {
        Tracer delegateTracer = this.getDelegateTracer();
        return delegateTracer.getCurrentSpan();
    }

    @Override
    public ScopedSpan startScopedSpan(SpanCreationContext spanCreationContext) {
        return this.getDelegateTracer().startScopedSpan(spanCreationContext);
    }

    @Override
    public SpanScope withSpanInScope(Span span) {
        return this.getDelegateTracer().withSpanInScope(span);
    }

    @Override
    public boolean isRecording() {
        return this.getDelegateTracer().isRecording();
    }

    @Override
    public void close() throws IOException {
        this.defaultTracer.close();
    }

    Tracer getDelegateTracer() {
        return this.telemetrySettings.isTracingEnabled() ? this.defaultTracer : NoopTracer.INSTANCE;
    }

    @Override
    public Span startSpan(SpanCreationContext spanCreationContext, Map<String, Collection<String>> headers) {
        return this.defaultTracer.startSpan(spanCreationContext, headers);
    }
}

