/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.transport;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.graylog.shaded.opensearch2.org.opensearch.LegacyESVersion;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.transport.TransportAddress;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentFragment;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.transport.RemoteConnectionStrategy;
import org.graylog.shaded.opensearch2.org.opensearch.transport.SniffConnectionStrategy;

@PublicApi(since="1.0.0")
public final class RemoteConnectionInfo
implements ToXContentFragment,
Writeable {
    final ModeInfo modeInfo;
    final TimeValue initialConnectionTimeout;
    final String clusterAlias;
    final boolean skipUnavailable;

    public RemoteConnectionInfo(String clusterAlias, ModeInfo modeInfo, TimeValue initialConnectionTimeout, boolean skipUnavailable) {
        this.clusterAlias = clusterAlias;
        this.modeInfo = modeInfo;
        this.initialConnectionTimeout = initialConnectionTimeout;
        this.skipUnavailable = skipUnavailable;
    }

    public RemoteConnectionInfo(StreamInput input) throws IOException {
        if (input.getVersion().onOrAfter(LegacyESVersion.V_7_6_0)) {
            RemoteConnectionStrategy.ConnectionStrategy mode = input.readEnum(RemoteConnectionStrategy.ConnectionStrategy.class);
            this.modeInfo = mode.getReader().read(input);
            this.initialConnectionTimeout = input.readTimeValue();
            this.clusterAlias = input.readString();
            this.skipUnavailable = input.readBoolean();
        } else {
            List<String> seedNodes;
            if (input.getVersion().onOrAfter(LegacyESVersion.V_7_0_0)) {
                seedNodes = Arrays.asList(input.readStringArray());
            } else {
                List<TransportAddress> transportAddresses = input.readList(TransportAddress::new);
                seedNodes = transportAddresses.stream().map(a -> a.address().getHostString() + ":" + a.address().getPort()).collect(Collectors.toList());
                input.readList(TransportAddress::new);
            }
            int connectionsPerCluster = input.readVInt();
            this.initialConnectionTimeout = input.readTimeValue();
            int numNodesConnected = input.readVInt();
            this.clusterAlias = input.readString();
            this.skipUnavailable = input.readBoolean();
            this.modeInfo = new SniffConnectionStrategy.SniffModeInfo(seedNodes, connectionsPerCluster, numNodesConnected);
        }
    }

    public boolean isConnected() {
        return this.modeInfo.isConnected();
    }

    public String getClusterAlias() {
        return this.clusterAlias;
    }

    public ModeInfo getModeInfo() {
        return this.modeInfo;
    }

    public TimeValue getInitialConnectionTimeout() {
        return this.initialConnectionTimeout;
    }

    public boolean isSkipUnavailable() {
        return this.skipUnavailable;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(LegacyESVersion.V_7_6_0)) {
            out.writeEnum(this.modeInfo.modeType());
            this.modeInfo.writeTo(out);
            out.writeTimeValue(this.initialConnectionTimeout);
        } else if (this.modeInfo.modeType() == RemoteConnectionStrategy.ConnectionStrategy.SNIFF) {
            SniffConnectionStrategy.SniffModeInfo sniffInfo = (SniffConnectionStrategy.SniffModeInfo)this.modeInfo;
            if (out.getVersion().onOrAfter(LegacyESVersion.V_7_0_0)) {
                out.writeStringArray(sniffInfo.seedNodes.toArray(new String[0]));
            } else {
                out.writeList(sniffInfo.seedNodes.stream().map(s -> {
                    String host = RemoteConnectionStrategy.parseHost(s);
                    int port = RemoteConnectionStrategy.parsePort(s);
                    try {
                        return new TransportAddress(InetAddress.getByAddress(host, TransportAddress.META_ADDRESS.getAddress()), port);
                    }
                    catch (UnknownHostException e) {
                        throw new AssertionError((Object)e);
                    }
                }).collect(Collectors.toList()));
                out.writeList(Collections.emptyList());
            }
            out.writeVInt(sniffInfo.maxConnectionsPerCluster);
            out.writeTimeValue(this.initialConnectionTimeout);
            out.writeVInt(sniffInfo.numNodesConnected);
        } else {
            if (out.getVersion().onOrAfter(LegacyESVersion.V_7_0_0)) {
                out.writeStringArray(new String[0]);
            } else {
                out.writeList(Collections.emptyList());
                out.writeList(Collections.emptyList());
            }
            out.writeVInt(0);
            out.writeTimeValue(this.initialConnectionTimeout);
            out.writeVInt(0);
        }
        out.writeString(this.clusterAlias);
        out.writeBoolean(this.skipUnavailable);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.clusterAlias);
        builder.field("connected", this.modeInfo.isConnected());
        builder.field("mode", this.modeInfo.modeName());
        this.modeInfo.toXContent(builder, params);
        builder.field("initial_connect_timeout", this.initialConnectionTimeout);
        builder.field("skip_unavailable", this.skipUnavailable);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteConnectionInfo that = (RemoteConnectionInfo)o;
        return this.skipUnavailable == that.skipUnavailable && Objects.equals(this.modeInfo, that.modeInfo) && Objects.equals(this.initialConnectionTimeout, that.initialConnectionTimeout) && Objects.equals(this.clusterAlias, that.clusterAlias);
    }

    public int hashCode() {
        return Objects.hash(this.modeInfo, this.initialConnectionTimeout, this.clusterAlias, this.skipUnavailable);
    }

    @PublicApi(since="1.0.0")
    public static interface ModeInfo
    extends ToXContentFragment,
    Writeable {
        public boolean isConnected();

        public String modeName();

        public RemoteConnectionStrategy.ConnectionStrategy modeType();
    }
}

