/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.transport;

import java.util.concurrent.atomic.LongAdder;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.metrics.MeanMetric;

@PublicApi(since="1.0.0")
public final class StatsTracker {
    private final LongAdder bytesRead = new LongAdder();
    private final LongAdder messagesReceived = new LongAdder();
    private final MeanMetric writeBytesMetric = new MeanMetric();

    public void markBytesRead(long bytesReceived) {
        this.bytesRead.add(bytesReceived);
    }

    public void markMessageReceived() {
        this.messagesReceived.increment();
    }

    public void markBytesWritten(long bytesWritten) {
        this.writeBytesMetric.inc(bytesWritten);
    }

    public long getBytesRead() {
        return this.bytesRead.sum();
    }

    public long getMessagesReceived() {
        return this.messagesReceived.sum();
    }

    public MeanMetric getWriteBytes() {
        return this.writeBytesMetric;
    }

    public long getBytesWritten() {
        return this.writeBytesMetric.sum();
    }

    public long getMessagesSent() {
        return this.writeBytesMetric.count();
    }
}

