/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.wlm;

import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.tasks.Task;
import org.graylog.shaded.opensearch2.org.opensearch.wlm.WorkloadManagementSettings;
import org.graylog.shaded.opensearch2.org.opensearch.wlm.tracker.CpuUsageCalculator;
import org.graylog.shaded.opensearch2.org.opensearch.wlm.tracker.MemoryUsageCalculator;
import org.graylog.shaded.opensearch2.org.opensearch.wlm.tracker.ResourceUsageCalculator;

@PublicApi(since="2.17.0")
public enum ResourceType {
    CPU("cpu", true, CpuUsageCalculator.INSTANCE, WorkloadManagementSettings::getNodeLevelCpuCancellationThreshold),
    MEMORY("memory", true, MemoryUsageCalculator.INSTANCE, WorkloadManagementSettings::getNodeLevelMemoryCancellationThreshold);

    private final String name;
    private final boolean statsEnabled;
    private final ResourceUsageCalculator resourceUsageCalculator;
    private final Function<WorkloadManagementSettings, Double> nodeLevelThresholdSupplier;
    private static List<ResourceType> sortedValues;

    private ResourceType(String name, boolean statsEnabled, ResourceUsageCalculator resourceUsageCalculator, Function<WorkloadManagementSettings, Double> nodeLevelThresholdSupplier) {
        this.name = name;
        this.statsEnabled = statsEnabled;
        this.resourceUsageCalculator = resourceUsageCalculator;
        this.nodeLevelThresholdSupplier = nodeLevelThresholdSupplier;
    }

    public static ResourceType fromName(String s) {
        for (ResourceType resourceType : ResourceType.values()) {
            if (!resourceType.getName().equals(s)) continue;
            return resourceType;
        }
        throw new IllegalArgumentException("Unknown resource type: [" + s + "]");
    }

    public static void writeTo(StreamOutput out, ResourceType resourceType) throws IOException {
        out.writeString(resourceType.getName());
    }

    public String getName() {
        return this.name;
    }

    @Deprecated(forRemoval=true)
    public long getResourceUsage(Task task) {
        if (this.name.equals(ResourceType.CPU.name)) {
            return task.getTotalResourceStats().getCpuTimeInNanos();
        }
        return task.getTotalResourceStats().getMemoryInBytes();
    }

    public boolean hasStatsEnabled() {
        return this.statsEnabled;
    }

    public ResourceUsageCalculator getResourceUsageCalculator() {
        return this.resourceUsageCalculator;
    }

    public double getNodeLevelThreshold(WorkloadManagementSettings settings) {
        return this.nodeLevelThresholdSupplier.apply(settings);
    }

    public static List<ResourceType> getSortedValues() {
        return sortedValues;
    }

    static {
        sortedValues = List.of(CPU, MEMORY);
    }
}

